/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.EditBootstrapQueriesDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.EditObjectFilterDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.EditShellCommandsDialog;
import org.jkiss.utils.CommonUtils;

class ConnectionPageGeneral
extends ActiveWizardPage<ConnectionWizard> {
    private static final Log log = Log.getLog(ConnectionPageGeneral.class);
    private ConnectionWizard wizard;
    private DataSourceDescriptor dataSourceDescriptor;
    private Text connectionNameText;
    private CSmartCombo<DBPConnectionType> connectionTypeCombo;
    private CSmartCombo<DBPDataSourceFolder> connectionFolderCombo;
    private Button savePasswordCheck;
    private Button autocommit;
    private Combo isolationLevel;
    private Combo defaultSchema;
    private Spinner keepAliveInterval;
    private Button showSystemObjects;
    private Button showUtilityObjects;
    private Button readOnlyConnection;
    private Button eventsButton;
    private Font boldFont;
    private boolean connectionNameChanged = false;
    private List<FilterInfo> filters = new ArrayList<FilterInfo>();
    private Group filtersGroup;
    private boolean activated = false;
    private List<DBPTransactionIsolation> supportedLevels = new ArrayList<DBPTransactionIsolation>();
    private List<String> bootstrapQueries;
    private boolean ignoreBootstrapErrors;
    private Text descriptionText;
    private DBPDataSourceFolder dataSourceFolder;

    ConnectionPageGeneral(ConnectionWizard wizard) {
        super("newConnectionFinal");
        this.wizard = wizard;
        this.setTitle(wizard.isNew() ? CoreMessages.dialog_connection_wizard_final_header : CoreMessages.dialog_connection_edit_wizard_general);
        this.setDescription(CoreMessages.dialog_connection_wizard_final_description);
        this.filters.add(new FilterInfo(DBSCatalog.class, CoreMessages.dialog_connection_wizard_final_filter_catalogs));
        this.filters.add(new FilterInfo(DBSSchema.class, CoreMessages.dialog_connection_wizard_final_filter_schemas_users));
        this.filters.add(new FilterInfo(DBSTable.class, CoreMessages.dialog_connection_wizard_final_filter_tables));
        this.bootstrapQueries = new ArrayList<String>();
    }

    ConnectionPageGeneral(ConnectionWizard wizard, DataSourceDescriptor dataSourceDescriptor) {
        this(wizard);
        this.dataSourceDescriptor = dataSourceDescriptor;
        for (FilterInfo filterInfo : this.filters) {
            filterInfo.filter = dataSourceDescriptor.getObjectFilter(filterInfo.type, null, false);
        }
        this.bootstrapQueries = dataSourceDescriptor.getConnectionConfiguration().getBootstrap().getInitQueries();
        this.ignoreBootstrapErrors = dataSourceDescriptor.getConnectionConfiguration().getBootstrap().isIgnoreErrors();
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.boldFont);
        super.dispose();
    }

    @Override
    public void activatePage() {
        if (this.connectionNameText != null) {
            String newName;
            ConnectionPageSettings settings = this.wizard.getPageSettings();
            if (settings != null) {
                DBPConnectionConfiguration connectionInfo = settings.getActiveDataSource().getConnectionConfiguration();
                String string = newName = this.dataSourceDescriptor == null ? "" : settings.getActiveDataSource().getName();
                if (CommonUtils.isEmpty((String)newName)) {
                    newName = connectionInfo.getDatabaseName();
                    if (CommonUtils.isEmpty((String)newName)) {
                        newName = connectionInfo.getHostName();
                    }
                    if (CommonUtils.isEmpty((String)newName)) {
                        newName = connectionInfo.getUrl();
                    }
                    if (CommonUtils.isEmpty((String)newName)) {
                        newName = CoreMessages.dialog_connection_wizard_final_default_new_connection_name;
                    }
                    StringTokenizer st = new StringTokenizer(newName, "/\\:,?=%$#@!^&*()");
                    while (st.hasMoreTokens()) {
                        newName = st.nextToken();
                    }
                    newName = !CommonUtils.isEmpty((String)settings.getDriver().getCategory()) ? String.valueOf(settings.getDriver().getCategory()) + " - " + newName : String.valueOf(settings.getDriver().getName()) + " - " + newName;
                    newName = CommonUtils.truncateString((String)newName, (int)50);
                }
            } else {
                newName = this.wizard.getSelectedDriver().getName();
            }
            if (CommonUtils.isEmpty((String)this.connectionNameText.getText()) || !this.connectionNameChanged) {
                if (newName != null) {
                    this.connectionNameText.setText(newName);
                }
                this.connectionNameChanged = false;
            }
        }
        if (this.dataSourceDescriptor != null) {
            if (!this.activated) {
                DBPConnectionConfiguration conConfig = this.dataSourceDescriptor.getConnectionConfiguration();
                this.connectionTypeCombo.select(conConfig.getConnectionType());
                this.dataSourceFolder = this.dataSourceDescriptor.getFolder();
                if (this.dataSourceDescriptor.getFolder() == null) {
                    this.connectionFolderCombo.select(0);
                } else {
                    this.connectionFolderCombo.select(this.dataSourceFolder);
                }
                this.savePasswordCheck.setSelection(this.dataSourceDescriptor.isSavePassword());
                this.autocommit.setSelection(this.dataSourceDescriptor.isDefaultAutoCommit());
                this.showSystemObjects.setSelection(this.dataSourceDescriptor.isShowSystemObjects());
                this.showUtilityObjects.setSelection(this.dataSourceDescriptor.isShowUtilityObjects());
                this.readOnlyConnection.setSelection(this.dataSourceDescriptor.isConnectionReadOnly());
                this.isolationLevel.add("");
                DataSourceDescriptor originalDataSource = ((ConnectionWizard)((Object)this.getWizard())).getOriginalDataSource();
                if (originalDataSource != null && originalDataSource.isConnected()) {
                    DBPDataSource dataSource2 = originalDataSource.getDataSource();
                    this.isolationLevel.setEnabled(!this.autocommit.getSelection());
                    this.supportedLevels.clear();
                    DBPTransactionIsolation defaultLevel = this.dataSourceDescriptor.getActiveTransactionsIsolation();
                    for (DBPTransactionIsolation level : CommonUtils.safeCollection((Collection)dataSource2.getInfo().getSupportedTransactionsIsolation())) {
                        if (!level.isEnabled()) continue;
                        this.isolationLevel.add(level.getTitle());
                        this.supportedLevels.add(level);
                        if (!level.equals(defaultLevel)) continue;
                        this.isolationLevel.select(this.isolationLevel.getItemCount() - 1);
                    }
                    if (dataSource2 instanceof DBSObjectContainer) {
                        new SchemaReadJob((DBSObjectContainer)dataSource2).schedule();
                    }
                } else {
                    this.isolationLevel.setEnabled(false);
                }
                this.defaultSchema.setText(CommonUtils.notEmpty((String)conConfig.getBootstrap().getDefaultObjectName()));
                this.keepAliveInterval.setSelection(conConfig.getKeepAliveInterval());
                if (this.dataSourceDescriptor.getDescription() != null) {
                    this.descriptionText.setText(this.dataSourceDescriptor.getDescription());
                }
                this.activated = true;
            }
        } else {
            if (this.eventsButton != null) {
                this.eventsButton.setFont(this.getFont());
                DataSourceDescriptor dataSource = this.getActiveDataSource();
                DBPConnectionEventType[] dBPConnectionEventTypeArray = dataSource.getConnectionConfiguration().getDeclaredEvents();
                int n = dBPConnectionEventTypeArray.length;
                int dataSource2 = 0;
                while (dataSource2 < n) {
                    DBPConnectionEventType eventType = dBPConnectionEventTypeArray[dataSource2];
                    if (dataSource.getConnectionConfiguration().getEvent(eventType).isEnabled()) {
                        this.eventsButton.setFont(this.boldFont);
                        break;
                    }
                    ++dataSource2;
                }
            }
            this.savePasswordCheck.setSelection(true);
            this.connectionTypeCombo.select(0);
            this.autocommit.setSelection(this.connectionTypeCombo.getItem(0).isAutocommit());
            if (this.dataSourceFolder != null) {
                this.connectionFolderCombo.select(this.dataSourceFolder);
            } else {
                this.connectionFolderCombo.select(0);
            }
            this.showSystemObjects.setSelection(true);
            this.showUtilityObjects.setSelection(false);
            this.readOnlyConnection.setSelection(false);
            this.isolationLevel.setEnabled(false);
            this.defaultSchema.setText("");
        }
        long features = this.wizard.getSelectedDriver().getDataSourceProvider().getFeatures();
        for (FilterInfo filterInfo : this.filters) {
            if (DBSCatalog.class.isAssignableFrom(filterInfo.type)) {
                this.enableFilter(filterInfo, (features & 1L) != 0L);
                continue;
            }
            if (DBSSchema.class.isAssignableFrom(filterInfo.type)) {
                this.enableFilter(filterInfo, (features & 2L) != 0L);
                continue;
            }
            this.enableFilter(filterInfo, true);
        }
        this.filtersGroup.layout();
    }

    @NotNull
    private DataSourceDescriptor getActiveDataSource() {
        ConnectionPageSettings pageSettings = ((ConnectionWizard)((Object)this.getWizard())).getPageSettings();
        return pageSettings == null ? this.wizard.getActiveDataSource() : pageSettings.getActiveDataSource();
    }

    private void enableFilter(FilterInfo filterInfo, boolean enable) {
        filterInfo.link.setEnabled(enable);
        if (enable) {
            filterInfo.link.setText("<a>" + filterInfo.title + "</a>");
            filterInfo.link.setToolTipText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_tooltip, (Object)filterInfo.title));
            if (filterInfo.filter != null && !filterInfo.filter.isNotApplicable()) {
                filterInfo.link.setFont(this.boldFont);
            } else {
                filterInfo.link.setFont(this.getFont());
            }
        } else {
            filterInfo.link.setText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_not_supported_text, (Object)filterInfo.title));
            filterInfo.link.setToolTipText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_not_supported_tooltip, (Object)filterInfo.title, (Object)this.wizard.getSelectedDriver().getName()));
        }
    }

    @Override
    public void deactivatePage() {
    }

    public void createControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont(parent.getFont());
        Composite group = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        group.setLayout((Layout)gl);
        String connectionName = this.dataSourceDescriptor == null ? "" : this.dataSourceDescriptor.getName();
        this.connectionNameText = UIUtils.createLabelText(group, CoreMessages.dialog_connection_wizard_final_label_connection_name, CommonUtils.toString((Object)connectionName));
        this.connectionNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionPageGeneral.this.connectionNameChanged = true;
                ConnectionPageGeneral.this.getContainer().updateButtons();
            }
        });
        UIUtils.createControlLabel(group, CoreMessages.dialog_connection_wizard_final_label_connection_type);
        Composite ctGroup = UIUtils.createPlaceholder(group, 2, 5);
        this.connectionTypeCombo = new CSmartCombo(ctGroup, 2060, (ILabelProvider)new ConnectionTypeLabelProvider());
        this.loadConnectionTypes();
        this.connectionTypeCombo.select(0);
        this.connectionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPConnectionType type = (DBPConnectionType)ConnectionPageGeneral.this.connectionTypeCombo.getItem(ConnectionPageGeneral.this.connectionTypeCombo.getSelectionIndex());
                ConnectionPageGeneral.this.autocommit.setSelection(type.isAutocommit());
            }
        });
        Button pickerButton = new Button(ctGroup, 8);
        pickerButton.setText(CoreMessages.dialog_connection_wizard_final_label_edit);
        pickerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourceDescriptor dataSource = ConnectionPageGeneral.this.getActiveDataSource();
                UIUtils.showPreferencesFor(ConnectionPageGeneral.this.getControl().getShell(), dataSource.getConnectionConfiguration().getConnectionType(), "org.jkiss.dbeaver.preferences.connectionTypes");
                ConnectionPageGeneral.this.loadConnectionTypes();
                DBPConnectionType connectionType = dataSource.getConnectionConfiguration().getConnectionType();
                ConnectionPageGeneral.this.connectionTypeCombo.select(connectionType);
                ConnectionPageGeneral.this.autocommit.setSelection(connectionType.isAutocommit());
            }
        });
        UIUtils.createControlLabel(group, CoreMessages.dialog_connection_wizard_final_label_connection_folder);
        this.connectionFolderCombo = new CSmartCombo(group, 2060, (ILabelProvider)new ConnectionFolderLabelProvider());
        this.loadConnectionFolders();
        this.connectionFolderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPageGeneral.this.dataSourceFolder = (DBPDataSourceFolder)ConnectionPageGeneral.this.connectionFolderCombo.getItem(ConnectionPageGeneral.this.connectionFolderCombo.getSelectionIndex());
            }
        });
        Composite optionsGroup = new Composite(group, 0);
        gl = new GridLayout(2, true);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 5;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        optionsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        Composite leftSide = UIUtils.createPlaceholder(optionsGroup, 1, 5);
        leftSide.setLayoutData((Object)new GridData(770));
        Composite rightSide = UIUtils.createPlaceholder(optionsGroup, 1, 5);
        rightSide.setLayoutData((Object)new GridData(770));
        Group securityGroup = UIUtils.createControlGroup(leftSide, CoreMessages.dialog_connection_wizard_final_group_security, 1, 770, 0);
        this.savePasswordCheck = UIUtils.createCheckbox((Composite)securityGroup, CoreMessages.dialog_connection_wizard_final_checkbox_save_password_locally, this.dataSourceDescriptor == null || this.dataSourceDescriptor.isSavePassword());
        this.savePasswordCheck.setLayoutData((Object)new GridData(32));
        Group txnGroup = UIUtils.createControlGroup(rightSide, CoreMessages.dialog_connection_wizard_final_label_connection, 2, 770, 0);
        this.autocommit = UIUtils.createLabelCheckbox((Composite)txnGroup, CoreMessages.dialog_connection_wizard_final_checkbox_auto_commit, "Sets auto-commit mode for all connections", this.dataSourceDescriptor != null && this.dataSourceDescriptor.isDefaultAutoCommit());
        this.autocommit.setLayoutData((Object)new GridData(32));
        this.autocommit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionPageGeneral.this.dataSourceDescriptor != null && ConnectionPageGeneral.this.dataSourceDescriptor.isConnected()) {
                    ConnectionPageGeneral.this.isolationLevel.setEnabled(!ConnectionPageGeneral.this.autocommit.getSelection());
                }
            }
        });
        this.isolationLevel = UIUtils.createLabelCombo((Composite)txnGroup, CoreMessages.dialog_connection_wizard_final_label_isolation_level, CoreMessages.dialog_connection_wizard_final_label_isolation_level_tooltip, 12);
        this.defaultSchema = UIUtils.createLabelCombo((Composite)txnGroup, CoreMessages.dialog_connection_wizard_final_label_default_schema, CoreMessages.dialog_connection_wizard_final_label_default_schema_tooltip, 4);
        this.keepAliveInterval = UIUtils.createLabelSpinner((Composite)txnGroup, CoreMessages.dialog_connection_wizard_final_label_keepalive, CoreMessages.dialog_connection_wizard_final_label_keepalive_tooltip, 0, 0, Short.MAX_VALUE);
        String bootstrapTooltip = CoreMessages.dialog_connection_wizard_final_label_bootstrap_tooltip;
        UIUtils.createControlLabel((Composite)txnGroup, CoreMessages.dialog_connection_wizard_final_label_bootstrap_query).setToolTipText(bootstrapTooltip);
        Button queriesConfigButton = UIUtils.createPushButton((Composite)txnGroup, CoreMessages.dialog_connection_wizard_configure, DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT));
        queriesConfigButton.setToolTipText(bootstrapTooltip);
        if (this.dataSourceDescriptor != null && !CommonUtils.isEmpty((Collection)this.dataSourceDescriptor.getConnectionConfiguration().getBootstrap().getInitQueries())) {
            queriesConfigButton.setFont(this.boldFont);
        }
        queriesConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditBootstrapQueriesDialog dialog = new EditBootstrapQueriesDialog(ConnectionPageGeneral.this.getShell(), ConnectionPageGeneral.this.bootstrapQueries, ConnectionPageGeneral.this.ignoreBootstrapErrors);
                if (dialog.open() == 0) {
                    ConnectionPageGeneral.this.bootstrapQueries = dialog.getQueries();
                    ConnectionPageGeneral.this.ignoreBootstrapErrors = dialog.isIgnoreErrors();
                }
            }
        });
        if (((ConnectionWizard)((Object)this.getWizard())).isNew()) {
            UIUtils.createControlLabel((Composite)txnGroup, CoreMessages.dialog_connection_wizard_final_label_shell_command);
            this.eventsButton = new Button((Composite)txnGroup, 8);
            this.eventsButton.setText(CoreMessages.dialog_connection_wizard_configure);
            this.eventsButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.EVENT));
            this.eventsButton.setLayoutData((Object)new GridData(32));
            this.eventsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageGeneral.this.configureEvents();
                }
            });
        }
        Group miscGroup = UIUtils.createControlGroup(leftSide, CoreMessages.dialog_connection_wizard_final_group_misc, 1, 770, 0);
        this.showSystemObjects = UIUtils.createCheckbox((Composite)miscGroup, CoreMessages.dialog_connection_wizard_final_checkbox_show_system_objects, this.dataSourceDescriptor == null || this.dataSourceDescriptor.isShowSystemObjects());
        this.showSystemObjects.setLayoutData((Object)new GridData(32));
        this.showUtilityObjects = UIUtils.createCheckbox((Composite)miscGroup, CoreMessages.dialog_connection_wizard_final_checkbox_show_util_objects, this.dataSourceDescriptor == null || this.dataSourceDescriptor.isShowUtilityObjects());
        this.showUtilityObjects.setLayoutData((Object)new GridData(32));
        this.readOnlyConnection = UIUtils.createCheckbox((Composite)miscGroup, CoreMessages.dialog_connection_wizard_final_checkbox_connection_readonly, this.dataSourceDescriptor != null && this.dataSourceDescriptor.isConnectionReadOnly());
        gd = new GridData(32);
        this.readOnlyConnection.setLayoutData((Object)gd);
        this.filtersGroup = UIUtils.createControlGroup(leftSide, CoreMessages.dialog_connection_wizard_final_group_filters, 1, 770, 0);
        int i = 0;
        while (i < this.filters.size()) {
            final FilterInfo filterInfo = this.filters.get(i);
            filterInfo.link = UIUtils.createLink((Composite)this.filtersGroup, "<a>" + filterInfo.title + "</a>", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditObjectFilterDialog dialog = new EditObjectFilterDialog(ConnectionPageGeneral.this.getShell(), ConnectionPageGeneral.this.dataSourceDescriptor.getRegistry(), filterInfo.title, filterInfo.filter != null ? filterInfo.filter : new DBSObjectFilter(), true);
                    if (dialog.open() == 0) {
                        filterInfo.filter = dialog.getFilter();
                        if (filterInfo.filter != null && !filterInfo.filter.isNotApplicable()) {
                            filterInfo.link.setFont(ConnectionPageGeneral.this.boldFont);
                        } else {
                            filterInfo.link.setFont(ConnectionPageGeneral.this.getFont());
                        }
                    }
                }
            });
            ++i;
        }
        Group descGroup = UIUtils.createControlGroup(group, CoreMessages.dialog_connection_wizard_description, 1, 768, 0);
        ((GridData)descGroup.getLayoutData()).horizontalSpan = 2;
        this.descriptionText = new Text((Composite)descGroup, 2626);
        gd = new GridData(1808);
        gd.heightHint = this.descriptionText.getLineHeight() * 3;
        this.descriptionText.setLayoutData((Object)gd);
        this.setControl((Control)group);
        UIUtils.setHelp((Control)group, "con-wizard-final");
    }

    private void loadConnectionTypes() {
        this.connectionTypeCombo.removeAll();
        for (DBPConnectionType ct : DataSourceProviderRegistry.getInstance().getConnectionTypes()) {
            this.connectionTypeCombo.addItem(ct);
        }
    }

    private void loadConnectionFolders() {
        this.connectionFolderCombo.removeAll();
        this.connectionFolderCombo.addItem(null);
        for (DBPDataSourceFolder folder : ((ConnectionWizard)((Object)this.getWizard())).getDataSourceRegistry().getRootFolders()) {
            this.loadConnectionFolder(0, folder);
        }
    }

    private void loadConnectionFolder(int level, DBPDataSourceFolder folder) {
        this.connectionFolderCombo.addItem(folder);
        DBPDataSourceFolder[] dBPDataSourceFolderArray = folder.getChildren();
        int n = dBPDataSourceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPDataSourceFolder child = dBPDataSourceFolderArray[n2];
            this.loadConnectionFolder(level + 1, child);
            ++n2;
        }
    }

    public boolean isPageComplete() {
        return this.connectionNameText != null && !CommonUtils.isEmpty((String)this.connectionNameText.getText());
    }

    void saveSettings(DataSourceDescriptor dataSource) {
        if (this.dataSourceDescriptor != null && !this.activated) {
            return;
        }
        dataSource.setName(this.connectionNameText.getText());
        dataSource.setSavePassword(this.savePasswordCheck.getSelection());
        try {
            dataSource.setDefaultAutoCommit(this.autocommit.getSelection(), null, true, null);
            if (dataSource.isConnected()) {
                int levelIndex = this.isolationLevel.getSelectionIndex();
                if (levelIndex <= 0) {
                    dataSource.setDefaultTransactionsIsolation(null);
                } else {
                    dataSource.setDefaultTransactionsIsolation(this.supportedLevels.get(levelIndex - 1));
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        dataSource.setDefaultActiveObject(this.defaultSchema.getText());
        dataSource.setShowSystemObjects(this.showSystemObjects.getSelection());
        dataSource.setShowUtilityObjects(this.showUtilityObjects.getSelection());
        dataSource.setConnectionReadOnly(this.readOnlyConnection.getSelection());
        if (!dataSource.isSavePassword()) {
            dataSource.resetPassword();
        }
        dataSource.setFolder(this.dataSourceFolder);
        DBPConnectionConfiguration confConfig = dataSource.getConnectionConfiguration();
        if (this.connectionTypeCombo.getSelectionIndex() >= 0) {
            confConfig.setConnectionType(this.connectionTypeCombo.getItem(this.connectionTypeCombo.getSelectionIndex()));
        }
        for (FilterInfo filterInfo : this.filters) {
            if (filterInfo.filter == null) continue;
            dataSource.setObjectFilter(filterInfo.type, null, filterInfo.filter);
        }
        DBPConnectionBootstrap bootstrap = confConfig.getBootstrap();
        bootstrap.setIgnoreErrors(this.ignoreBootstrapErrors);
        bootstrap.setInitQueries(this.bootstrapQueries);
        confConfig.setKeepAliveInterval(this.keepAliveInterval.getSelection());
        String description = this.descriptionText.getText();
        if (description.isEmpty()) {
            dataSource.setDescription(null);
        } else {
            dataSource.setDescription(description);
        }
    }

    private void configureEvents() {
        DataSourceDescriptor dataSource = this.getActiveDataSource();
        EditShellCommandsDialog dialog = new EditShellCommandsDialog(this.getShell(), dataSource);
        if (dialog.open() == 0) {
            this.eventsButton.setFont(this.getFont());
            DBPConnectionEventType[] dBPConnectionEventTypeArray = dataSource.getConnectionConfiguration().getDeclaredEvents();
            int n = dBPConnectionEventTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBPConnectionEventType eventType = dBPConnectionEventTypeArray[n2];
                if (dataSource.getConnectionConfiguration().getEvent(eventType).isEnabled()) {
                    this.eventsButton.setFont(this.boldFont);
                    break;
                }
                ++n2;
            }
        }
    }

    public void setDataSourceFolder(DBPDataSourceFolder dataSourceFolder) {
        this.dataSourceFolder = dataSourceFolder;
    }

    private static class ConnectionFolderLabelProvider
    extends LabelProvider {
        private ConnectionFolderLabelProvider() {
        }

        public Image getImage(Object element) {
            return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER_DATABASE);
        }

        public String getText(Object element) {
            if (element == null) {
                return CoreMessages.toolbar_datasource_selector_empty;
            }
            String prefix = "";
            DBPDataSourceFolder folder = ((DBPDataSourceFolder)element).getParent();
            while (folder != null) {
                prefix = String.valueOf(prefix) + "   ";
                folder = folder.getParent();
            }
            return String.valueOf(prefix) + ((DBPDataSourceFolder)element).getName();
        }
    }

    private static class ConnectionTypeLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ConnectionTypeLabelProvider() {
        }

        public String getText(Object element) {
            return ((DBPConnectionType)element).getName();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return UIUtils.getConnectionTypeColor((DBPConnectionType)element);
        }
    }

    private static class FilterInfo {
        final Class<?> type;
        final String title;
        Link link;
        DBSObjectFilter filter;

        private FilterInfo(Class<?> type, String title) {
            this.type = type;
            this.title = title;
        }
    }

    private class SchemaReadJob
    extends AbstractJob {
        private DBSObjectContainer objectContainer;

        public SchemaReadJob(DBSObjectContainer objectContainer) {
            super("Schema reader");
            this.objectContainer = objectContainer;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                final ArrayList<String> schemaNames = new ArrayList<String>();
                Collection children = this.objectContainer.getChildren(monitor);
                if (children != null) {
                    for (DBSObject child : children) {
                        schemaNames.add(child.getName());
                    }
                }
                if (!schemaNames.isEmpty()) {
                    DBeaverUI.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ConnectionPageGeneral.this.defaultSchema.isDisposed()) {
                                String oldText = ConnectionPageGeneral.this.defaultSchema.getText();
                                ConnectionPageGeneral.this.defaultSchema.removeAll();
                                for (String name : schemaNames) {
                                    ConnectionPageGeneral.this.defaultSchema.add(name);
                                }
                                if (!CommonUtils.isEmpty((String)oldText)) {
                                    ConnectionPageGeneral.this.defaultSchema.setText(oldText);
                                }
                            }
                        }
                    });
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't read schema list", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

