/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityElement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class GotoObjectDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_ID = "GotoObjectDialog";
    private final DBCExecutionContext context;
    private DBSObject container;

    public GotoObjectDialog(Shell shell, DBCExecutionContext context, DBSObject container) {
        super(shell, true);
        this.context = context;
        this.container = container;
        this.setTitle("Goto Database Object in '" + context.getDataSource().getContainer().getName() + "'");
        this.setListLabelProvider((ILabelProvider)new ObjectLabelProvider(null, null));
        this.setDetailsLabelProvider((ILabelProvider)new DetailsLabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ObjectFilter();
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof DBPNamedObject && o2 instanceof DBPNamedObject) {
                    return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)o1), (DBPEvaluationContext)DBPEvaluationContext.UI).compareToIgnoreCase(DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)o2), (DBPEvaluationContext)DBPEvaluationContext.UI));
                }
                return 0;
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)this.context.getDataSource());
        if (structureAssistant == null) {
            return;
        }
        String nameMask = ((ObjectFilter)itemsFilter).getNameMask();
        DBRProgressMonitor monitor = RuntimeUtils.makeMonitor((IProgressMonitor)progressMonitor);
        try {
            try {
                monitor.beginTask("Search for '" + nameMask + "'", 100);
                ArrayList<DBSObjectType> typesToSearch = new ArrayList<DBSObjectType>();
                DBSObjectType[] dBSObjectTypeArray = structureAssistant.getSupportedObjectTypes();
                int n = dBSObjectTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSObjectType type = dBSObjectTypeArray[n2];
                    Class typeClass = type.getTypeClass();
                    if (!DBSEntityElement.class.isAssignableFrom(typeClass)) {
                        typesToSearch.add(type);
                    }
                    ++n2;
                }
                List result = structureAssistant.findObjectsByMask(monitor, this.container, typesToSearch.toArray(new DBSObjectType[typesToSearch.size()]), nameMask, false, true, 1000);
                DBPDataSourceContainer dsContainer = this.context.getDataSource().getContainer();
                for (DBSObjectReference ref : result) {
                    DBSObjectFilter filter = dsContainer.getObjectFilter(ref.getObjectClass(), ref.getContainer(), true);
                    if (filter != null && filter.isEnabled() && !filter.matches(ref.getName())) continue;
                    contentProvider.add((Object)ref, itemsFilter);
                }
            }
            catch (DBException e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getElementName(Object item) {
        if (item instanceof DBPNamedObject) {
            return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)item), (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        return item.toString();
    }

    private static class DetailsLabelProvider
    extends ObjectLabelProvider {
        private DetailsLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof DBPNamedObject) {
                return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)element), (DBPEvaluationContext)DBPEvaluationContext.UI);
            }
            return super.getText(element);
        }
    }

    private class ObjectFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private Pattern namePattern;

        private ObjectFilter() {
            super((FilteredItemsSelectionDialog)GotoObjectDialog.this);
            this.namePattern = null;
        }

        public int getMatchRule() {
            return 3;
        }

        public boolean matchItem(Object item) {
            if (item instanceof DBPNamedObject) {
                String objectName = ((DBPNamedObject)item).getName();
                return this.getNamePattern().matcher(objectName).matches();
            }
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public String getNameMask() {
            String nameMask = this.getPattern();
            nameMask = nameMask.replace("*", "%").replace("?", "_");
            int matchRule = this.getMatchRule();
            if ((matchRule & 1) != 0 && !nameMask.endsWith("%")) {
                nameMask = String.valueOf(nameMask) + "%";
            }
            return nameMask;
        }

        private Pattern getNamePattern() {
            if (this.namePattern == null) {
                this.namePattern = Pattern.compile(SQLUtils.makeLikePattern((String)this.getNameMask()), 10);
            }
            return this.namePattern;
        }
    }

    private static class ObjectLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ObjectLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof DBPNamedObject) {
                DBPNamedObject namedObject = (DBPNamedObject)element;
                StyledString str = new StyledString(namedObject.getName());
                String fullName = DBUtils.getObjectFullName((DBPNamedObject)namedObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
                if (!CommonUtils.equalObjects((Object)fullName, (Object)namedObject.getName())) {
                    str.append(" - ", StyledString.QUALIFIER_STYLER);
                    str.append(fullName, StyledString.QUALIFIER_STYLER);
                }
                return str;
            }
            return new StyledString("?");
        }

        public Image getImage(Object element) {
            DBSObjectType objectType;
            if (element instanceof DBSObjectReference && (objectType = ((DBSObjectReference)element).getObjectType()) != null) {
                return DBeaverIcons.getImage(objectType.getImage());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof DBPNamedObject) {
                return ((DBPNamedObject)element).getName();
            }
            return null;
        }

        /* synthetic */ ObjectLabelProvider(ObjectLabelProvider objectLabelProvider, ObjectLabelProvider objectLabelProvider2) {
            this();
        }
    }
}

