/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.stream;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.stream.AbstractTextPanelEditor;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.ui.editors.xml.XMLEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class XMLPanelEditor
extends AbstractTextPanelEditor {
    private IValueController valueController;
    private IEditorSite subSite;
    private XMLEditor editor;

    @Override
    public StyledText createControl(IValueController valueController) {
        this.valueController = valueController;
        this.subSite = new SubEditorSite(valueController.getValueSite());
        this.editor = new XMLEditor();
        try {
            this.editor.init(this.subSite, StringEditorInput.EMPTY_INPUT);
        }
        catch (PartInitException e) {
            valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
            return new StyledText(valueController.getEditPlaceholder(), 0);
        }
        this.editor.createPartControl(valueController.getEditPlaceholder());
        StyledText editorControl = this.editor.getEditorControl();
        assert (editorControl != null);
        this.initEditorSettings(editorControl);
        editorControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XMLPanelEditor.this.editor.releaseEditorInput();
            }
        });
        return editorControl;
    }

    @Override
    public void primeEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @NotNull DBDContent value) throws DBException {
        monitor.beginTask("Prime content value", 1);
        try {
            try {
                monitor.subTask("Prime XML value");
                ContentEditorInput sqlInput = new ContentEditorInput(this.valueController, null, null, monitor);
                this.editor.init(this.subSite, (IEditorInput)sqlInput);
                this.applyEditorStyle();
            }
            catch (Exception e) {
                throw new DBException("Can't load XML vaue", (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void extractEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @NotNull DBDContent value) throws DBException {
        if (this.valueController.isReadOnly() || !this.editor.isDirty()) {
            return;
        }
        monitor.beginTask("Read XML value", 1);
        try {
            try {
                monitor.subTask("Read XML value");
                this.editor.doSave(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                ContentEditorInput editorInput = (ContentEditorInput)this.editor.getEditorInput();
                editorInput.updateContentFromFile(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
            }
            catch (Exception e) {
                throw new DBException("Error saving XML value", (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected BaseTextEditor getTextEditor() {
        return this.editor;
    }
}

