/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.stream;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.impl.StringContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.stream.AbstractTextPanelEditor;
import org.jkiss.dbeaver.utils.ContentUtils;

public class TextPanelEditor
extends AbstractTextPanelEditor {
    @Override
    public StyledText createControl(IValueController valueController) {
        StyledText text = new StyledText(valueController.getEditPlaceholder(), 514);
        text.setEditable(!valueController.isReadOnly());
        text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.initEditorSettings(text);
        return text;
    }

    @Override
    public void primeEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @NotNull DBDContent value) throws DBException {
        monitor.subTask("Read text value");
        if (value.isNull()) {
            control.setText("");
        } else {
            String strValue = ContentUtils.getContentStringValue((DBRProgressMonitor)monitor, (DBDContent)value);
            control.setText(strValue);
        }
    }

    @Override
    public void extractEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @NotNull DBDContent value) throws DBException {
        monitor.subTask("Read text value");
        value.updateContents(monitor, (DBDContentStorage)new StringContentStorage(control.getText()));
    }
}

