/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.stream;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StyledText;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ViewValuePanel;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;

public abstract class AbstractTextPanelEditor
implements IStreamValueEditor<StyledText>,
IAdaptable {
    public static final String PREF_TEXT_EDITOR_WORD_WRAP = "content.text.editor.word-wrap";
    public static final String PREF_TEXT_EDITOR_AUTO_FORMAT = "content.text.editor.auto-format";

    @Override
    public abstract StyledText createControl(IValueController var1);

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull StyledText control) throws DBCException {
    }

    @Override
    public void contributeSettings(@NotNull IContributionManager manager, final @NotNull StyledText editorControl) throws DBCException {
        manager.add((IContributionItem)new Separator());
        Action wwAction = new Action("Word Wrap", 2){

            public void run() {
                boolean newWW = !editorControl.getWordWrap();
                this.setChecked(newWW);
                editorControl.setWordWrap(newWW);
                ViewValuePanel.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_WORD_WRAP, newWW);
            }
        };
        wwAction.setChecked(editorControl.getWordWrap());
        manager.add((IAction)wwAction);
        BaseTextEditor textEditor = this.getTextEditor();
        if (textEditor != null) {
            Action afAction = new Action("Auto Format", 2){

                public void run() {
                    boolean newAF = !ViewValuePanel.getPanelSettings().getBoolean(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT);
                    this.setChecked(newAF);
                    ViewValuePanel.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT, newAF);
                    AbstractTextPanelEditor.this.applyEditorStyle();
                }
            };
            afAction.setChecked(ViewValuePanel.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_AUTO_FORMAT));
            manager.add((IAction)afAction);
        }
    }

    protected BaseTextEditor getTextEditor() {
        return null;
    }

    protected void initEditorSettings(StyledText control) {
        boolean wwEnabled = ViewValuePanel.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_WORD_WRAP);
        if (wwEnabled != control.getWordWrap()) {
            control.setWordWrap(wwEnabled);
        }
    }

    protected void applyEditorStyle() {
        BaseTextEditor textEditor = this.getTextEditor();
        if (textEditor != null && ViewValuePanel.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_AUTO_FORMAT)) {
            textEditor.getViewer().doOperation(15);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        BaseTextEditor textEditor = this.getTextEditor();
        if (textEditor != null) {
            if (adapter.isAssignableFrom(textEditor.getClass())) {
                return adapter.cast(textEditor);
            }
            return (T)textEditor.getAdapter(adapter);
        }
        return null;
    }
}

