/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.data.registry.StreamValueManagerDescriptor;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ContentPanelEditor
extends BaseValueEditor<Control>
implements IAdaptable {
    private static final Log log = Log.getLog(ContentPanelEditor.class);
    private static Map<String, String> valueToManagerMap = new HashMap<String, String>();
    private Map<StreamValueManagerDescriptor, IStreamValueManager.MatchType> streamManagers;
    private volatile StreamValueManagerDescriptor curStreamManager;
    private IStreamValueEditor<Control> streamEditor;
    private Control editorControl;

    public ContentPanelEditor(IValueController controller) {
        super(controller);
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
        if (this.streamManagers != null) {
            manager.add((IAction)new ContentTypeSwitchAction());
        }
        if (this.streamEditor != null) {
            this.streamEditor.contributeActions(manager, this.control);
        }
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        final DBDContent content = (DBDContent)this.valueController.getValue();
        if (content == null) {
            this.valueController.showMessage("NULL content value. Must be DBDContent.", DBPMessageType.ERROR);
            return;
        }
        if (this.streamEditor == null) {
            this.valueController.showMessage("NULL content editor.", DBPMessageType.ERROR);
            return;
        }
        DBeaverUI.runInUI((IRunnableContext)this.valueController.getValueSite().getWorkbenchWindow(), new DBRRunnableWithProgress(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ContentPanelEditor.this.streamEditor.primeEditorValue(monitor, ContentPanelEditor.this.control, content);
                }
                catch (Throwable e) {
                    log.debug((Object)e);
                    ContentPanelEditor.this.valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
                }
            }
        });
    }

    @Override
    public Object extractEditorValue() throws DBException {
        DBDContent content = (DBDContent)this.valueController.getValue();
        if (content == null) {
            log.warn((Object)"NULL content value. Must be DBDContent.");
        } else if (this.streamEditor == null) {
            log.warn((Object)"NULL content editor.");
        } else {
            try {
                this.streamEditor.extractEditorValue((DBRProgressMonitor)new VoidProgressMonitor(), this.control, content);
            }
            catch (Throwable e) {
                log.debug((Object)e);
                this.valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
            }
        }
        return content;
    }

    @Override
    protected Control createControl(Composite editPlaceholder) {
        DBDContent content = (DBDContent)this.valueController.getValue();
        if (this.curStreamManager == null) {
            this.detectStreamManager(content);
        }
        if (this.curStreamManager != null) {
            try {
                this.streamEditor = this.curStreamManager.getInstance().createPanelEditor(this.valueController);
            }
            catch (Throwable e) {
                DBUserInterface.getInstance().showError("No stream editor", "Can't create stream editor", e);
            }
        }
        if (this.streamEditor == null) {
            return UIUtils.createInfoLabel(editPlaceholder, "No Editor");
        }
        this.editorControl = this.streamEditor.createControl(this.valueController);
        return this.editorControl;
    }

    private void detectStreamManager(DBDContent content) {
        StreamManagerDetectJob detectJob = new StreamManagerDetectJob(content);
        RuntimeUtils.runTask((DBRRunnableWithProgress)detectJob, (String)"Detect stream editor", (long)5000L);
    }

    private void setStreamManager(StreamValueManagerDescriptor newManager) {
        this.curStreamManager = newManager;
        if (this.curStreamManager != null) {
            String valueId = this.makeValueId();
            valueToManagerMap.put(valueId, this.curStreamManager.getId());
            this.valueController.refreshEditor();
        }
    }

    private String makeValueId() {
        String valueId;
        DBSTypedObject valueType = this.valueController.getValueType();
        if (valueType instanceof DBDAttributeBinding) {
            valueType = ((DBDAttributeBinding)valueType).getAttribute();
        }
        if (valueType instanceof DBSObject) {
            DBSObject object = (DBSObject)valueType;
            valueId = DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL);
            if (object.getParentObject() != null) {
                valueId = String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)object.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.DDL)) + ":" + valueId;
            }
        } else {
            valueId = this.valueController.getValueName();
        }
        String dsId = "unknown";
        if (this.valueController.getExecutionContext() != null) {
            dsId = this.valueController.getExecutionContext().getDataSource().getContainer().getId();
        }
        return String.valueOf(dsId) + ":" + valueId;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.streamEditor != null) {
            if (adapter.isAssignableFrom(this.streamEditor.getClass())) {
                return adapter.cast(this.streamEditor);
            }
            if (this.streamEditor instanceof IAdaptable) {
                return (T)((IAdaptable)this.streamEditor).getAdapter(adapter);
            }
        }
        return null;
    }

    private class ContentTypeSwitchAction
    extends Action
    implements SelectionListener {
        private Menu menu;

        ContentTypeSwitchAction() {
            super(null, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PAGES));
            this.setToolTipText("Content viewer settings");
        }

        public void runWithEvent(Event event) {
            if (event.widget instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)event.widget;
                Menu menu = this.createMenu(toolItem);
                Rectangle bounds = toolItem.getBounds();
                Point point = toolItem.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        }

        private Menu createMenu(ToolItem toolItem) {
            if (this.menu == null) {
                ToolBar toolBar = toolItem.getParent();
                this.menu = new Menu((Control)toolBar);
                ArrayList managers = new ArrayList(ContentPanelEditor.this.streamManagers.keySet());
                Collections.sort(managers, new Comparator<StreamValueManagerDescriptor>(){

                    @Override
                    public int compare(StreamValueManagerDescriptor o1, StreamValueManagerDescriptor o2) {
                        return o1.getLabel().compareTo(o2.getLabel());
                    }
                });
                for (StreamValueManagerDescriptor manager : managers) {
                    MenuItem item = new MenuItem(this.menu, 16);
                    item.setText(manager.getLabel());
                    item.setData((Object)manager);
                    item.addSelectionListener((SelectionListener)this);
                }
                MenuManager menuManager = new MenuManager();
                try {
                    ContentPanelEditor.this.streamEditor.contributeSettings((IContributionManager)menuManager, ContentPanelEditor.this.editorControl);
                    IContributionItem[] iContributionItemArray = menuManager.getItems();
                    int n = iContributionItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem item = iContributionItemArray[n2];
                        item.fill(this.menu, -1);
                        ++n2;
                    }
                }
                catch (DBCException e) {
                    log.error((Object)e);
                }
                toolBar.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        ContentTypeSwitchAction.this.menu.dispose();
                    }
                });
            }
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                MenuItem item = menuItemArray[n3];
                if (item.getData() instanceof StreamValueManagerDescriptor) {
                    item.setSelection(item.getData() == ContentPanelEditor.this.curStreamManager);
                }
                ++n3;
            }
            return this.menu;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                StreamValueManagerDescriptor newManager;
                Object itemData;
                MenuItem item = menuItemArray[n2];
                if (item.getSelection() && (itemData = item.getData()) instanceof StreamValueManagerDescriptor && (newManager = (StreamValueManagerDescriptor)((Object)itemData)) != ContentPanelEditor.this.curStreamManager) {
                    ContentPanelEditor.this.setStreamManager(newManager);
                }
                ++n2;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class StreamManagerDetectJob
    implements DBRRunnableWithProgress {
        private final DBDContent content;

        StreamManagerDetectJob(DBDContent content) {
            this.content = content;
        }

        public void run(DBRProgressMonitor monitor) {
            monitor.beginTask("Detect appropriate editor", 1);
            try {
                try {
                    ContentPanelEditor.this.streamManagers = ValueManagerRegistry.getInstance().getApplicableStreamManagers(monitor, ContentPanelEditor.this.valueController.getValueType(), this.content);
                    String savedManagerId = (String)valueToManagerMap.get(ContentPanelEditor.this.makeValueId());
                    if (savedManagerId != null) {
                        ContentPanelEditor.this.curStreamManager = this.findManager(savedManagerId);
                    }
                    if (ContentPanelEditor.this.curStreamManager == null) {
                        ContentPanelEditor.this.curStreamManager = this.findManager(IStreamValueManager.MatchType.EXCLUSIVE);
                        if (ContentPanelEditor.this.curStreamManager == null) {
                            ContentPanelEditor.this.curStreamManager = this.findManager(IStreamValueManager.MatchType.PRIMARY);
                        }
                        if (ContentPanelEditor.this.curStreamManager == null) {
                            ContentPanelEditor.this.curStreamManager = this.findManager(IStreamValueManager.MatchType.DEFAULT);
                        }
                        if (ContentPanelEditor.this.curStreamManager == null) {
                            ContentPanelEditor.this.curStreamManager = this.findManager(IStreamValueManager.MatchType.APPLIES);
                        }
                        if (ContentPanelEditor.this.curStreamManager == null) {
                            throw new DBException("Can't find appropriate stream manager");
                        }
                    }
                }
                catch (Exception e) {
                    ContentPanelEditor.this.valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        private StreamValueManagerDescriptor findManager(IStreamValueManager.MatchType matchType) {
            for (Map.Entry entry : ContentPanelEditor.this.streamManagers.entrySet()) {
                if (entry.getValue() != matchType) continue;
                return (StreamValueManagerDescriptor)((Object)entry.getKey());
            }
            return null;
        }

        private StreamValueManagerDescriptor findManager(String id) {
            for (Map.Entry entry : ContentPanelEditor.this.streamManagers.entrySet()) {
                if (!((StreamValueManagerDescriptor)((Object)entry.getKey())).getId().equals(id)) continue;
                return (StreamValueManagerDescriptor)((Object)entry.getKey());
            }
            return null;
        }
    }
}

