/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridController;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IStatefulControl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPropertyTester;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetFindReplaceTarget;
import org.jkiss.dbeaver.ui.data.IMultiController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueEditorStandalone;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.properties.PropertySourceDelegate;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SpreadsheetPresentation
extends AbstractPresentation
implements IResultSetEditor,
ISelectionProvider,
IStatefulControl,
IAdaptable,
IGridController {
    private static final Log log = Log.getLog(SpreadsheetPresentation.class);
    private Spreadsheet spreadsheet;
    @Nullable
    private DBDAttributeBinding curAttribute;
    private int columnOrder = 0;
    private final Map<SpreadsheetValueController, IValueEditorStandalone> openEditors = new HashMap<SpreadsheetValueController, IValueEditorStandalone>();
    private SpreadsheetFindReplaceTarget findReplaceTarget;
    private Color backgroundAdded;
    private Color backgroundDeleted;
    private Color backgroundModified;
    private Color backgroundNormal;
    private Color backgroundOdd;
    private Color backgroundReadOnly;
    private Color foregroundDefault;
    private Color foregroundNull;
    private final Map<DBPDataKind, Color> dataTypesForegrounds = new HashMap<DBPDataKind, Color>();
    private Color foregroundSelected;
    private Color backgroundSelected;
    private Color backgroundMatched;
    private Color cellHeaderForeground;
    private Color cellHeaderBackground;
    private Color cellHeaderSelectionBackground;
    private Font boldFont;
    private Font italicFont;
    private Font bolItalicFont;
    private boolean showOddRows = true;
    private boolean showCelIcons = true;
    private boolean colorizeDataTypes = true;
    private boolean rightJustifyNumbers = true;

    public SpreadsheetPresentation() {
        this.findReplaceTarget = new SpreadsheetFindReplaceTarget(this);
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    @Nullable
    DBPDataSource getDataSource() {
        DBSDataContainer dataContainer = this.controller.getDataContainer();
        return dataContainer == null ? null : dataContainer.getDataSource();
    }

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        this.boldFont = UIUtils.makeBoldFont(parent.getFont());
        this.italicFont = UIUtils.modifyFont(parent.getFont(), 2);
        this.spreadsheet = new Spreadsheet(parent, 268436226, controller.getSite(), this, new ContentProvider(), new GridLabelProvider(), this);
        this.spreadsheet.setLayoutData(new GridData(1808));
        this.spreadsheet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 1 && e.detail != 4) {
                    SpreadsheetPresentation.this.updateGridCursor((GridCell)e.data);
                }
                SpreadsheetPresentation.this.fireSelectionChanged((ISelection)new SpreadsheetSelectionImpl());
            }
        });
        this.spreadsheet.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
            }
        });
        this.spreadsheet.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
            }
        });
        this.activateTextKeyBindings(controller, (Control)this.spreadsheet);
        this.applyThemeSettings();
        this.spreadsheet.addDisposeListener(e -> this.dispose());
        this.trackPresentationControl();
        UIUtils.enableHostEditorKeyBindingsSupport(controller.getSite(), (Control)this.spreadsheet);
    }

    @Override
    public void dispose() {
        this.closeEditors();
        this.clearMetaData();
        UIUtils.dispose((Resource)this.italicFont);
        UIUtils.dispose((Resource)this.boldFont);
        UIUtils.dispose((Resource)this.cellHeaderSelectionBackground);
        super.dispose();
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        boolean recordMode = this.controller.isRecordMode();
        ResultSetRow curRow = this.controller.getCurrentRow();
        ResultSetModel model = this.controller.getModel();
        switch (position) {
            case FIRST: {
                if (recordMode) {
                    if (model.getRowCount() > 0) {
                        this.controller.setCurrentRow(model.getRow(0));
                        break;
                    }
                    this.controller.setCurrentRow(null);
                    break;
                }
                this.spreadsheet.shiftCursor(0, -this.spreadsheet.getItemCount(), false);
                break;
            }
            case PREVIOUS: {
                if (recordMode && curRow != null && curRow.getVisualNumber() > 0) {
                    this.controller.setCurrentRow(model.getRow(curRow.getVisualNumber() - 1));
                    break;
                }
                this.spreadsheet.shiftCursor(0, -1, false);
                break;
            }
            case NEXT: {
                if (recordMode && curRow != null && curRow.getVisualNumber() < model.getRowCount() - 1) {
                    this.controller.setCurrentRow(model.getRow(curRow.getVisualNumber() + 1));
                    break;
                }
                this.spreadsheet.shiftCursor(0, 1, false);
                break;
            }
            case LAST: {
                if (recordMode && model.getRowCount() > 0) {
                    this.controller.setCurrentRow(model.getRow(model.getRowCount() - 1));
                    break;
                }
                this.spreadsheet.shiftCursor(0, this.spreadsheet.getItemCount(), false);
                break;
            }
            case CURRENT: {
                if (curRow == null) break;
                GridPos curPos = this.spreadsheet.getCursorPosition();
                GridCell newCell = this.spreadsheet.posToCell(new GridPos(curPos.col, curRow.getVisualNumber()));
                if (newCell == null) break;
                this.spreadsheet.setCursor(newCell, false);
            }
        }
        if (this.controller.isRecordMode()) {
            this.restoreState(this.curAttribute);
        }
        this.controller.updateEditControls();
        this.controller.updateStatusMessage();
        if (recordMode) {
            this.refreshData(true, false, true);
        }
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    public void setCurrentAttribute(@NotNull DBDAttributeBinding attribute) {
        this.curAttribute = attribute;
        ResultSetRow curRow = this.controller.getCurrentRow();
        if (curRow == null) {
            return;
        }
        GridCell cell = this.controller.isRecordMode() ? new GridCell(curRow, this.curAttribute) : new GridCell(this.curAttribute, curRow);
        this.spreadsheet.setCursor(cell, false);
    }

    @Override
    public Point getCursorLocation() {
        Rectangle columnBounds;
        GridPos focusPos = this.spreadsheet.getFocusPos();
        if (focusPos.col >= 0 && (columnBounds = this.spreadsheet.getColumnBounds(focusPos.col)) != null) {
            columnBounds.y += this.spreadsheet.getHeaderHeight() + (focusPos.row - this.spreadsheet.getTopIndex()) * (this.spreadsheet.getItemHeight() + 1) + this.spreadsheet.getItemHeight() / 2;
            return new Point(columnBounds.x + 20, columnBounds.y);
        }
        return super.getCursorLocation();
    }

    @Override
    public Object saveState() {
        return this.curAttribute;
    }

    @Override
    public void restoreState(Object state) {
        this.curAttribute = this.controller.getModel().getAttributeBinding((DBSAttributeBase)((DBDAttributeBinding)state));
        ResultSetRow curRow = this.controller.getCurrentRow();
        if (curRow != null && this.curAttribute != null) {
            GridCell cell = this.controller.isRecordMode() ? new GridCell(curRow, this.curAttribute) : new GridCell(this.curAttribute, curRow);
            this.spreadsheet.setCursor(cell, false);
        }
    }

    private void updateGridCursor(GridCell cell) {
        boolean changed;
        Object newCol = cell == null ? null : cell.col;
        Object newRow = cell == null ? null : cell.row;
        ResultSetRow curRow = this.controller.getCurrentRow();
        if (!this.controller.isRecordMode()) {
            boolean bl = changed = curRow != newRow || this.curAttribute != newCol;
            if (newRow instanceof ResultSetRow) {
                curRow = (ResultSetRow)newRow;
                this.controller.setCurrentRow(curRow);
            }
            if (newCol instanceof DBDAttributeBinding) {
                this.curAttribute = (DBDAttributeBinding)newCol;
            }
        } else {
            boolean bl = changed = this.curAttribute != newRow;
            if (newRow instanceof DBDAttributeBinding) {
                this.curAttribute = (DBDAttributeBinding)newRow;
            }
        }
        if (changed) {
            this.spreadsheet.cancelInlineEditor();
            ResultSetPropertyTester.firePropertyChange("canMove");
            ResultSetPropertyTester.firePropertyChange("editable");
            this.spreadsheet.redrawGrid();
        }
    }

    @Override
    @Nullable
    public String copySelectionToString(ResultSetCopySettings settings) {
        String quoteString;
        String rowDelimiter;
        String columnDelimiter = settings.getColumnDelimiter();
        if (columnDelimiter == null) {
            columnDelimiter = "\t";
        }
        if ((rowDelimiter = settings.getRowDelimiter()) == null) {
            rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        }
        if (CommonUtils.isEmpty((String)(quoteString = settings.getQuoteString()))) {
            quoteString = "\"";
        }
        List<Object> selectedColumns = this.spreadsheet.getColumnSelection();
        IGridLabelProvider labelProvider = this.spreadsheet.getLabelProvider();
        StringBuilder tdt = new StringBuilder();
        if (settings.isCopyHeader()) {
            if (settings.isCopyRowNumbers()) {
                tdt.append("#");
            }
            for (Object column : selectedColumns) {
                if (tdt.length() > 0) {
                    tdt.append(columnDelimiter);
                }
                tdt.append(labelProvider.getText(column));
            }
            tdt.append(rowDelimiter);
        }
        List<GridCell> selectedCells = this.spreadsheet.getCellSelection();
        boolean quoteCells = settings.isQuoteCells() && selectedCells.size() > 1;
        boolean forceQuotes = settings.isForceQuotes();
        GridCell prevCell = null;
        for (GridCell cell : selectedCells) {
            SpreadsheetValueController valueController;
            boolean recordMode;
            int prevColIndex;
            if (prevCell == null || cell.row != prevCell.row) {
                if (prevCell != null && prevCell.col != cell.col) {
                    int i = prevColIndex = selectedColumns.indexOf(prevCell.col);
                    while (i < selectedColumns.size() - 1) {
                        tdt.append(columnDelimiter);
                        ++i;
                    }
                }
                if (prevCell != null) {
                    tdt.append(rowDelimiter);
                }
                if (settings.isCopyRowNumbers()) {
                    tdt.append(labelProvider.getText(cell.row)).append(columnDelimiter);
                }
            }
            if (prevCell != null && prevCell.col != cell.col) {
                prevColIndex = selectedColumns.indexOf(prevCell.col);
                int curColIndex = selectedColumns.indexOf(cell.col);
                int i = prevColIndex;
                while (i < curColIndex) {
                    tdt.append(columnDelimiter);
                    ++i;
                }
            }
            DBDAttributeBinding column = (DBDAttributeBinding)(!(recordMode = this.controller.isRecordMode()) ? cell.col : cell.row);
            ResultSetRow row = (ResultSetRow)(!recordMode ? cell.row : cell.col);
            Object value = this.controller.getModel().getCellValue(column, row);
            String cellText = column.getValueRenderer().getValueDisplayString((DBSTypedObject)column.getAttribute(), value, settings.getFormat());
            if ((forceQuotes || quoteCells && !CommonUtils.isEmpty((String)cellText)) && (forceQuotes || cellText.contains(columnDelimiter) || cellText.contains(rowDelimiter))) {
                cellText = String.valueOf(quoteString) + cellText + quoteString;
            }
            tdt.append(cellText);
            if (settings.isCut() && !(valueController = new SpreadsheetValueController(this.controller, column, row, IValueController.EditType.NONE, null)).isReadOnly()) {
                valueController.updateValue(BaseValueManager.makeNullValue(valueController), false);
            }
            prevCell = cell;
        }
        if (settings.isCut()) {
            this.controller.redrawData(false, false);
            this.controller.updatePanelsContent(false);
        }
        return tdt.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void pasteFromClipboard(boolean extended) {
        try {
            block28: {
                block29: {
                    if (!extended) break block29;
                    dataSource = this.getDataSource();
                    clipboard = new Clipboard(Display.getCurrent());
                    try {
                        strValue = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    }
                    finally {
                        clipboard.dispose();
                    }
                    if (CommonUtils.isEmpty((String)strValue)) {
                        return;
                    }
                    focusPos = this.spreadsheet.getFocusPos();
                    rowNum = focusPos.row;
                    if (rowNum < 0) {
                        return;
                    }
                    overNewRow = this.controller.getModel().getRow(rowNum).getState() == 2;
                    var8_16 = null;
                    var9_18 = null;
                    try {
                        session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)dataSource, (String)"Advanced paste");
                        try {
                            block30: {
                                newLines = this.parseGridLines(strValue);
                                if (!overNewRow) ** GOTO lbl37
                                i = 0;
                                while (i < newLines.length - 1) {
                                    this.controller.addNewRow(false, true, false);
                                    ++i;
                                }
                                this.spreadsheet.refreshRowsData();
                                break block30;
lbl-1000:
                                // 1 sources

                                {
                                    this.controller.addNewRow(false, true, false);
                                    this.spreadsheet.refreshRowsData();
lbl37:
                                    // 2 sources

                                    ** while (rowNum + newLines.length > this.spreadsheet.getItemCount())
                                }
                            }
                            if (rowNum < 0 || rowNum >= this.spreadsheet.getItemCount()) {
                                return;
                            }
                            var15_24 = newLines;
                            var14_25 = newLines.length;
                            var13_26 = 0;
                            while (var13_26 < var14_25) {
                                line = var15_24[var13_26];
                                colNum = focusPos.col;
                                rowElement = this.spreadsheet.getRowElement(rowNum);
                                var21_32 = line;
                                var20_31 = line.length;
                                var19_30 = 0;
                                while (var19_30 < var20_31) {
                                    value = var21_32[var19_30];
                                    if (colNum >= this.spreadsheet.getColumnCount()) break;
                                    colElement = this.spreadsheet.getColumnElement(colNum);
                                    attr = (DBDAttributeBinding)(this.controller.isRecordMode() != false ? rowElement : colElement);
                                    row = (ResultSetRow)(this.controller.isRecordMode() != false ? colElement : rowElement);
                                    if (!this.controller.isAttributeReadOnly(attr)) {
                                        newValue = attr.getValueHandler().getValueFromObject(session, (DBSTypedObject)attr.getAttribute(), (Object)value, true);
                                        new SpreadsheetValueController(this.controller, attr, row, IValueController.EditType.NONE, null).updateValue(newValue, false);
                                        ++colNum;
                                    }
                                    ++var19_30;
                                }
                                if (++rowNum >= this.spreadsheet.getItemCount()) {
                                    break block28;
                                }
                                ++var13_26;
                            }
                            break block28;
                        }
                        finally {
                            if (session == null) ** continue;
                            session.close();
                        }
                    }
                    catch (Throwable var9_19) {
                        if (var8_16 == null) {
                            var8_16 = var9_19;
                        } else if (var8_16 != var9_19) {
                            var8_16.addSuppressed(var9_19);
                        }
                        throw var8_16;
                    }
                }
                ssSelection = this.spreadsheet.getSelection();
                for (GridPos pos : ssSelection) {
                    if (this.controller.isRecordMode()) {
                        attr = (DBDAttributeBinding)this.spreadsheet.getRowElement(pos.row);
                        row = this.controller.getCurrentRow();
                    } else {
                        attr = (DBDAttributeBinding)this.spreadsheet.getColumnElement(pos.col);
                        row = (ResultSetRow)this.spreadsheet.getRowElement(pos.row);
                    }
                    if (attr == null || row == null || this.controller.isAttributeReadOnly(attr) || (newValue = ResultSetUtils.getAttributeValueFromClipboard(attr)) == null) continue;
                    new SpreadsheetValueController(this.controller, attr, row, IValueController.EditType.NONE, null).updateValue(newValue, false);
                }
            }
            this.controller.redrawData(false, true);
            this.controller.updateEditControls();
        }
        catch (Exception e) {
            DBUserInterface.getInstance().showError("Cannot replace cell value", null, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[][] parseGridLines(String strValue) {
        columnDelimiter = 9;
        rowDelimiter = 10;
        trashDelimiter = 13;
        quote = 34;
        lines = new ArrayList<String[]>();
        cellValue = new StringBuilder();
        curLine = new ArrayList<String>();
        inQuote = false;
        length = strValue.length();
        i = 0;
        while (i < length) {
            block14: {
                block13: {
                    c = strValue.charAt(i);
                    if (!inQuote || c == '\"') break block13;
                    cellValue.append(c);
                    break block14;
                }
                switch (c) {
                    case '\t': {
                        curLine.add(cellValue.toString());
                        cellValue.setLength(0);
                        break;
                    }
                    case '\n': {
                        curLine.add(cellValue.toString());
                        lines.add(curLine.toArray(new String[curLine.size()]));
                        curLine.clear();
                        cellValue.setLength(0);
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    case '\"': {
                        if (!inQuote) ** GOTO lbl40
                        if (i == length - 1 || strValue.charAt(i + 1) == '\t' || strValue.charAt(i + 1) == '\r' || strValue.charAt(i + 1) == '\n') {
                            inQuote = false;
                            break;
                        }
                        ** GOTO lbl49
lbl40:
                        // 1 sources

                        if (cellValue.length() == 0) {
                            k = i + 1;
                            while (k < length) {
                                if (strValue.charAt(k) == '\"' && (k == length - 1 || strValue.charAt(k + 1) == '\t' || strValue.charAt(k + 1) == '\r' || strValue.charAt(k + 1) == '\n')) {
                                    inQuote = true;
                                    break;
                                }
                                ++k;
                            }
                            if (inQuote) break;
                        }
                    }
lbl49:
                    // 5 sources

                    default: {
                        cellValue.append(c);
                    }
                }
            }
            ++i;
        }
        if (cellValue.length() > 0) {
            curLine.add(cellValue.toString());
        }
        if (!curLine.isEmpty()) {
            lines.add(curLine.toArray(new String[curLine.size()]));
        }
        return (String[][])lines.toArray((T[])new String[lines.size()][]);
    }

    @Override
    public Control getControl() {
        return this.spreadsheet;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        DBPPreferenceStore preferenceStore = this.getPreferenceStore();
        this.showOddRows = preferenceStore.getBoolean("resultset.show.oddRows");
        this.showCelIcons = preferenceStore.getBoolean("resultset.show.cellIcons");
        this.colorizeDataTypes = preferenceStore.getBoolean("resultset.show.colorizeDataTypes");
        this.rightJustifyNumbers = preferenceStore.getBoolean("resultset.show.rightJustifyNumbers");
        this.spreadsheet.setRedraw(false);
        try {
            this.spreadsheet.refreshData(refreshMetadata, keepState);
        }
        finally {
            this.spreadsheet.setRedraw(true);
        }
    }

    @Override
    public void formatData(boolean refreshData) {
        this.spreadsheet.refreshData(false, true);
    }

    @Override
    public void clearMetaData() {
        this.curAttribute = null;
        if (this.columnOrder != 0) {
            this.columnOrder = -1;
        }
    }

    @Override
    public void updateValueView() {
        this.spreadsheet.redrawGrid();
        this.spreadsheet.updateScrollbars();
        if (this.curAttribute == null) {
            this.curAttribute = this.getFocusAttribute();
        }
        if (this.curAttribute != null) {
            this.spreadsheet.showColumn(this.curAttribute);
        }
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
        menu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), "org.jkiss.dbeaver.core.resultset.grid.togglePreview", 32));
    }

    @Override
    public void changeMode(boolean recordMode) {
        ResultSetRow oldRow = this.controller.getCurrentRow();
        DBDAttributeBinding oldAttribute = this.curAttribute;
        int rowCount = this.controller.getModel().getRowCount();
        if (rowCount > 0) {
            if (oldRow == null) {
                oldRow = this.controller.getModel().getRow(0);
            } else if (oldRow.getVisualNumber() >= rowCount) {
                oldRow = this.controller.getModel().getRow(rowCount - 1);
            }
        }
        if (oldAttribute == null && this.controller.getModel().getVisibleAttributeCount() > 0) {
            oldAttribute = this.controller.getModel().getVisibleAttribute(0);
        }
        int n = this.columnOrder = recordMode ? -1 : 0;
        if (oldRow != null && oldAttribute != null) {
            if (!recordMode) {
                this.spreadsheet.setCursor(new GridCell(oldAttribute, oldRow), false);
            } else {
                this.spreadsheet.setCursor(new GridCell(oldRow, oldAttribute), false);
            }
        }
        this.spreadsheet.layout(true, true);
    }

    public void fillContextMenu(@NotNull IMenuManager manager, @Nullable Object colObject, @Nullable Object rowObject) {
        DBDAttributeBinding attr = (DBDAttributeBinding)(this.controller.isRecordMode() ? rowObject : colObject);
        ResultSetRow row = (ResultSetRow)(this.controller.isRecordMode() ? colObject : rowObject);
        this.controller.fillContextMenu(manager, attr, row);
        if (attr != null && row != null) {
            final List<Object> selectedColumns = this.spreadsheet.getColumnSelection();
            if (!this.controller.isRecordMode() && !selectedColumns.isEmpty()) {
                String hideTitle;
                if (selectedColumns.size() == 1) {
                    DBDAttributeBinding columnToHide = (DBDAttributeBinding)selectedColumns.get(0);
                    hideTitle = "Hide column '" + columnToHide.getName() + "'";
                } else {
                    hideTitle = "Hide selected columns (" + selectedColumns.size() + ")";
                }
                manager.insertAfter("edit", (IAction)new Action(hideTitle){

                    public void run() {
                        ResultSetModel model = SpreadsheetPresentation.this.controller.getModel();
                        if (selectedColumns.size() >= model.getVisibleAttributeCount()) {
                            UIUtils.showMessageBox(SpreadsheetPresentation.this.getControl().getShell(), "Hide columns", "Can't hide all result columns, at least one column must be visible", 1);
                        } else {
                            int i = 0;
                            int selectedColumnsSize = selectedColumns.size();
                            while (i < selectedColumnsSize) {
                                model.setAttributeVisibility((DBDAttributeBinding)selectedColumns.get(i), false);
                                ++i;
                            }
                            SpreadsheetPresentation.this.refreshData(true, false, true);
                        }
                    }
                });
            }
        }
    }

    private void closeEditors() {
        ArrayList<IValueEditorStandalone> editors = new ArrayList<IValueEditorStandalone>(this.openEditors.values());
        for (IValueEditorStandalone editor : editors) {
            if (editor.getControl() == null || editor.getControl().isDisposed()) continue;
            editor.closeValueEditor();
        }
        this.openEditors.clear();
    }

    @Override
    @Nullable
    public Control openValueEditor(boolean inline) {
        IValueEditor editor;
        IValueController.EditType[] supportedEditTypes;
        SpreadsheetValueController valueController;
        DBDAttributeBinding attr = this.getFocusAttribute();
        ResultSetRow row = this.getFocusRow();
        if (attr == null || row == null) {
            return null;
        }
        if (!inline) {
            Iterator<SpreadsheetValueController> iterator = this.openEditors.keySet().iterator();
            while (iterator.hasNext()) {
                valueController = iterator.next();
                if (attr != valueController.getBinding() || row != valueController.getCurRow()) continue;
                IValueEditorStandalone editor2 = this.openEditors.get(valueController);
                if (editor2.getControl() != null && !editor2.getControl().isDisposed()) {
                    editor2.showValueEditor();
                    return null;
                }
                iterator.remove();
            }
        }
        Composite placeholder = null;
        if (inline) {
            if (this.controller.isReadOnly()) {
                return null;
            }
            this.spreadsheet.cancelInlineEditor();
            placeholder = new Composite((Composite)this.spreadsheet, 0);
            placeholder.setFont(this.spreadsheet.getFont());
            placeholder.setLayout((Layout)new FillLayout());
            GridData gd = new GridData(1808);
            gd.horizontalIndent = 0;
            gd.verticalIndent = 0;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            placeholder.setLayoutData((Object)gd);
            this.controller.lockActionsByControl((Control)placeholder);
        }
        if ((supportedEditTypes = (valueController = new SpreadsheetValueController(this.controller, attr, row, inline ? IValueController.EditType.INLINE : IValueController.EditType.EDITOR, placeholder)).getValueManager().getSupportedEditTypes()).length == 0) {
            if (placeholder != null) {
                placeholder.dispose();
            }
            return null;
        }
        try {
            editor = valueController.getValueManager().createEditor(valueController);
        }
        catch (Exception e2) {
            DBUserInterface.getInstance().showError("Cannot edit value", null, (Throwable)e2);
            return null;
        }
        if (editor != null) {
            editor.createControl();
        }
        if (editor instanceof IValueEditorStandalone) {
            valueController.registerEditor((IValueEditorStandalone)editor);
            Control editorControl = editor.getControl();
            if (editorControl != null) {
                editorControl.addDisposeListener(e -> valueController.unregisterEditor((IValueEditorStandalone)editor));
            }
            new UIJob("Open separate editor"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ((IValueEditorStandalone)editor).showValueEditor();
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else if (editor != null) {
            try {
                editor.primeEditorValue(valueController.getValue());
            }
            catch (DBException e3) {
                log.error((Object)e3);
            }
            editor.setDirty(false);
        }
        if (inline) {
            if (editor != null) {
                this.spreadsheet.showCellEditor(placeholder);
                return editor.getControl();
            }
            placeholder.dispose();
            if (ArrayUtils.contains((Object[])supportedEditTypes, (Object)((Object)IValueController.EditType.PANEL))) {
                this.controller.activatePanel("value-view", true, true);
                return null;
            }
        }
        return null;
    }

    public void resetCellValue(@NotNull Object colElement, @NotNull Object rowElement, boolean delete) {
        boolean recordMode = this.controller.isRecordMode();
        DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? rowElement : colElement);
        ResultSetRow row = (ResultSetRow)(recordMode ? colElement : rowElement);
        this.controller.getModel().resetCellValue(attr, row);
        this.updateValueView();
        this.controller.updatePanelsContent(false);
    }

    public void navigateLink(@NotNull GridCell cell, final int state) {
        boolean recordMode = this.controller.isRecordMode();
        final DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? cell.row : cell.col);
        final ResultSetRow row = (ResultSetRow)(recordMode ? cell.col : cell.row);
        Object value = this.controller.getModel().getCellValue(attr, row);
        if (DBUtils.isNullValue((Object)value)) {
            log.warn((Object)"Can't navigate to NULL value");
            return;
        }
        if (!CommonUtils.isEmpty((Collection)attr.getReferrers())) {
            new AbstractJob("Navigate association"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        boolean ctrlPressed = (state & 0x40000) == 262144;
                        SpreadsheetPresentation.this.controller.navigateAssociation(monitor, attr, row, ctrlPressed);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            String strValue = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, DBDDisplayFormat.UI);
            UIUtils.launchProgram(strValue);
        }
    }

    @Override
    protected void applyThemeSettings() {
        ITheme currentTheme = this.themeManager.getCurrentTheme();
        Font rsFont = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.sql.resultset.font");
        if (rsFont != null) {
            this.spreadsheet.setFont(rsFont);
        }
        ColorRegistry colorRegistry = currentTheme.getColorRegistry();
        Color previewBack = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.preview.background");
        this.backgroundAdded = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.new.background");
        this.backgroundDeleted = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.deleted.background");
        this.backgroundModified = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.modified.background");
        this.backgroundOdd = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.odd.background");
        this.backgroundReadOnly = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.readonly.background");
        this.foregroundSelected = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.selection.foreground");
        this.backgroundSelected = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.selection.background");
        this.backgroundMatched = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.matched.background");
        this.cellHeaderForeground = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.header.foreground");
        this.cellHeaderBackground = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.header.background");
        if (this.cellHeaderSelectionBackground != null) {
            UIUtils.dispose((Resource)this.cellHeaderSelectionBackground);
            this.cellHeaderSelectionBackground = null;
        }
        Color headerSelectionBackground = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.header.selected.background");
        RGB cellSel = UIUtils.blend(headerSelectionBackground.getRGB(), new RGB(255, 255, 255), 50);
        this.cellHeaderSelectionBackground = new Color((Device)this.getSpreadsheet().getDisplay(), cellSel);
        this.foregroundNull = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.null.foreground");
        this.dataTypesForegrounds.put(DBPDataKind.BINARY, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.binary.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.BOOLEAN, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.boolean.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.DATETIME, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.datetime.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.NUMERIC, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.numeric.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.STRING, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.string.foreground"));
        this.spreadsheet.setLineColor(colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.lines.normal"));
        this.spreadsheet.setLineSelectedColor(colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.lines.selected"));
        this.spreadsheet.recalculateSizes();
    }

    private boolean supportsDataFilter() {
        DBSDataContainer dataContainer = this.controller.getDataContainer();
        return dataContainer != null && (dataContainer.getSupportedFeatures() & 4) == 4;
    }

    public void changeSorting(Object columnElement, int state) {
        if (columnElement == null) {
            this.columnOrder = this.columnOrder == -1 ? 128 : (this.columnOrder == 128 ? 1024 : -1);
            this.spreadsheet.refreshData(false, true);
            this.spreadsheet.redrawGrid();
            return;
        }
        boolean ctrlPressed = (state & 0x40000) == 262144;
        boolean altPressed = (state & 0x10000) == 65536;
        this.controller.toggleSortOrder((DBDAttributeBinding)columnElement, ctrlPressed, altPressed);
    }

    public void showFiltering(Object columnElement) {
        if (this.getSelection().getSelectedRows().size() == 0 || !this.getSelection().getSelectedAttributes().contains(columnElement) || this.curAttribute == null) {
            this.spreadsheet.deselectAll();
            this.controller.showDistinctFilter((DBDAttributeBinding)columnElement);
        } else {
            this.controller.showDistinctFilter(this.curAttribute);
        }
    }

    public DBPPreferenceStore getPreferenceStore() {
        return this.controller.getPreferenceStore();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            PropertyPageStandard page = new PropertyPageStandard();
            page.setPropertySourceProvider(new IPropertySourceProvider(){

                @Nullable
                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof GridCell) {
                        GridCell cell = (GridCell)object;
                        boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
                        DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? cell.row : cell.col);
                        ResultSetRow row = (ResultSetRow)(recordMode ? cell.col : cell.row);
                        SpreadsheetValueController valueController = new SpreadsheetValueController(SpreadsheetPresentation.this.controller, attr, row, IValueController.EditType.NONE, null);
                        PropertyCollector props = new PropertyCollector(valueController.getBinding().getAttribute(), false);
                        props.collectProperties();
                        valueController.getValueManager().contributeProperties(props, valueController);
                        return new PropertySourceDelegate(props);
                    }
                    return null;
                }
            });
            return adapter.cast(page);
        }
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    @Nullable
    public DBDAttributeBinding getFocusAttribute() {
        return this.controller.isRecordMode() ? (DBDAttributeBinding)this.spreadsheet.getFocusRowElement() : (DBDAttributeBinding)this.spreadsheet.getFocusColumnElement();
    }

    @Nullable
    public ResultSetRow getFocusRow() {
        return this.controller.isRecordMode() ? (ResultSetRow)this.spreadsheet.getFocusColumnElement() : (ResultSetRow)this.spreadsheet.getFocusRowElement();
    }

    public IResultSetSelection getSelection() {
        return new SpreadsheetSelectionImpl();
    }

    @Override
    public void setSelection(ISelection selection) {
        if (selection instanceof IResultSetSelection && ((IResultSetSelection)selection).getController() == this.getController()) {
            return;
        }
        this.spreadsheet.deselectAll();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            ArrayList<GridPos> cellSelection = new ArrayList<GridPos>();
            for (Object cell : (IStructuredSelection)selection) {
                if (cell instanceof GridPos) {
                    cellSelection.add((GridPos)cell);
                    continue;
                }
                log.warn((Object)("Bad selection object: " + cell));
            }
            this.spreadsheet.selectCells(cellSelection);
            this.spreadsheet.showSelection();
        }
        this.fireSelectionChanged(selection);
    }

    @Override
    public void moveColumn(Object dragColumn, Object dropColumn, IGridController.DropLocation location) {
        if (dragColumn instanceof DBDAttributeBinding && dropColumn instanceof DBDAttributeBinding) {
            DBDDataFilter dataFilter = new DBDDataFilter(this.controller.getModel().getDataFilter());
            DBDAttributeConstraint dragC = dataFilter.getConstraint((DBDAttributeBinding)dragColumn);
            DBDAttributeConstraint dropC = dataFilter.getConstraint((DBDAttributeBinding)dropColumn);
            int sourcePosition = dragC.getVisualPosition();
            int targetPosition = dropC.getVisualPosition();
            switch (location) {
                case DROP_AFTER: {
                    if (sourcePosition <= targetPosition || targetPosition >= dataFilter.getConstraints().size() - 1) break;
                    ++targetPosition;
                    break;
                }
                case DROP_BEFORE: {
                    if (sourcePosition >= targetPosition || targetPosition <= 0) break;
                    --targetPosition;
                    break;
                }
                case SWAP: {
                    dropC.setVisualPosition(dragC.getVisualPosition());
                    dragC.setVisualPosition(targetPosition);
                }
            }
            if (sourcePosition == targetPosition) {
                return;
            }
            if (location != IGridController.DropLocation.SWAP) {
                for (DBDAttributeConstraint c : dataFilter.getConstraints()) {
                    if (c == dragC) continue;
                    int cPos = c.getVisualPosition();
                    if (sourcePosition < targetPosition) {
                        if (cPos <= sourcePosition || cPos > targetPosition) continue;
                        c.setVisualPosition(cPos - 1);
                        continue;
                    }
                    if (cPos >= sourcePosition || cPos < targetPosition) continue;
                    c.setVisualPosition(cPos + 1);
                }
                dragC.setVisualPosition(targetPosition);
            }
            this.controller.setDataFilter(dataFilter, false);
            this.spreadsheet.setFocusColumn(targetPosition);
            this.spreadsheet.refreshData(false, true);
        }
    }

    private class ContentProvider
    implements IGridContentProvider {
        private ContentProvider() {
        }

        @Override
        @NotNull
        public Object[] getElements(boolean horizontal) {
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            ResultSetModel model = SpreadsheetPresentation.this.controller.getModel();
            if (horizontal) {
                Object[] objectArray;
                if (!recordMode) {
                    return model.getVisibleAttributes().toArray();
                }
                ResultSetRow curRow = SpreadsheetPresentation.this.controller.getCurrentRow();
                if (curRow == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = curRow;
                }
                return objectArray;
            }
            if (!recordMode) {
                return model.getAllRows().toArray();
            }
            Object[] columns = model.getVisibleAttributes().toArray(new DBDAttributeBinding[model.getVisibleAttributeCount()]);
            if (SpreadsheetPresentation.this.columnOrder != 0 && SpreadsheetPresentation.this.columnOrder != -1) {
                Arrays.sort(columns, new Comparator<DBDAttributeBinding>(){

                    @Override
                    public int compare(DBDAttributeBinding o1, DBDAttributeBinding o2) {
                        return o1.getName().compareTo(o2.getName()) * (SpreadsheetPresentation.this.columnOrder == 128 ? 1 : -1);
                    }
                });
            }
            return columns;
        }

        @Override
        @Nullable
        public Object[] getChildren(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                switch (binding.getDataKind()) {
                    case ARRAY: {
                        if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                            Object value;
                            ResultSetRow curRow = SpreadsheetPresentation.this.controller.getCurrentRow();
                            if (curRow != null && (value = SpreadsheetPresentation.this.controller.getModel().getCellValue(binding, curRow)) instanceof DBDCollection) {
                                return curRow.getCollectionData(binding, (DBDCollection)value).getElements();
                            }
                            return null;
                        }
                    }
                    case STRUCT: 
                    case DOCUMENT: 
                    case ANY: {
                        List<DBDAttributeBinding> children = SpreadsheetPresentation.this.controller.getModel().getVisibleAttributes(binding);
                        if (children == null) break;
                        return children.toArray();
                    }
                }
            }
            return null;
        }

        @Override
        public int getSortOrder(@Nullable Object column) {
            if (SpreadsheetPresentation.this.controller.getPreferenceStore().getBoolean("resultset.show.attOrdering")) {
                if (column instanceof DBDAttributeBinding) {
                    DBDAttributeBinding binding = (DBDAttributeBinding)column;
                    if (!binding.hasNestedBindings()) {
                        DBDAttributeConstraint co = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(binding);
                        if (co != null && co.getOrderPosition() > 0) {
                            return co.isOrderDescending() ? 1024 : 128;
                        }
                        return -1;
                    }
                } else if (column == null && SpreadsheetPresentation.this.controller.isRecordMode()) {
                    return SpreadsheetPresentation.this.columnOrder;
                }
            }
            return 0;
        }

        @Override
        public IGridContentProvider.ElementState getDefaultState(@NotNull Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                switch (binding.getAttribute().getDataKind()) {
                    case STRUCT: 
                    case DOCUMENT: {
                        return IGridContentProvider.ElementState.EXPANDED;
                    }
                    case ARRAY: {
                        Object cellValue;
                        ResultSetRow curRow = SpreadsheetPresentation.this.controller.getCurrentRow();
                        if (curRow != null && (cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(binding, curRow)) instanceof DBDCollection && ((DBDCollection)cellValue).getItemCount() < 3) {
                            return IGridContentProvider.ElementState.EXPANDED;
                        }
                        return IGridContentProvider.ElementState.COLLAPSED;
                    }
                }
            }
            return IGridContentProvider.ElementState.NONE;
        }

        @Override
        public int getColumnAlign(@Nullable Object element) {
            DBPDataKind dataKind;
            DBDAttributeBinding attr;
            if (SpreadsheetPresentation.this.rightJustifyNumbers && !SpreadsheetPresentation.this.controller.isRecordMode() && (attr = (DBDAttributeBinding)element) != null && ((dataKind = attr.getDataKind()) == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME)) {
                return 2;
            }
            return 0;
        }

        @Override
        public boolean isElementSupportsFilter(Object element) {
            if (element instanceof DBDAttributeBinding) {
                return (SpreadsheetPresentation.this.controller.getDataContainer().getSupportedFeatures() & 4) != 0 && SpreadsheetPresentation.this.controller.getPreferenceStore().getBoolean("resultset.show.attFilters");
            }
            return false;
        }

        @Override
        public int getCellState(Object colElement, Object rowElement, String cellText) {
            int state = 0;
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? rowElement : colElement);
            ResultSetRow row = (ResultSetRow)(recordMode ? colElement : rowElement);
            Object value = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
            if (!CommonUtils.isEmpty((Collection)attr.getReferrers()) && !DBUtils.isNullValue((Object)value)) {
                state |= 1;
            } else {
                String strValue;
                String string = strValue = cellText != null ? cellText : attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, DBDDisplayFormat.UI);
                if (strValue != null && strValue.contains(":")) {
                    try {
                        new URL(strValue);
                        state |= 2;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (attr.isTransformed()) {
                state |= 4;
            }
            return state;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        @Nullable
        public Object getCellValue(Object colElement, Object rowElement, boolean formatString) {
            DBDAttributeBinding attr = (DBDAttributeBinding)(rowElement instanceof DBDAttributeBinding ? rowElement : colElement);
            ResultSetRow row = (ResultSetRow)(colElement instanceof ResultSetRow ? colElement : rowElement);
            int rowNum = row.getVisualNumber();
            Object value = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            if (rowNum > 0 && rowNum == SpreadsheetPresentation.this.controller.getModel().getRowCount() - 1 && SpreadsheetPresentation.this.controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment") && (recordMode || SpreadsheetPresentation.this.spreadsheet.isRowVisible(rowNum)) && SpreadsheetPresentation.this.controller.isHasMoreData()) {
                SpreadsheetPresentation.this.controller.readNextSegment();
            }
            if (formatString) {
                if (recordMode) {
                    if (attr.getDataKind() == DBPDataKind.ARRAY && value instanceof DBDCollection) {
                        return "[" + ((DBDCollection)value).getItemCount() + "]";
                    }
                    if (attr.getDataKind() == DBPDataKind.STRUCT && value instanceof DBDComposite) {
                        return "[" + ((DBDComposite)value).getDataType().getName() + "]";
                    }
                }
                return attr.getValueRenderer().getValueDisplayString((DBSTypedObject)attr.getAttribute(), value, DBDDisplayFormat.UI);
            }
            return value;
        }

        @Override
        @Nullable
        public DBPImage getCellImage(Object colElement, Object rowElement) {
            return null;
        }

        @Override
        @NotNull
        public String getCellText(Object colElement, Object rowElement) {
            return String.valueOf(this.getCellValue(colElement, rowElement, true));
        }

        @Override
        @Nullable
        public Color getCellForeground(Object colElement, Object rowElement, boolean selected) {
            if (selected) {
                return SpreadsheetPresentation.this.foregroundSelected;
            }
            ResultSetRow row = (ResultSetRow)(!SpreadsheetPresentation.this.controller.isRecordMode() ? rowElement : colElement);
            if (row.foreground != null) {
                return row.foreground;
            }
            Object value = this.getCellValue(colElement, rowElement, false);
            if (DBUtils.isNullValue((Object)value)) {
                return SpreadsheetPresentation.this.foregroundNull;
            }
            if (SpreadsheetPresentation.this.colorizeDataTypes) {
                DBDAttributeBinding attr = (DBDAttributeBinding)(rowElement instanceof DBDAttributeBinding ? rowElement : colElement);
                Color color = (Color)SpreadsheetPresentation.this.dataTypesForegrounds.get(attr.getDataKind());
                if (color != null) {
                    return color;
                }
            }
            if (SpreadsheetPresentation.this.foregroundDefault == null) {
                SpreadsheetPresentation.this.foregroundDefault = SpreadsheetPresentation.this.controller.getDefaultForeground();
            }
            return SpreadsheetPresentation.this.foregroundDefault;
        }

        @Override
        @Nullable
        public Color getCellBackground(Object colElement, Object rowElement, boolean selected) {
            String cellText;
            Pattern searchPattern;
            if (selected) {
                Color normalColor = this.getCellBackground(colElement, rowElement, false);
                if (normalColor == SpreadsheetPresentation.this.backgroundNormal) {
                    return SpreadsheetPresentation.this.backgroundSelected;
                }
                RGB mixRGB = UIUtils.blend(normalColor.getRGB(), SpreadsheetPresentation.this.backgroundSelected.getRGB(), 50);
                return DBeaverUI.getSharedTextColors().getColor(mixRGB);
            }
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            ResultSetRow row = (ResultSetRow)(!recordMode ? rowElement : colElement);
            DBDAttributeBinding attribute = (DBDAttributeBinding)(!recordMode ? colElement : rowElement);
            if (SpreadsheetPresentation.this.findReplaceTarget.isSessionActive() && (searchPattern = SpreadsheetPresentation.this.findReplaceTarget.getSearchPattern()) != null && searchPattern.matcher(cellText = this.getCellText(colElement, rowElement)).find()) {
                return SpreadsheetPresentation.this.backgroundMatched;
            }
            if (row.getState() == 2) {
                return SpreadsheetPresentation.this.backgroundAdded;
            }
            if (row.getState() == 3) {
                return SpreadsheetPresentation.this.backgroundDeleted;
            }
            if (row.changes != null && row.changes.containsKey(attribute)) {
                return SpreadsheetPresentation.this.backgroundModified;
            }
            if (row.background != null) {
                return row.background;
            }
            if (attribute.getValueHandler() instanceof DBDValueHandlerComposite) {
                return SpreadsheetPresentation.this.backgroundReadOnly;
            }
            if (!recordMode && SpreadsheetPresentation.this.showOddRows) {
                int rowNumber;
                int rowRelativeNumber;
                boolean odd;
                int rowBatchSize = SpreadsheetPresentation.this.getPreferenceStore().getInt("resultset.show.row.batch.size");
                if (rowBatchSize < 1) {
                    rowBatchSize = 1;
                }
                boolean bl = odd = (rowRelativeNumber = (rowNumber = row.getVisualNumber()) % (rowBatchSize * 2)) < rowBatchSize;
                if (odd) {
                    return SpreadsheetPresentation.this.backgroundOdd;
                }
            }
            if (SpreadsheetPresentation.this.backgroundNormal == null) {
                SpreadsheetPresentation.this.backgroundNormal = SpreadsheetPresentation.this.controller.getDefaultBackground();
            }
            return SpreadsheetPresentation.this.backgroundNormal;
        }

        @Override
        public Color getCellHeaderForeground() {
            return SpreadsheetPresentation.this.cellHeaderForeground;
        }

        @Override
        public Color getCellHeaderBackground() {
            return SpreadsheetPresentation.this.cellHeaderBackground;
        }

        @Override
        public Color getCellHeaderSelectionBackground() {
            return SpreadsheetPresentation.this.cellHeaderSelectionBackground;
        }

        @Override
        public void resetColors() {
            SpreadsheetPresentation.this.backgroundNormal = null;
            SpreadsheetPresentation.this.foregroundDefault = null;
        }
    }

    private class GridLabelProvider
    implements IGridLabelProvider {
        private GridLabelProvider() {
        }

        @Override
        @Nullable
        public Image getImage(Object element) {
            if (element instanceof DBDAttributeBinding && SpreadsheetPresentation.this.controller.getPreferenceStore().getBoolean("resultset.show.attIcons")) {
                return DBeaverIcons.getImage(DBValueFormatting.getObjectImage((DBPObject)((DBDAttributeBinding)element).getAttribute()));
            }
            return null;
        }

        @Override
        public Object getGridOption(String option) {
            if ("OPTION_EXCLUDE_COLUMN_NAME_FOR_WIDTH_CALC".equals(option)) {
                return SpreadsheetPresentation.this.getPreferenceStore().getBoolean("resultset.calc.columnWidthByValues");
            }
            return null;
        }

        @Nullable
        public Color getForeground(Object element) {
            if (element == null) {
                if (SpreadsheetPresentation.this.foregroundDefault == null) {
                    SpreadsheetPresentation.this.foregroundDefault = SpreadsheetPresentation.this.controller.getDefaultForeground();
                }
                return SpreadsheetPresentation.this.foregroundDefault;
            }
            return null;
        }

        @Nullable
        public Color getBackground(Object element) {
            if (SpreadsheetPresentation.this.backgroundNormal == null) {
                SpreadsheetPresentation.this.backgroundNormal = SpreadsheetPresentation.this.controller.getDefaultBackground();
            }
            if (element == null) {
                return SpreadsheetPresentation.this.backgroundNormal;
            }
            return null;
        }

        @Override
        @NotNull
        public String getText(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)element;
                if (CommonUtils.isEmpty((String)attributeBinding.getLabel())) {
                    return attributeBinding.getName();
                }
                return attributeBinding.getLabel();
            }
            if (!SpreadsheetPresentation.this.controller.isRecordMode()) {
                return String.valueOf(((ResultSetRow)element).getVisualNumber() + 1);
            }
            return CoreMessages.controls_resultset_viewer_value;
        }

        @Override
        @Nullable
        public String getDescription(Object element) {
            if (!SpreadsheetPresentation.this.getPreferenceStore().getBoolean("resultset.show.columnDescription")) {
                return null;
            }
            if (element instanceof DBDAttributeBinding) {
                return ((DBDAttributeBinding)element).getDescription();
            }
            return null;
        }

        @Nullable
        public Font getFont(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)element;
                DBDAttributeConstraint constraint = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(attributeBinding);
                if (constraint != null && constraint.hasCondition()) {
                    return SpreadsheetPresentation.this.boldFont;
                }
                if (attributeBinding.isTransformed()) {
                    return SpreadsheetPresentation.this.italicFont;
                }
            }
            return null;
        }

        @Nullable
        public String getToolTipText(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)element;
                String name = attributeBinding.getName();
                String typeName = attributeBinding.getFullTypeName();
                String description = attributeBinding.getDescription();
                return CommonUtils.isEmpty((String)description) ? String.valueOf(name) + ": " + typeName : String.valueOf(name) + ": " + typeName + "\n" + description;
            }
            return null;
        }
    }

    private class SpreadsheetSelectionImpl
    implements IResultSetSelection {
        private SpreadsheetSelectionImpl() {
        }

        @Nullable
        public GridPos getFirstElement() {
            Collection<GridPos> ssSelection = SpreadsheetPresentation.this.spreadsheet.getSelection();
            if (ssSelection.isEmpty()) {
                return null;
            }
            return ssSelection.iterator().next();
        }

        public Iterator<GridPos> iterator() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().iterator();
        }

        public int size() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().size();
        }

        public Object[] toArray() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().toArray();
        }

        public List toList() {
            return new ArrayList<GridPos>(SpreadsheetPresentation.this.spreadsheet.getSelection());
        }

        public boolean isEmpty() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().isEmpty();
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return SpreadsheetPresentation.this.getController();
        }

        @Override
        @NotNull
        public Collection<DBDAttributeBinding> getSelectedAttributes() {
            if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                Object[] elements = SpreadsheetPresentation.this.spreadsheet.getContentProvider().getElements(false);
                ArrayList<DBDAttributeBinding> attrs = new ArrayList<DBDAttributeBinding>();
                ArrayList<Integer> rowSelection = new ArrayList<Integer>(SpreadsheetPresentation.this.spreadsheet.getRowSelection());
                Collections.sort(rowSelection);
                for (Integer row : rowSelection) {
                    if (row >= elements.length) continue;
                    attrs.add((DBDAttributeBinding)elements[row]);
                }
                return attrs;
            }
            ArrayList<DBDAttributeBinding> attrs = new ArrayList<DBDAttributeBinding>();
            for (Object row : SpreadsheetPresentation.this.spreadsheet.getColumnSelection()) {
                attrs.add((DBDAttributeBinding)row);
            }
            return attrs;
        }

        @Override
        @NotNull
        public Collection<ResultSetRow> getSelectedRows() {
            if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                ResultSetRow currentRow = SpreadsheetPresentation.this.controller.getCurrentRow();
                if (currentRow == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(currentRow);
            }
            ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>();
            for (Integer row : SpreadsheetPresentation.this.spreadsheet.getRowSelection()) {
                rows.add(SpreadsheetPresentation.this.controller.getModel().getRow(row));
            }
            Collections.sort(rows, new Comparator<ResultSetRow>(){

                @Override
                public int compare(ResultSetRow o1, ResultSetRow o2) {
                    return o1.getVisualNumber() - o2.getVisualNumber();
                }
            });
            return rows;
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            GridPos pos = (GridPos)element;
            return (DBDAttributeBinding)(SpreadsheetPresentation.this.controller.isRecordMode() ? SpreadsheetPresentation.this.spreadsheet.getRowElement(pos.row) : SpreadsheetPresentation.this.spreadsheet.getColumnElement(pos.col));
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return SpreadsheetPresentation.this.controller.isRecordMode() ? SpreadsheetPresentation.this.controller.getCurrentRow() : SpreadsheetPresentation.this.spreadsheet.getRowElement(((GridPos)element).row);
        }
    }

    public class SpreadsheetValueController
    extends ResultSetValueController
    implements IMultiController {
        public SpreadsheetValueController(@NotNull IResultSetController controller, @NotNull DBDAttributeBinding binding, @NotNull ResultSetRow row, @Nullable IValueController.EditType editType, Composite inlinePlaceholder) {
            super(controller, binding, row, editType, inlinePlaceholder);
        }

        @Override
        public Object getValue() {
            return SpreadsheetPresentation.this.spreadsheet.getContentProvider().getCellValue(this.curRow, this.binding, false);
        }

        @Override
        public void closeInlineEditor() {
            SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
        }

        @Override
        public void nextInlineEditor(boolean next) {
            SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
            int colOffset = next ? 1 : -1;
            int rowOffset = 0;
            int colCount = SpreadsheetPresentation.this.spreadsheet.getColumnCount();
            GridPos curPosition = SpreadsheetPresentation.this.spreadsheet.getCursorPosition();
            if (colOffset > 0 && curPosition.col + colOffset >= colCount) {
                colOffset = -colCount;
                rowOffset = 1;
            } else if (colOffset < 0 && curPosition.col + colOffset < 0) {
                colOffset = colCount;
                rowOffset = -1;
            }
            SpreadsheetPresentation.this.spreadsheet.shiftCursor(colOffset, rowOffset, false);
            SpreadsheetPresentation.this.openValueEditor(true);
        }

        @Override
        public void updateValue(@Nullable Object value, boolean updatePresentation) {
            super.updateValue(value, updatePresentation);
            if (updatePresentation) {
                SpreadsheetPresentation.this.spreadsheet.redrawGrid();
            }
        }

        @Override
        public void updateSelectionValue(Object value) {
            DBDAttributeBinding origAttr = this.getBinding();
            ResultSetRow origRow = this.getCurRow();
            try {
                Collection<GridPos> ssSelection = SpreadsheetPresentation.this.spreadsheet.getSelection();
                for (GridPos pos : ssSelection) {
                    ResultSetRow row;
                    DBDAttributeBinding attr;
                    if (this.controller.isRecordMode()) {
                        attr = (DBDAttributeBinding)SpreadsheetPresentation.this.spreadsheet.getRowElement(pos.row);
                        row = this.controller.getCurrentRow();
                    } else {
                        attr = (DBDAttributeBinding)SpreadsheetPresentation.this.spreadsheet.getColumnElement(pos.col);
                        row = (ResultSetRow)SpreadsheetPresentation.this.spreadsheet.getRowElement(pos.row);
                    }
                    if (attr == null || row == null || attr.getValueHandler() != origAttr.getValueHandler() || this.controller.isAttributeReadOnly(attr)) continue;
                    this.setBinding(attr);
                    this.setCurRow(row);
                    this.updateValue(value, true);
                }
            }
            finally {
                this.setBinding(origAttr);
                this.setCurRow(origRow);
            }
        }

        public void registerEditor(IValueEditorStandalone editor) {
            SpreadsheetPresentation.this.openEditors.put(this, editor);
        }

        public void unregisterEditor(IValueEditorStandalone editor) {
            SpreadsheetPresentation.this.openEditors.remove(this);
        }
    }
}

