/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.SystemJob;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextContentAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.FilterSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLWordPartDetector;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class ResultSetFilterPanel
extends Composite
implements IContentProposalProvider {
    private static final Log log = Log.getLog(ResultSetFilterPanel.class);
    private static final int MIN_FILTER_TEXT_WIDTH = 50;
    private static final int MIN_FILTER_TEXT_HEIGHT = 20;
    private static final int MAX_HISTORY_PANEL_HEIGHT = 200;
    private static final String DEFAULT_QUERY_TEXT = "SQL";
    private final ResultSetViewer viewer;
    private final ActiveObjectPanel activeObjectPanel;
    private final RefreshPanel refreshPanel;
    private final HistoryPanel historyPanel;
    private final StyledText filtersText;
    private final ToolBar filterToolbar;
    private final ToolItem filtersApplyButton;
    private final ToolItem filtersClearButton;
    private final ToolItem filtersSaveButton;
    private final ToolItem historyBackButton;
    private final ToolItem historyForwardButton;
    private final Composite filterComposite;
    private final Color hoverBgColor;
    private final Color shadowColor;
    private final GC sizingGC;
    private final Font hintFont;
    private String activeDisplayName = "SQL";
    private String prevQuery = null;
    private final List<String> filtersHistory = new ArrayList<String>();
    private Menu historyMenu;

    ResultSetFilterPanel(ResultSetViewer rsv) {
        super(rsv.getControl(), 0);
        this.viewer = rsv;
        this.setLayoutData(new GridData(768));
        this.sizingGC = new GC((Drawable)this);
        GridLayout gl = new GridLayout(4, false);
        gl.marginHeight = 3;
        gl.marginWidth = 3;
        this.setLayout((Layout)gl);
        this.hoverBgColor = this.getDisplay().getSystemColor(19);
        this.shadowColor = this.getDisplay().getSystemColor(18);
        this.hintFont = UIUtils.modifyFont(this.getFont(), 2);
        this.filterComposite = new Composite((Composite)this, 2048);
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.filterComposite.setLayout((Layout)gl);
        this.filterComposite.setLayoutData((Object)new GridData(768));
        this.activeObjectPanel = new ActiveObjectPanel(this.filterComposite);
        this.filtersText = new StyledText(this.filterComposite, 4);
        this.filtersText.setLayoutData((Object)new GridData(768));
        UIUtils.fillDefaultStyledTextContextMenu(this.filtersText);
        this.historyPanel = new HistoryPanel(this.filterComposite);
        this.refreshPanel = new RefreshPanel(this.filterComposite);
        UIUtils.addDefaultEditActionsSupport((IServiceLocator)this.viewer.getSite(), (Control)this.filtersText);
        this.filtersText.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean supportsDataFilter = ResultSetFilterPanel.this.viewer.supportsDataFilter();
                if (!supportsDataFilter || ResultSetFilterPanel.this.filtersText.isEnabled() && ResultSetFilterPanel.this.filtersText.getCharCount() == 0) {
                    e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
                    e.gc.setFont(ResultSetFilterPanel.this.hintFont);
                    e.gc.drawText(supportsDataFilter ? CoreMessages.sql_editor_resultset_filter_panel_text_enter_sql_to_filter : CoreMessages.sql_editor_resultset_filter_panel_text_enter_filter_not_support, 2, 0, true);
                    e.gc.setFont(null);
                }
            }
        });
        this.filtersText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = ResultSetFilterPanel.this.filtersText.getText();
                ResultSetFilterPanel.this.filtersApplyButton.setEnabled(true);
                ResultSetFilterPanel.this.filtersClearButton.setEnabled(!CommonUtils.isEmpty((String)filterText));
            }
        });
        this.filtersText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ResultSetFilterPanel.this.historyPanel.showFilterHistoryPopup();
                }
            }
        });
        StyledTextContentAdapter contentAdapter = new StyledTextContentAdapter(this.filtersText){

            @Override
            public void setControlContents(Control control, String text, int cursorPosition) {
                Point selection = ResultSetFilterPanel.this.filtersText.getSelection();
                String curText = ResultSetFilterPanel.this.filtersText.getText();
                int insertPosition = selection.x;
                int i = selection.x - 1;
                while (i >= 0) {
                    if (!Character.isUnicodeIdentifierPart(curText.charAt(i))) break;
                    insertPosition = i--;
                }
                ResultSetFilterPanel.this.filtersText.setSelection(insertPosition, selection.y);
                this.insertControlContents(control, text, cursorPosition);
            }
        };
        UIUtils.installContentProposal((Control)this.filtersText, contentAdapter, this, false, false);
        UIUtils.enableHostEditorKeyBindingsSupport(this.viewer.getSite(), (Control)this.filtersText);
        this.filterToolbar = new ToolBar((Composite)this, 131328);
        this.filtersApplyButton = new ToolItem(this.filterToolbar, 524296);
        this.filtersApplyButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_APPLY));
        this.filtersApplyButton.setToolTipText(CoreMessages.sql_editor_resultset_filter_panel_btn_apply);
        this.filtersApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetFilterPanel.this.setCustomDataFilter();
            }
        });
        this.filtersApplyButton.setEnabled(false);
        this.filtersClearButton = new ToolItem(this.filterToolbar, 524296);
        this.filtersClearButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_RESET));
        this.filtersClearButton.setToolTipText(CoreMessages.sql_editor_resultset_filter_panel_btn_remove);
        this.filtersClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetFilterPanel.this.viewer.resetDataFilter(true);
            }
        });
        this.filtersClearButton.setEnabled(false);
        this.filtersSaveButton = new ToolItem(this.filterToolbar, 524296);
        this.filtersSaveButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_SAVE));
        this.filtersSaveButton.setToolTipText(CoreMessages.sql_editor_resultset_filter_panel_btn_save);
        this.filtersSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetFilterPanel.this.viewer.saveDataFilter();
            }
        });
        this.filtersSaveButton.setEnabled(false);
        ToolItem filtersCustomButton = new ToolItem(this.filterToolbar, 524296);
        filtersCustomButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER));
        filtersCustomButton.setToolTipText(CoreMessages.sql_editor_resultset_filter_panel_btn_custom);
        filtersCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new FilterSettingsDialog(ResultSetFilterPanel.this.viewer).open();
            }
        });
        filtersCustomButton.setEnabled(true);
        UIUtils.createToolBarSeparator(this.filterToolbar, 512);
        rsv.getAutoRefresh().populateRefreshButton(this.filterToolbar);
        UIUtils.createToolBarSeparator(this.filterToolbar, 512);
        this.historyBackButton = new ToolItem(this.filterToolbar, 524292);
        this.historyBackButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.RS_BACK));
        this.historyBackButton.setEnabled(false);
        this.historyBackButton.addSelectionListener((SelectionListener)new HistoryMenuListener(this.historyBackButton, true));
        this.historyForwardButton = new ToolItem(this.filterToolbar, 524292);
        this.historyForwardButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.RS_FORWARD));
        this.historyForwardButton.setEnabled(false);
        this.historyForwardButton.addSelectionListener((SelectionListener)new HistoryMenuListener(this.historyForwardButton, false));
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    ResultSetFilterPanel.this.setCustomDataFilter();
                    e.doit = false;
                    e.detail = 0;
                }
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ResultSetFilterPanel.this.redrawPanels();
            }

            public void controlResized(ControlEvent e) {
                ResultSetFilterPanel.this.redrawPanels();
            }
        });
        this.enablePanelControls(false);
        this.addDisposeListener(e -> {
            if (this.historyMenu != null) {
                this.historyMenu.dispose();
                this.historyMenu = null;
            }
            UIUtils.dispose((Resource)this.sizingGC);
            UIUtils.dispose((Resource)this.hintFont);
        });
    }

    void enableFilters(boolean enableFilters) {
        Pattern mlCommentsPattern;
        Matcher m;
        if (this.isDisposed()) {
            return;
        }
        this.enablePanelControls(enableFilters);
        if (enableFilters) {
            boolean supportsDataFilter = this.viewer.supportsDataFilter();
            int historyPosition = this.viewer.getHistoryPosition();
            List<ResultSetViewer.HistoryStateItem> stateHistory = this.viewer.getStateHistory();
            String filterText = this.filtersText.getText();
            this.filtersText.setEnabled(supportsDataFilter);
            this.filtersApplyButton.setEnabled(supportsDataFilter);
            this.filtersClearButton.setEnabled(this.viewer.getModel().getDataFilter().hasFilters());
            this.filtersSaveButton.setEnabled(this.viewer.getDataContainer() instanceof DBSEntity);
            if (historyPosition > 0) {
                this.historyBackButton.setEnabled(true);
                this.historyBackButton.setToolTipText(String.valueOf(stateHistory.get(historyPosition - 1).describeState()) + " (" + ActionUtils.findCommandDescription("org.eclipse.ui.navigate.backwardHistory", (IServiceLocator)this.viewer.getSite(), true) + ")");
            } else {
                this.historyBackButton.setEnabled(false);
            }
            if (historyPosition < stateHistory.size() - 1) {
                this.historyForwardButton.setEnabled(true);
                this.historyForwardButton.setToolTipText(String.valueOf(stateHistory.get(historyPosition + 1).describeState()) + " (" + ActionUtils.findCommandDescription("org.eclipse.ui.navigate.forwardHistory", (IServiceLocator)this.viewer.getSite(), true) + ")");
            } else {
                this.historyForwardButton.setEnabled(false);
            }
        }
        this.filterComposite.setBackground(this.filtersText.getBackground());
        String displayName = this.getActiveSourceQuery();
        if (this.prevQuery == null || !this.prevQuery.equals(displayName)) {
            this.loadFiltersHistory(displayName);
            this.prevQuery = displayName;
        }
        if ((m = (mlCommentsPattern = Pattern.compile("/\\*.*\\*/", 32)).matcher(displayName)).find()) {
            displayName = m.replaceAll("");
        }
        displayName = displayName.replaceAll("--.+", "");
        displayName = TextUtils.compactWhiteSpaces(displayName);
        this.activeDisplayName = CommonUtils.notEmpty((String)CommonUtils.truncateString((String)displayName, (int)200));
        if (CommonUtils.isEmpty((String)this.activeDisplayName)) {
            this.activeDisplayName = DEFAULT_QUERY_TEXT;
        }
        this.filterComposite.layout();
        this.redrawPanels();
    }

    private void enablePanelControls(boolean enable) {
        this.setRedraw(false);
        try {
            this.filterToolbar.setEnabled(enable);
            this.refreshPanel.setEnabled(enable);
            this.historyPanel.setEnabled(enable);
            this.filtersText.setEditable(enable && this.viewer.supportsDataFilter());
        }
        finally {
            this.setRedraw(true);
        }
    }

    private boolean isFiltersAvailable() {
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        return dataContainer != null && (dataContainer.getSupportedFeatures() & 4) != 0;
    }

    private void redrawPanels() {
        if (this.activeObjectPanel != null && !this.activeObjectPanel.isDisposed()) {
            this.activeObjectPanel.redraw();
        }
        if (this.historyPanel != null && !this.historyPanel.isDisposed()) {
            this.historyPanel.redraw();
        }
        if (this.refreshPanel != null && !this.refreshPanel.isDisposed()) {
            this.refreshPanel.redraw();
        }
    }

    @NotNull
    private String getActiveQueryText() {
        String queryText;
        DBCStatistics statistics = this.viewer.getModel().getStatistics();
        String string = queryText = statistics == null ? null : statistics.getQueryText();
        if (queryText == null || queryText.isEmpty()) {
            DBSDataContainer dataContainer = this.viewer.getDataContainer();
            if (dataContainer != null) {
                return dataContainer.getName();
            }
            queryText = DEFAULT_QUERY_TEXT;
        }
        return queryText;
    }

    @Nullable
    private DBPImage getActiveObjectImage() {
        DBNDatabaseNode dcNode;
        DBPDataSource dataSource;
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        if (dataContainer instanceof DBSEntity && (dataSource = this.viewer.getDataContainer().getDataSource()) != null && (dcNode = dataSource.getContainer().getPlatform().getNavigatorModel().findNode((DBSObject)dataContainer)) != null) {
            return dcNode.getNodeIcon();
        }
        if (dataContainer instanceof DBPImageProvider) {
            return ((DBPImageProvider)dataContainer).getObjectImage();
        }
        if (dataContainer instanceof DBSEntity) {
            return DBIcon.TREE_TABLE;
        }
        return UIIcon.SQL_TEXT;
    }

    @NotNull
    private String getActiveSourceQuery() {
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        String displayName = dataContainer != null ? dataContainer.getName() : this.getActiveQueryText();
        return displayName;
    }

    private void loadFiltersHistory(String query) {
        this.filtersHistory.clear();
        try {
            Collection<String> history = ResultSetViewer.getFilterManager().getQueryFilterHistory(query);
            this.filtersHistory.addAll(history);
        }
        catch (Throwable e) {
            log.debug((Object)"Error reading history", e);
        }
    }

    private void setCustomDataFilter() {
        DBCExecutionContext context = this.viewer.getExecutionContext();
        if (context == null) {
            return;
        }
        String condition = this.filtersText.getText();
        StringBuilder currentCondition = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)this.viewer.getModel().getDataFilter(), (DBPDataSource)context.getDataSource(), null, (StringBuilder)currentCondition, (boolean)true);
        if (currentCondition.toString().trim().equals(condition.trim())) {
            return;
        }
        DBDDataFilter newFilter = new DBDDataFilter(this.viewer.getModel().getDataFilter());
        for (DBDAttributeConstraint ac : newFilter.getConstraints()) {
            ac.setCriteria(null);
        }
        newFilter.setWhere(condition);
        this.viewer.setDataFilter(newFilter, true);
    }

    void addFiltersHistory(String whereCondition) {
        boolean oldFilter = this.filtersHistory.remove(whereCondition);
        this.filtersHistory.add(whereCondition);
        if (!oldFilter) {
            try {
                ResultSetViewer.getFilterManager().saveQueryFilterValue(this.getActiveSourceQuery(), whereCondition);
            }
            catch (Throwable e) {
                log.debug((Object)"Error saving filter", e);
            }
        }
        this.setFilterValue(whereCondition);
    }

    Control getEditControl() {
        return this.filtersText;
    }

    void setFilterValue(String whereCondition) {
        if (whereCondition != null && !this.filtersText.getText().trim().equals(whereCondition.trim())) {
            this.filtersText.setText(whereCondition);
        }
    }

    @NotNull
    private Control createObjectPanel(Shell popup) throws PartInitException {
        Composite panel = new Composite((Composite)popup, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        panel.setLayout((Layout)gl);
        Label iconLabel = new Label(panel, 0);
        DBPImage activeObjectImage = this.getActiveObjectImage();
        if (activeObjectImage != null) {
            iconLabel.setImage(DBeaverIcons.getImage(activeObjectImage));
        }
        iconLabel.setToolTipText(CoreMessages.sql_editor_resultset_filter_panel_label);
        iconLabel.setLayoutData((Object)new GridData(2));
        iconLabel.setCursor(this.getDisplay().getSystemCursor(21));
        iconLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ResultSetFilterPanel.this.openEditorForActiveQuery();
            }
        });
        Composite editorPH = new Composite(panel, 0);
        editorPH.setLayoutData((Object)new GridData(1808));
        editorPH.setLayout((Layout)new FillLayout());
        SQLEditorBase editor = new SQLEditorBase(){

            @Override
            @Nullable
            public DBCExecutionContext getExecutionContext() {
                return ResultSetFilterPanel.this.viewer.getExecutionContext();
            }

            @Override
            public void createPartControl(Composite parent) {
                super.createPartControl(parent);
                this.getAction("Preferences.ContextAction").setEnabled(false);
            }

            @Override
            public boolean isFoldingEnabled() {
                return false;
            }
        };
        editor.setHasVerticalRuler(false);
        editor.init(new SubEditorSite(this.viewer.getSite()), new StringEditorInput(DEFAULT_QUERY_TEXT, this.getActiveQueryText(), true, GeneralUtils.getDefaultFileEncoding()));
        editor.createPartControl(editorPH);
        editor.reloadSyntaxRules();
        StyledText textWidget = editor.getTextViewer().getTextWidget();
        panel.setBackground(textWidget.getBackground());
        panel.addDisposeListener(e -> editor.dispose());
        return textWidget;
    }

    private void openEditorForActiveQuery() {
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        String editorName = dataContainer instanceof DBSEntity ? dataContainer.getName() : "Query";
        OpenHandler.openSQLConsole(DBeaverUI.getActiveWorkbenchWindow(), dataContainer == null || dataContainer.getDataSource() == null ? null : dataContainer.getDataSource().getContainer(), editorName, this.getActiveQueryText());
    }

    public IContentProposal[] getProposals(String contents, int position) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        if (this.viewer.getDataContainer() != null) {
            syntaxManager.init(this.viewer.getDataContainer().getDataSource());
        }
        SQLWordPartDetector wordDetector = new SQLWordPartDetector((IDocument)new Document(contents), syntaxManager, position);
        final String word = wordDetector.getFullWord().toLowerCase(Locale.ENGLISH);
        final ArrayList proposals = new ArrayList();
        DBRRunnableWithProgress reader = new DBRRunnableWithProgress(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DBDAttributeBinding[] dBDAttributeBindingArray = ResultSetFilterPanel.this.viewer.getModel().getAttributes();
                int n = dBDAttributeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDAttributeBinding attribute = dBDAttributeBindingArray[n2];
                    String name = DBUtils.getUnQuotedIdentifier((DBPDataSource)attribute.getDataSource(), (String)attribute.getName());
                    if (CommonUtils.isEmpty((String)word) || name.toLowerCase(Locale.ENGLISH).startsWith(word)) {
                        String content = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)attribute)) + " ";
                        proposals.add(new ContentProposal(content, attribute.getName(), SQLContextInformer.makeObjectDescription(monitor, (DBPNamedObject)attribute.getAttribute(), false), content.length()));
                    }
                    ++n2;
                }
            }
        };
        SystemJob searchJob = new SystemJob("Extract attribute proposals", reader);
        searchJob.schedule();
        UIUtils.waitJobCompletion((AbstractJob)searchJob);
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private class ActiveObjectPanel
    extends FilterPanel {
        static final int MIN_INFO_PANEL_WIDTH = 300;
        static final int MIN_INFO_PANEL_HEIGHT = 100;
        static final int MAX_INFO_PANEL_HEIGHT = 400;
        private Shell popup;

        ActiveObjectPanel(Composite addressBar) {
            super(addressBar, 0);
            this.setLayoutData(new GridData(1040));
            this.setToolTipText(CoreMessages.sql_editor_resultset_filter_panel_btn_open_console);
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    ResultSetFilterPanel.this.openEditorForActiveQuery();
                }

                public void mouseDown(MouseEvent e) {
                    DBeaverUI.asyncExec(() -> ActiveObjectPanel.this.showObjectInfoPopup(e));
                }
            });
        }

        private void showObjectInfoPopup(MouseEvent e) {
            Control editControl;
            if (this.popup != null) {
                this.popup.dispose();
            }
            if ((e.stateMask & 0x40000) != 0) {
                ResultSetFilterPanel.this.openEditorForActiveQuery();
                return;
            }
            this.popup = new Shell(this.getShell(), 16400);
            this.popup.setLayout((Layout)new FillLayout());
            try {
                editControl = ResultSetFilterPanel.this.createObjectPanel(this.popup);
            }
            catch (PartInitException e1) {
                DBUserInterface.getInstance().showError("Object info", "Error opening object info", (Throwable)e1);
                this.popup.dispose();
                return;
            }
            Point controlRect = editControl.computeSize(-1, -1);
            Rectangle parentRect = this.getDisplay().map((Control)ResultSetFilterPanel.this.activeObjectPanel, null, this.getBounds());
            Rectangle displayRect = this.getMonitor().getClientArea();
            int width = Math.min(((ResultSetFilterPanel)ResultSetFilterPanel.this).filterComposite.getSize().x, Math.max(300, controlRect.x + 30));
            int height = Math.min(400, Math.max(100, controlRect.y + 30));
            int x = parentRect.x + e.x + 1;
            int y = parentRect.y + e.y + 1;
            if (y + height > displayRect.y + displayRect.height) {
                y = parentRect.y - height;
            }
            this.popup.setBounds(x, y, width, height);
            this.popup.setVisible(true);
            editControl.setFocus();
            editControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    ActiveObjectPanel.this.popup.dispose();
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int maxWidth = 0;
            Composite control = ResultSetFilterPanel.this.viewer.getControl().getParent();
            while (maxWidth == 0 && control != null) {
                maxWidth = control.getSize().x / 4;
                control = control.getParent();
            }
            Point textSize = ResultSetFilterPanel.this.sizingGC.textExtent(ResultSetFilterPanel.this.activeDisplayName);
            DBPImage activeObjectImage = ResultSetFilterPanel.this.getActiveObjectImage();
            if (activeObjectImage != null) {
                Image image = DBeaverIcons.getImage(activeObjectImage);
                textSize.x += image.getBounds().width + 4;
            }
            return new Point(Math.max(50, Math.min(textSize.x + 10, maxWidth)), Math.min(textSize.y + 6, 20));
        }

        @Override
        protected void paintPanel(PaintEvent e) {
            e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
            if (this.hover) {
                e.gc.setBackground(ResultSetFilterPanel.this.hoverBgColor);
                e.gc.fillRectangle(e.x, e.y, e.width - 3, e.height);
                e.gc.drawLine(e.x + e.width - 4, e.y, e.x + e.width - 4, e.y + e.height);
            } else {
                e.gc.drawLine(e.x + e.width - 4, e.y + 2, e.x + e.width - 4, e.y + e.height - 4);
            }
            e.gc.setForeground(e.gc.getDevice().getSystemColor(6));
            e.gc.setClipping(e.x, e.y, e.width - 8, e.height);
            int textOffset = 2;
            int panelHeight = this.getSize().y;
            DBPImage activeObjectImage = ResultSetFilterPanel.this.getActiveObjectImage();
            if (activeObjectImage != null) {
                Image icon = DBeaverIcons.getImage(activeObjectImage);
                Rectangle iconBounds = icon.getBounds();
                e.gc.drawImage(icon, 2, (panelHeight - iconBounds.height) / 2);
                textOffset += iconBounds.width + 2;
            }
            int textHeight = e.gc.getFontMetrics().getHeight();
            e.gc.drawText(ResultSetFilterPanel.this.activeDisplayName, textOffset, (panelHeight - textHeight) / 2);
            e.gc.setClipping(null);
        }
    }

    private class FilterPanel
    extends Canvas {
        protected boolean hover;

        FilterPanel(Composite parent, int style) {
            super(parent, style);
            this.hover = false;
            this.addPaintListener(this::paintPanel);
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    FilterPanel.this.hover = true;
                    FilterPanel.this.redraw();
                }

                public void mouseExit(MouseEvent e) {
                    FilterPanel.this.hover = false;
                    FilterPanel.this.redraw();
                }
            });
        }

        protected void paintPanel(PaintEvent e) {
        }
    }

    private class HistoryMenuListener
    extends SelectionAdapter {
        private final ToolItem dropdown;
        private final boolean back;

        HistoryMenuListener(ToolItem item, boolean back) {
            this.dropdown = item;
            this.back = back;
        }

        public void widgetSelected(SelectionEvent e) {
            int historyPosition = ResultSetFilterPanel.this.viewer.getHistoryPosition();
            List<ResultSetViewer.HistoryStateItem> stateHistory = ResultSetFilterPanel.this.viewer.getStateHistory();
            if (e.detail == 4) {
                ToolItem item = (ToolItem)e.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                if (ResultSetFilterPanel.this.historyMenu != null) {
                    ResultSetFilterPanel.this.historyMenu.dispose();
                }
                ResultSetFilterPanel.this.historyMenu = new Menu((Control)this.dropdown.getParent().getShell());
                int i = historyPosition + (this.back ? -1 : 1);
                while (i >= 0 && i < stateHistory.size()) {
                    MenuItem mi = new MenuItem(ResultSetFilterPanel.this.historyMenu, 0);
                    ResultSetViewer.HistoryStateItem state = stateHistory.get(i);
                    mi.setText(state.describeState());
                    final int statePosition = i;
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultSetFilterPanel.this.viewer.navigateHistory(statePosition);
                        }
                    });
                    i += this.back ? -1 : 1;
                }
                ResultSetFilterPanel.this.historyMenu.setLocation(pt.x, pt.y + rect.height);
                ResultSetFilterPanel.this.historyMenu.setVisible(true);
            } else {
                int newPosition = this.back ? historyPosition - 1 : historyPosition + 1;
                ResultSetFilterPanel.this.viewer.navigateHistory(newPosition);
            }
        }
    }

    private class HistoryPanel
    extends FilterPanel {
        private final Image dropImageE;
        private final Image dropImageD;
        private TableItem hoverItem;
        private Shell popup;

        HistoryPanel(Composite addressBar) {
            super(addressBar, 0);
            this.dropImageE = DBeaverIcons.getImage((DBPImage)UIIcon.DROP_DOWN);
            this.dropImageD = new Image(this.dropImageE.getDevice(), this.dropImageE, 2);
            GridData gd = new GridData(32);
            gd.heightHint = 20;
            gd.widthHint = this.dropImageE.getBounds().width;
            this.setLayoutData(gd);
            this.addDisposeListener(e -> UIUtils.dispose((Resource)this.dropImageD));
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    HistoryPanel.this.showFilterHistoryPopup();
                }
            });
        }

        @Override
        protected void paintPanel(PaintEvent e) {
            e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
            if (this.hover) {
                e.gc.drawImage(this.dropImageE, e.x, e.y + 2);
            } else {
                e.gc.drawImage(this.dropImageD, e.x, e.y + 2);
            }
        }

        private void showFilterHistoryPopup() {
            if (this.popup != null) {
                this.popup.dispose();
            }
            this.popup = new Shell(this.getShell(), 16408);
            this.popup.setLayout((Layout)new FillLayout());
            Table editControl = this.createFilterHistoryPanel(this.popup);
            Point parentRect = this.getDisplay().map((Control)ResultSetFilterPanel.this.filtersText, null, new Point(0, 0));
            Rectangle displayRect = this.getMonitor().getClientArea();
            Point filterTextSize = ResultSetFilterPanel.this.filtersText.getSize();
            int width = filterTextSize.x + ((ResultSetFilterPanel)ResultSetFilterPanel.this).historyPanel.getSize().x + ((ResultSetFilterPanel)ResultSetFilterPanel.this).refreshPanel.getSize().x;
            int height = Math.min(200, editControl.computeSize((int)-1, (int)-1).y);
            int x = parentRect.x;
            int y = parentRect.y + this.getSize().y;
            if (y + height > displayRect.y + displayRect.height) {
                y = parentRect.y - height;
            }
            this.popup.setBounds(x, y, width, height);
            int tableWidth = editControl.getSize().x - editControl.getBorderWidth() * 2;
            ScrollBar vsb = editControl.getVerticalBar();
            if (vsb != null) {
                tableWidth -= vsb.getSize().x;
            }
            editControl.getColumn(0).setWidth(tableWidth);
            this.popup.setVisible(true);
            editControl.setFocus();
            editControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    HistoryPanel.this.popup.dispose();
                }
            });
        }

        @NotNull
        private Table createFilterHistoryPanel(final Shell popup) {
            final Table historyTable = new Table((Composite)popup, 67588);
            new TableColumn(historyTable, 0);
            if (!ResultSetFilterPanel.this.filtersHistory.isEmpty()) {
                String curFilterValue = ResultSetFilterPanel.this.filtersText.getText();
                int i = ResultSetFilterPanel.this.filtersHistory.size();
                while (i > 0) {
                    String hi = (String)ResultSetFilterPanel.this.filtersHistory.get(i - 1);
                    if (!CommonUtils.equalObjects((Object)hi, (Object)curFilterValue)) {
                        new TableItem(historyTable, 0).setText(hi);
                    }
                    --i;
                }
                historyTable.deselectAll();
            }
            historyTable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    HistoryPanel.this.hoverItem = null;
                }
            });
            historyTable.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int selectionIndex;
                    TableItem item = HistoryPanel.this.hoverItem;
                    if (item == null && (selectionIndex = historyTable.getSelectionIndex()) != -1) {
                        item = historyTable.getItem(selectionIndex);
                    }
                    if (item != null && !item.isDisposed()) {
                        if (e.keyCode == 127) {
                            String filterValue = item.getText();
                            try {
                                ResultSetViewer.getFilterManager().deleteQueryFilterValue(ResultSetFilterPanel.this.getActiveSourceQuery(), filterValue);
                            }
                            catch (DBException e1) {
                                log.warn((Object)("Error deleting filter value [" + filterValue + "]"), (Throwable)e1);
                            }
                            ResultSetFilterPanel.this.filtersHistory.remove(filterValue);
                            item.dispose();
                            HistoryPanel.this.hoverItem = null;
                        } else if (e.keyCode == 13 || e.keyCode == 32) {
                            String newFilter = item.getText();
                            popup.dispose();
                            ResultSetFilterPanel.this.setFilterValue(newFilter);
                            ResultSetFilterPanel.this.setCustomDataFilter();
                        }
                    }
                }
            });
            historyTable.addMouseMoveListener(e -> {
                TableItem tableItem = this.hoverItem = historyTable.getItem(new Point(e.x, e.y));
            });
            historyTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (HistoryPanel.this.hoverItem != null) {
                        String newFilter = HistoryPanel.this.hoverItem.getText();
                        popup.dispose();
                        ResultSetFilterPanel.this.setFilterValue(newFilter);
                        ResultSetFilterPanel.this.setCustomDataFilter();
                    }
                }
            });
            return historyTable;
        }
    }

    private class RefreshPanel
    extends FilterPanel {
        private final Image enabledImage;
        private final Image disabledImage;

        RefreshPanel(Composite addressBar) {
            super(addressBar, 0);
            this.setToolTipText(CoreMessages.controls_resultset_viewer_action_refresh);
            this.enabledImage = DBeaverIcons.getImage((DBPImage)UIIcon.RS_REFRESH);
            this.disabledImage = new Image(this.enabledImage.getDevice(), this.enabledImage, 2);
            this.addDisposeListener(e -> UIUtils.dispose((Resource)this.disabledImage));
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!ResultSetFilterPanel.this.viewer.isRefreshInProgress() && e.x > 8) {
                        ResultSetFilterPanel.this.viewer.refreshData(null);
                        RefreshPanel.this.redraw();
                    }
                }
            });
            GridData gd = new GridData(32);
            gd.heightHint = 20;
            gd.widthHint = 10 + this.enabledImage.getBounds().width + 6;
            this.setLayoutData(gd);
        }

        @Override
        protected void paintPanel(PaintEvent e) {
            e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
            e.gc.drawLine(e.x + 4, e.y + 2, e.x + 4, e.y + e.height - 4);
            if (ResultSetFilterPanel.this.viewer.isRefreshInProgress()) {
                e.gc.drawImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLOSE), e.x + 10, e.y + 2);
            } else if (this.hover) {
                e.gc.drawImage(this.enabledImage, e.x + 10, e.y + 2);
            } else {
                e.gc.drawImage(this.disabledImage, e.x + 10, e.y + 2);
            }
        }
    }
}

