/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCommandHandler;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ValueFormatSelector;
import org.jkiss.utils.CommonUtils;

public class ResultSetCopySpecialHandler
extends ResultSetCommandHandler
implements IElementUpdater {
    public static final String CMD_COPY_SPECIAL = "org.jkiss.dbeaver.core.edit.copy.special";

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetCopySpecialHandler.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.edit.copy.special": {
                ResultSetCopySpecialHandler.showAdvancedCopyDialog(resultSet, HandlerUtil.getActiveShell((ExecutionEvent)event));
            }
        }
        return null;
    }

    public static void showAdvancedCopyDialog(IResultSetController resultSet, Shell shell) {
        AdvancedCopyConfigDialog configDialog = new AdvancedCopyConfigDialog(shell);
        if (configDialog.open() == 0) {
            ResultSetUtils.copyToClipboard(resultSet.getActivePresentation().copySelectionToString(configDialog.copySettings));
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setText(CoreMessages.actions_spreadsheet_copy_special);
    }

    private static class AdvancedCopyConfigDialog
    extends CopyConfigDialog {
        static final String PARAM_COPY_HEADER = "copyHeader";
        static final String PARAM_COPY_ROWS = "copyRows";
        static final String PARAM_QUOTE_CELLS = "quoteCells";
        static final String PARAM_FORCE_QUOTES = "forceQuotes";
        static final String PARAM_FORMAT = "format";
        private Button copyHeaderCheck;
        private Button copyRowsCheck;
        private Button quoteCellsCheck;
        private Button forceQuoteCheck;
        private ValueFormatSelector formatSelector;

        protected AdvancedCopyConfigDialog(Shell shell) {
            super(shell, "AdvanceCopySettings");
            this.copySettings.setQuoteCells(true);
            this.copySettings.setCopyHeader(true);
            this.copySettings.setCopyRowNumbers(false);
            this.copySettings.setFormat(DBDDisplayFormat.UI);
            if (this.settings.get(PARAM_COPY_HEADER) != null) {
                this.copySettings.setCopyHeader(this.settings.getBoolean(PARAM_COPY_HEADER));
            }
            if (this.settings.get(PARAM_COPY_ROWS) != null) {
                this.copySettings.setCopyRowNumbers(this.settings.getBoolean(PARAM_COPY_ROWS));
            }
            if (this.settings.get(PARAM_QUOTE_CELLS) != null) {
                this.copySettings.setQuoteCells(this.settings.getBoolean(PARAM_QUOTE_CELLS));
            }
            if (this.settings.get(PARAM_FORCE_QUOTES) != null) {
                this.copySettings.setForceQuotes(this.settings.getBoolean(PARAM_FORCE_QUOTES));
            }
            if (this.settings.get(PARAM_FORMAT) != null) {
                this.copySettings.setFormat(DBDDisplayFormat.valueOf((String)this.settings.get(PARAM_FORMAT)));
            }
        }

        @Override
        protected void createControlsBefore(Composite group) {
            this.copyHeaderCheck = UIUtils.createCheckbox(group, "Copy header", null, this.copySettings.isCopyHeader(), 2);
            this.copyRowsCheck = UIUtils.createCheckbox(group, "Copy row numbers", null, this.copySettings.isCopyRowNumbers(), 2);
            this.quoteCellsCheck = UIUtils.createCheckbox(group, "Quote cell values", "Place cell value in quotes if it contains column or row delimiter", this.copySettings.isQuoteCells(), 2);
            this.forceQuoteCheck = UIUtils.createCheckbox(group, "Always quote values", "Place all cell values in quotes", this.copySettings.isForceQuotes(), 2);
            this.formatSelector = new ValueFormatSelector(group);
            this.formatSelector.select(this.copySettings.getFormat());
        }

        @Override
        protected void okPressed() {
            this.copySettings.setCopyHeader(this.copyHeaderCheck.getSelection());
            this.copySettings.setCopyRowNumbers(this.copyRowsCheck.getSelection());
            this.copySettings.setQuoteCells(this.quoteCellsCheck.getSelection());
            this.copySettings.setForceQuotes(this.forceQuoteCheck.getSelection());
            this.copySettings.setFormat(this.formatSelector.getSelection());
            this.settings.put(PARAM_COPY_HEADER, this.copySettings.isCopyHeader());
            this.settings.put(PARAM_COPY_ROWS, this.copySettings.isCopyRowNumbers());
            this.settings.put(PARAM_QUOTE_CELLS, this.copySettings.isQuoteCells());
            this.settings.put(PARAM_FORCE_QUOTES, this.copySettings.isForceQuotes());
            this.settings.put(PARAM_FORMAT, this.copySettings.getFormat().name());
            super.okPressed();
        }
    }

    public static class CopyConfigDialog
    extends Dialog {
        static final String PARAM_COL_DELIMITER = "delimiter";
        static final String PARAM_ROW_DELIMITER = "rowDelimiter";
        static final String PARAM_QUOTE_STRING = "quoteString";
        protected final IDialogSettings settings;
        private Combo colDelimCombo;
        private Combo rowDelimCombo;
        private Combo quoteStringCombo;
        protected ResultSetCopySettings copySettings;

        protected CopyConfigDialog(Shell shell, String dialogId) {
            super(shell);
            this.settings = UIUtils.getDialogSettings(dialogId);
            this.copySettings = new ResultSetCopySettings();
            this.copySettings.setColumnDelimiter("\t");
            this.copySettings.setRowDelimiter("\n");
            this.copySettings.setQuoteString("\"");
            if (this.settings.get(PARAM_COL_DELIMITER) != null) {
                this.copySettings.setColumnDelimiter(this.settings.get(PARAM_COL_DELIMITER));
            }
            if (this.settings.get(PARAM_ROW_DELIMITER) != null) {
                this.copySettings.setRowDelimiter(this.settings.get(PARAM_ROW_DELIMITER));
            }
            if (this.settings.get(PARAM_QUOTE_STRING) != null) {
                this.copySettings.setQuoteString(this.settings.get(PARAM_QUOTE_STRING));
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Options");
        }

        protected Control createDialogArea(Composite parent) {
            Composite group = (Composite)super.createDialogArea(parent);
            ((GridLayout)group.getLayout()).numColumns = 2;
            this.createControlsBefore(group);
            this.colDelimCombo = UIUtils.createDelimiterCombo(group, "Column Delimiter", new String[]{"\t", ";", ","}, this.copySettings.getColumnDelimiter(), false);
            this.rowDelimCombo = UIUtils.createDelimiterCombo(group, "Row Delimiter", new String[]{"\n", "|", "^"}, this.copySettings.getRowDelimiter(), false);
            this.quoteStringCombo = UIUtils.createDelimiterCombo(group, "Quote Character", new String[]{"\"", "'"}, this.copySettings.getQuoteString(), false);
            this.createControlsAfter(group);
            return group;
        }

        protected void createControlsAfter(Composite group) {
        }

        protected void createControlsBefore(Composite group) {
        }

        protected void okPressed() {
            this.copySettings.setColumnDelimiter(CommonUtils.unescapeDisplayString((String)this.colDelimCombo.getText()));
            this.copySettings.setRowDelimiter(CommonUtils.unescapeDisplayString((String)this.rowDelimCombo.getText()));
            this.copySettings.setQuoteString(CommonUtils.unescapeDisplayString((String)this.quoteStringCombo.getText()));
            this.settings.put(PARAM_COL_DELIMITER, this.copySettings.getColumnDelimiter());
            this.settings.put(PARAM_ROW_DELIMITER, this.copySettings.getRowDelimiter());
            this.settings.put(PARAM_QUOTE_STRING, this.copySettings.getQuoteString());
            super.okPressed();
        }
    }
}

