/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySpecialHandler;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.sql.ViewSQLDialog;
import org.jkiss.dbeaver.ui.editors.MultiPageAbstractEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetCommandHandler
extends AbstractHandler {
    public static final String CMD_TOGGLE_PANELS = "org.jkiss.dbeaver.core.resultset.grid.togglePreview";
    public static final String CMD_TOGGLE_MODE = "org.jkiss.dbeaver.core.resultset.toggleMode";
    public static final String CMD_FOCUS_FILTER = "org.jkiss.dbeaver.core.resultset.focus.filter";
    public static final String CMD_SWITCH_PRESENTATION = "org.jkiss.dbeaver.core.resultset.switchPresentation";
    public static final String CMD_ROW_FIRST = "org.jkiss.dbeaver.core.resultset.row.first";
    public static final String CMD_ROW_PREVIOUS = "org.jkiss.dbeaver.core.resultset.row.previous";
    public static final String CMD_ROW_NEXT = "org.jkiss.dbeaver.core.resultset.row.next";
    public static final String CMD_ROW_LAST = "org.jkiss.dbeaver.core.resultset.row.last";
    public static final String CMD_FETCH_PAGE = "org.jkiss.dbeaver.core.resultset.fetch.page";
    public static final String CMD_FETCH_ALL = "org.jkiss.dbeaver.core.resultset.fetch.all";
    public static final String CMD_COUNT = "org.jkiss.dbeaver.core.resultset.count";
    public static final String CMD_ROW_EDIT = "org.jkiss.dbeaver.core.resultset.row.edit";
    public static final String CMD_ROW_EDIT_INLINE = "org.jkiss.dbeaver.core.resultset.row.edit.inline";
    public static final String CMD_ROW_ADD = "org.jkiss.dbeaver.core.resultset.row.add";
    public static final String CMD_ROW_COPY = "org.jkiss.dbeaver.core.resultset.row.copy";
    public static final String CMD_ROW_DELETE = "org.jkiss.dbeaver.core.resultset.row.delete";
    public static final String CMD_CELL_SET_NULL = "org.jkiss.dbeaver.core.resultset.cell.setNull";
    public static final String CMD_CELL_RESET = "org.jkiss.dbeaver.core.resultset.cell.reset";
    public static final String CMD_APPLY_CHANGES = "org.jkiss.dbeaver.core.resultset.applyChanges";
    public static final String CMD_REJECT_CHANGES = "org.jkiss.dbeaver.core.resultset.rejectChanges";
    public static final String CMD_GENERATE_SCRIPT = "org.jkiss.dbeaver.core.resultset.generateScript";
    public static final String CMD_NAVIGATE_LINK = "org.jkiss.dbeaver.core.resultset.navigateLink";
    public static final String CMD_FILTER_MENU = "org.jkiss.dbeaver.core.resultset.filterMenu";
    public static final String CMD_FILTER_MENU_DISTINCT = "org.jkiss.dbeaver.core.resultset.filterMenu.distinct";
    public static final String CMD_REFERENCES_MENU = "org.jkiss.dbeaver.core.resultset.referencesMenu";
    public static final String CMD_COPY_COLUMN_NAMES = "org.jkiss.dbeaver.core.resultset.grid.copyColumnNames";
    public static final String CMD_COPY_ROW_NAMES = "org.jkiss.dbeaver.core.resultset.grid.copyRowNames";
    public static final String CMD_EXPORT = "org.jkiss.dbeaver.core.resultset.export";
    public static final String CMD_ZOOM_IN = "org.eclipse.ui.edit.text.zoomIn";
    public static final String CMD_ZOOM_OUT = "org.eclipse.ui.edit.text.zoomOut";
    public static final String CMD_TOGGLE_ORDER = "org.jkiss.dbeaver.core.resultset.toggleOrder";

    public static IResultSetController getActiveResultSet(IWorkbenchPart activePart) {
        if (activePart instanceof IResultSetContainer) {
            return ((IResultSetContainer)activePart).getResultSetController();
        }
        if (activePart instanceof MultiPageAbstractEditor) {
            return ResultSetCommandHandler.getActiveResultSet((IWorkbenchPart)((MultiPageAbstractEditor)activePart).getActiveEditor());
        }
        if (activePart != null) {
            return (IResultSetController)activePart.getAdapter(ResultSetViewer.class);
        }
        return null;
    }

    @Nullable
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final ResultSetViewer rsv = (ResultSetViewer)ResultSetCommandHandler.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (rsv == null) {
            return null;
        }
        String actionId = event.getCommand().getId();
        IResultSetPresentation presentation = rsv.getActivePresentation();
        switch (actionId) {
            case "org.eclipse.ui.file.refresh": {
                rsv.refreshData(null);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.toggleMode": {
                rsv.toggleMode();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.togglePreview": {
                rsv.showPanels(!rsv.isPanelsVisible());
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.focus.filter": {
                rsv.switchFilterFocus();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.switchPresentation": {
                rsv.switchPresentation();
                break;
            }
            case "org.eclipse.ui.edit.text.goto.wordPrevious": 
            case "org.jkiss.dbeaver.core.resultset.row.previous": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.PREVIOUS);
                break;
            }
            case "org.eclipse.ui.edit.text.goto.wordNext": 
            case "org.jkiss.dbeaver.core.resultset.row.next": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.NEXT);
                break;
            }
            case "org.eclipse.ui.edit.text.select.wordPrevious": 
            case "org.jkiss.dbeaver.core.resultset.row.first": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.FIRST);
                break;
            }
            case "org.eclipse.ui.edit.text.select.wordNext": 
            case "org.jkiss.dbeaver.core.resultset.row.last": {
                presentation.scrollToRow(IResultSetPresentation.RowPosition.LAST);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.fetch.page": {
                rsv.readNextSegment();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.fetch.all": {
                rsv.readAllData();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.edit": {
                if (!(presentation instanceof IResultSetEditor)) break;
                ((IResultSetEditor)((Object)presentation)).openValueEditor(false);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.edit.inline": {
                if (!(presentation instanceof IResultSetEditor)) break;
                ((IResultSetEditor)((Object)presentation)).openValueEditor(true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.add": 
            case "org.jkiss.dbeaver.core.resultset.row.copy": {
                boolean copy = actionId.equals(CMD_ROW_COPY);
                boolean shiftPressed = event.getTrigger() instanceof Event && (((Event)event.getTrigger()).stateMask & 0x20000) == 131072;
                boolean insertAfter = rsv.getPreferenceStore().getBoolean("resultset.edit.new.row.after");
                if (shiftPressed) {
                    insertAfter = !insertAfter;
                }
                rsv.addNewRow(copy, insertAfter, true);
                if (!insertAfter) break;
                presentation.scrollToRow(IResultSetPresentation.RowPosition.NEXT);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.row.delete": 
            case "org.eclipse.ui.edit.delete": {
                rsv.deleteSelectedRows();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.cell.setNull": 
            case "org.jkiss.dbeaver.core.resultset.cell.reset": {
                IResultSetSelection selection = rsv.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int insertAfter = 0;
                while (insertAfter < n) {
                    Object cell = objectArray[insertAfter];
                    DBDAttributeBinding attr = selection.getElementAttribute(cell);
                    ResultSetRow row = selection.getElementRow(cell);
                    if (row != null && attr != null) {
                        ResultSetValueController valueController = new ResultSetValueController(rsv, attr, row, IValueController.EditType.NONE, null);
                        if (actionId.equals(CMD_CELL_SET_NULL)) {
                            valueController.updateValue(BaseValueManager.makeNullValue(valueController), false);
                        } else {
                            rsv.getModel().resetCellValue(attr, row);
                        }
                    }
                    ++insertAfter;
                }
                rsv.redrawData(false, false);
                rsv.updatePanelsContent(false);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.applyChanges": {
                rsv.applyChanges(null);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.rejectChanges": {
                rsv.rejectChanges();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.generateScript": {
                try {
                    final ArrayList sqlScript = new ArrayList();
                    try {
                        DBeaverUI.runInProgressService(new DBRRunnableWithProgress(){

                            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                List<DBEPersistAction> script = rsv.generateChangesScript(monitor);
                                if (script != null) {
                                    sqlScript.addAll(script);
                                }
                            }
                        });
                    }
                    catch (InterruptedException cell) {
                        // empty catch block
                    }
                    if (sqlScript.isEmpty()) break;
                    String scriptText = SQLUtils.generateScript((DBPDataSource)(rsv.getDataContainer() == null ? null : rsv.getDataContainer().getDataSource()), (DBEPersistAction[])sqlScript.toArray(new DBEPersistAction[sqlScript.size()]), (boolean)false);
                    scriptText = String.valueOf(SQLUtils.generateCommentLine((DBPDataSource)(rsv.getExecutionContext() == null ? null : rsv.getExecutionContext().getDataSource()), (String)"Actual parameter values may differ, what you see is a default string representation of values")) + scriptText;
                    ViewSQLDialog dialog = new ViewSQLDialog(HandlerUtil.getActivePart((ExecutionEvent)event).getSite(), rsv.getExecutionContext(), CoreMessages.editors_entity_dialog_preview_title, (DBPImage)UIIcon.SQL_PREVIEW, scriptText);
                    dialog.open();
                }
                catch (InvocationTargetException e) {
                    DBUserInterface.getInstance().showError("Script generation", "Can't generate changes script", e.getTargetException());
                }
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.copyColumnNames": {
                ResultSetCopySpecialHandler.CopyConfigDialog configDialog = new ResultSetCopySpecialHandler.CopyConfigDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "CopyGridNamesOptionsDialog");
                if (configDialog.open() != 0) {
                    return null;
                }
                StringBuilder buffer = new StringBuilder();
                IResultSetSelection selection = rsv.getSelection();
                Collection<DBDAttributeBinding> attrs = selection.isEmpty() ? rsv.getModel().getVisibleAttributes() : selection.getSelectedAttributes();
                for (DBDAttributeBinding attr : attrs) {
                    String colName;
                    if (buffer.length() > 0) {
                        buffer.append(configDialog.copySettings.getColumnDelimiter());
                    }
                    if (CommonUtils.isEmpty((String)(colName = attr.getLabel()))) {
                        colName = attr.getName();
                    }
                    buffer.append(colName);
                }
                ResultSetUtils.copyToClipboard(buffer.toString());
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.copyRowNames": {
                ResultSetCopySpecialHandler.CopyConfigDialog configDialog = new ResultSetCopySpecialHandler.CopyConfigDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "CopyGridNamesOptionsDialog");
                if (configDialog.open() != 0) {
                    return null;
                }
                StringBuilder buffer = new StringBuilder();
                IResultSetSelection selection = rsv.getSelection();
                for (ResultSetRow row : selection.getSelectedRows()) {
                    if (buffer.length() > 0) {
                        buffer.append(configDialog.copySettings.getRowDelimiter());
                    }
                    buffer.append(row.getVisualNumber() + 1);
                }
                ResultSetUtils.copyToClipboard(buffer.toString());
                break;
            }
            case "org.eclipse.ui.edit.copy": {
                ResultSetUtils.copyToClipboard(presentation.copySelectionToString(new ResultSetCopySettings(false, false, false, true, false, null, null, null, DBDDisplayFormat.EDIT)));
                break;
            }
            case "org.jkiss.dbeaver.core.edit.paste.special": 
            case "org.eclipse.ui.edit.paste": {
                if (!(presentation instanceof IResultSetEditor)) break;
                ((IResultSetEditor)((Object)presentation)).pasteFromClipboard(actionId.equals("org.jkiss.dbeaver.core.edit.paste.special"));
                break;
            }
            case "org.eclipse.ui.edit.cut": {
                ResultSetUtils.copyToClipboard(presentation.copySelectionToString(new ResultSetCopySettings(false, false, true, true, false, null, null, null, DBDDisplayFormat.EDIT)));
                break;
            }
            case "org.eclipse.ui.file.print": {
                presentation.printResultSet();
                break;
            }
            case "org.eclipse.ui.edit.text.smartEnter": {
                if (!(presentation instanceof IResultSetEditor)) break;
                ((IResultSetEditor)((Object)presentation)).openValueEditor(false);
                break;
            }
            case "org.eclipse.ui.edit.findReplace": {
                FindReplaceAction action = new FindReplaceAction(DBeaverActivator.getCoreResourceBundle(), "Editor.FindReplace.", HandlerUtil.getActiveShell((ExecutionEvent)event), rsv.getAdapter(IFindReplaceTarget.class));
                action.run();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.navigateLink": {
                final ResultSetRow row = rsv.getCurrentRow();
                final DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                if (row == null || attr == null) break;
                new AbstractJob("Navigate association"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        try {
                            rsv.navigateAssociation(monitor, attr, row, false);
                        }
                        catch (DBException e) {
                            return GeneralUtils.makeExceptionStatus((Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.count": {
                rsv.updateRowCount();
                break;
            }
            case "org.eclipse.ui.navigate.backwardHistory": {
                int hp = rsv.getHistoryPosition();
                if (hp <= 0) break;
                rsv.navigateHistory(hp - 1);
                break;
            }
            case "org.eclipse.ui.navigate.forwardHistory": {
                int hp = rsv.getHistoryPosition();
                if (hp >= rsv.getHistorySize() - 1) break;
                rsv.navigateHistory(hp + 1);
                break;
            }
            case "org.eclipse.ui.edit.text.goto.line": {
                ResultSetRow currentRow = rsv.getCurrentRow();
                final int rowCount = rsv.getModel().getRowCount();
                if (rowCount <= 0) break;
                GotoLineDialog d = new GotoLineDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Go to Row", "Enter row number (1.." + rowCount + ")", String.valueOf(currentRow == null ? 1 : currentRow.getVisualNumber() + 1), new IInputValidator(){

                    public String isValid(String input) {
                        try {
                            int i = Integer.parseInt(input);
                            if (i <= 0 || rowCount < i) {
                                return "Row number is out of range";
                            }
                        }
                        catch (NumberFormatException x) {
                            return "Not a number";
                        }
                        return null;
                    }
                });
                if (d.open() != 0) break;
                int line = Integer.parseInt(d.getValue());
                rsv.setCurrentRow(rsv.getModel().getRow(line - 1));
                rsv.getActivePresentation().scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.filterMenu": {
                rsv.showFiltersMenu();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.filterMenu.distinct": {
                DBDAttributeBinding curAttribute = rsv.getActivePresentation().getCurrentAttribute();
                if (curAttribute == null) break;
                rsv.showFiltersDistinctMenu(curAttribute, true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.referencesMenu": {
                rsv.showReferencesMenu();
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.export": {
                ArrayList<Long> selectedRows = new ArrayList<Long>();
                for (ResultSetRow selectedRow : rsv.getSelection().getSelectedRows()) {
                    selectedRows.add(Long.valueOf(selectedRow.getRowNumber()));
                }
                ArrayList<String> selectedAttributes = new ArrayList<String>();
                for (DBDAttributeBinding attributeBinding : rsv.getSelection().getSelectedAttributes()) {
                    selectedAttributes.add(attributeBinding.getName());
                }
                ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
                options.setSelectedRows(selectedRows);
                options.setSelectedColumns(selectedAttributes);
                ResultSetDataContainer dataContainer = new ResultSetDataContainer(rsv.getDataContainer(), rsv.getModel(), options);
                ActiveWizardDialog dialog = new ActiveWizardDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), (IWizard)new DataTransferWizard(new IDataTransferProducer[]{new DatabaseTransferProducer(dataContainer, rsv.getModel().getDataFilter())}, null), rsv.getSelection());
                dialog.open();
                break;
            }
            case "org.eclipse.ui.edit.text.zoomOut": 
            case "org.eclipse.ui.edit.text.zoomIn": {
                FontData[] fondData;
                FontRegistry fontRegistry = rsv.getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
                Font font = fontRegistry.get("org.jkiss.dbeaver.sql.resultset.font");
                if (font == null || (fondData = font.getFontData()) == null) break;
                int zoomFactor = actionId.equals(CMD_ZOOM_IN) ? 1 : -1;
                FontDescriptor fd = this.createFontDescriptor(fondData, zoomFactor);
                fontRegistry.put("org.jkiss.dbeaver.sql.resultset.font", fd.getFontData());
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.toggleOrder": {
                DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                if (attr == null) break;
                rsv.toggleSortOrder(attr, false, false);
            }
        }
        return null;
    }

    private FontDescriptor createFontDescriptor(FontData[] initialFontData, int fFontSizeOffset) {
        int destFontSize = initialFontData[0].getHeight() + fFontSizeOffset;
        if (destFontSize <= 0) {
            return FontDescriptor.createFrom((FontData[])initialFontData);
        }
        return FontDescriptor.createFrom((FontData[])initialFontData).setHeight(destFontSize);
    }

    static class GotoLineDialog
    extends InputDialog {
        private static final String DIALOG_ID = "ResultSetCommandHandler.GotoLineDialog";

        public GotoLineDialog(Shell parent, String title, String message, String initialValue, IInputValidator validator) {
            super(parent, title, message, initialValue, validator);
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return UIUtils.getDialogSettings(DIALOG_ID);
        }
    }
}

