/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.reflect.Array;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ILabelProviderEx;
import org.jkiss.dbeaver.ui.ILazyLabelProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnRegistry;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ViewerColumnController {
    private static final Log log = Log.getLog(ViewerColumnController.class);
    private static final String DATA_KEY = ViewerColumnController.class.getSimpleName();
    private final String configId;
    private final ColumnViewer viewer;
    private final List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
    private boolean clickOnHeader;
    private boolean isPacking;
    private boolean isInitializing;
    private transient Listener menuListener;

    public static ViewerColumnController getFromControl(Control control) {
        return (ViewerColumnController)control.getData(DATA_KEY);
    }

    public ViewerColumnController(String id, ColumnViewer viewer) {
        this.configId = id;
        this.viewer = viewer;
        final Control control = this.viewer.getControl();
        control.setData(DATA_KEY, (Object)this);
        if (control instanceof Tree || control instanceof Table) {
            this.menuListener = new Listener(){

                public void handleEvent(Event event) {
                    Point pt = control.getDisplay().map(null, control, new Point(event.x, event.y));
                    Rectangle clientArea = ((Composite)control).getClientArea();
                    if (RuntimeUtils.isPlatformMacOS()) {
                        ViewerColumnController.this.clickOnHeader = pt.y < 0;
                    } else if (control instanceof Tree) {
                        ViewerColumnController.this.clickOnHeader = clientArea.y <= pt.y && pt.y < clientArea.y + ((Tree)control).getHeaderHeight();
                    } else {
                        ViewerColumnController.this.clickOnHeader = clientArea.y <= pt.y && pt.y < clientArea.y + ((Table)control).getHeaderHeight();
                    }
                }
            };
            control.addListener(35, this.menuListener);
        }
    }

    public void dispose() {
        this.clearColumns();
        Control control = this.viewer.getControl();
        if (!control.isDisposed() && this.menuListener != null) {
            control.removeListener(35, this.menuListener);
            this.menuListener = null;
        }
    }

    public boolean isClickOnHeader() {
        return this.clickOnHeader;
    }

    public void fillConfigMenu(IMenuManager menuManager) {
        menuManager.add((IAction)new Action("Configure columns ..."){

            public void run() {
                ViewerColumnController.this.configureColumns();
            }
        });
    }

    public void addColumn(String name, String description, int style, boolean defaultVisible, boolean required, CellLabelProvider labelProvider) {
        this.addColumn(name, description, style, defaultVisible, required, false, null, labelProvider, null);
    }

    public void addColumn(String name, String description, int style, boolean defaultVisible, boolean required, boolean isNumeric, Object userData, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        this.columns.add(new ColumnInfo(name, description, style, defaultVisible, required, isNumeric, userData, labelProvider, editingSupport, this.columns.size()));
    }

    private void clearColumns() {
        for (ColumnInfo columnInfo : this.columns) {
            if (columnInfo.column == null) continue;
            columnInfo.column.dispose();
            columnInfo.column = null;
        }
        this.columns.clear();
    }

    public void createColumns() {
        this.createColumns(true);
    }

    public void createColumns(boolean pack) {
        try {
            this.readColumnsConfiguration();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load configuration for '" + this.configId + "'"), (Throwable)e);
        }
        this.recreateColumns(pack);
    }

    private void recreateColumns(boolean pack) {
        final Control control = this.viewer.getControl();
        control.setRedraw(false);
        this.isInitializing = true;
        try {
            boolean needRefresh = false;
            for (ColumnInfo columnInfo : this.columns) {
                if (columnInfo.column == null) continue;
                columnInfo.column.dispose();
                columnInfo.column = null;
                needRefresh = true;
            }
            this.createVisibleColumns();
            if (pack && !this.isAllSized()) {
                this.repackColumns();
                control.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        control.removeControlListener((ControlListener)this);
                        ViewerColumnController.this.repackColumns();
                    }
                });
            }
            if (needRefresh) {
                this.viewer.refresh();
                for (ColumnInfo columnInfo : this.getVisibleColumns()) {
                    if (columnInfo.column instanceof TreeColumn) {
                        ((TreeColumn)columnInfo.column).pack();
                        continue;
                    }
                    ((TableColumn)columnInfo.column).pack();
                }
            }
        }
        finally {
            control.setRedraw(true);
            this.isInitializing = false;
        }
    }

    private boolean isAllSized() {
        for (ColumnInfo columnInfo : this.columns) {
            if (!columnInfo.visible || columnInfo.width > 0) continue;
            return false;
        }
        return true;
    }

    public void repackColumns() {
        if (this.isAllSized()) {
            return;
        }
        this.isPacking = true;
        try {
            if (this.viewer instanceof TreeViewer) {
                float[] ratios = null;
                if (((TreeViewer)this.viewer).getTree().getColumnCount() == 2) {
                    ratios = new float[]{0.6f, 0.4f};
                }
                UIUtils.packColumns(((TreeViewer)this.viewer).getTree(), false, ratios);
            } else if (this.viewer instanceof TableViewer) {
                UIUtils.packColumns(((TableViewer)this.viewer).getTable());
            }
        }
        finally {
            this.isPacking = false;
        }
    }

    public void sortByColumn(int index, int direction) {
        ColumnInfo columnInfo = this.columns.get(index);
        columnInfo.sortListener.sortViewer(columnInfo.column, direction);
    }

    private void createVisibleColumns() {
        boolean hasLazyColumns = false;
        List<ColumnInfo> visibleColumns = this.getVisibleColumns();
        int i = 0;
        while (i < visibleColumns.size()) {
            block12: {
                TreeColumn colItem;
                TreeViewerColumn viewerColumn;
                ColumnInfo columnInfo;
                block11: {
                    TreeColumn column;
                    TreeViewerColumn item;
                    block10: {
                        columnInfo = visibleColumns.get(i);
                        columnInfo.order = i;
                        if (!(this.viewer instanceof TreeViewer)) break block10;
                        viewerColumn = item = new TreeViewerColumn((TreeViewer)this.viewer, columnInfo.style);
                        colItem = column = item.getColumn();
                        column.setText(columnInfo.name);
                        column.setMoveable(true);
                        column.setWidth(columnInfo.width);
                        if (!CommonUtils.isEmpty((String)columnInfo.description)) {
                            column.setToolTipText(columnInfo.description);
                        }
                        column.addControlListener((ControlListener)new ControlAdapter(){

                            public void controlResized(ControlEvent e) {
                                columnInfo.width = column.getWidth();
                                ViewerColumnController.this.saveColumnConfig();
                            }

                            public void controlMoved(ControlEvent e) {
                                if (!ViewerColumnController.this.isInitializing && e.getSource() instanceof TreeColumn) {
                                    ViewerColumnController.this.updateColumnOrder((Item)column, column.getParent().getColumnOrder());
                                }
                            }
                        });
                        columnInfo.column = column;
                        break block11;
                    }
                    if (!(this.viewer instanceof TableViewer)) break block12;
                    viewerColumn = item = new TableViewerColumn((TableViewer)this.viewer, columnInfo.style);
                    colItem = column = item.getColumn();
                    column.setText(columnInfo.name);
                    column.setMoveable(true);
                    column.setWidth(columnInfo.width);
                    if (!CommonUtils.isEmpty((String)columnInfo.description)) {
                        column.setToolTipText(columnInfo.description);
                    }
                    column.addControlListener((ControlListener)new ControlAdapter((TableColumn)column){
                        private final /* synthetic */ TableColumn val$column;
                        {
                            this.val$column = tableColumn;
                        }

                        public void controlResized(ControlEvent e) {
                            columnInfo.width = this.val$column.getWidth();
                            ViewerColumnController.this.saveColumnConfig();
                        }

                        public void controlMoved(ControlEvent e) {
                            if (!ViewerColumnController.this.isInitializing && e.getSource() instanceof TableColumn) {
                                ViewerColumnController.this.updateColumnOrder((Item)this.val$column, this.val$column.getParent().getColumnOrder());
                            }
                        }
                    });
                    columnInfo.column = column;
                }
                viewerColumn.setLabelProvider(columnInfo.labelProvider);
                viewerColumn.setEditingSupport(columnInfo.editingSupport);
                colItem.setData((Object)columnInfo);
                if (columnInfo.labelProvider instanceof ILazyLabelProvider) {
                    hasLazyColumns = true;
                } else if (columnInfo.labelProvider instanceof ILabelProvider) {
                    columnInfo.sortListener = new SortListener(columnInfo);
                    columnInfo.column.addListener(13, (Listener)columnInfo.sortListener);
                }
            }
            ++i;
        }
        if (hasLazyColumns) {
            this.viewer.getControl().addListener(42, new Listener(){

                public void handleEvent(Event event) {
                    if (ViewerColumnController.this.viewer instanceof TreeViewer) {
                        String lazyText;
                        TreeColumn column = ((TreeViewer)ViewerColumnController.this.viewer).getTree().getColumn(event.index);
                        if (((ColumnInfo)column.getData()).labelProvider instanceof ILazyLabelProvider && CommonUtils.isEmpty((String)((TreeItem)event.item).getText(event.index)) && !CommonUtils.isEmpty((String)(lazyText = ((ILazyLabelProvider)((ColumnInfo)column.getData()).labelProvider).getLazyText(event.item.getData())))) {
                            ((TreeItem)event.item).setText(event.index, lazyText);
                        }
                    } else {
                        String lazyText;
                        TableColumn column = ((TableViewer)ViewerColumnController.this.viewer).getTable().getColumn(event.index);
                        if (((ColumnInfo)column.getData()).labelProvider instanceof ILazyLabelProvider && CommonUtils.isEmpty((String)((TableItem)event.item).getText(event.index)) && !CommonUtils.isEmpty((String)(lazyText = ((ILazyLabelProvider)((ColumnInfo)column.getData()).labelProvider).getLazyText(event.item.getData())))) {
                            ((TableItem)event.item).setText(event.index, lazyText);
                        }
                    }
                }
            });
        }
    }

    private List<ColumnInfo> getVisibleColumns() {
        ArrayList<ColumnInfo> visibleList = new ArrayList<ColumnInfo>();
        for (ColumnInfo column : this.columns) {
            if (!column.visible) continue;
            visibleList.add(column);
        }
        Collections.sort(visibleList, new ColumnInfoComparator());
        return visibleList;
    }

    private void readColumnsConfiguration() {
        Collection<ViewerColumnRegistry.ColumnState> savedConfig = ViewerColumnRegistry.getInstance().getSavedConfig(this.configId);
        if (savedConfig == null) {
            return;
        }
        block0: for (ColumnInfo columnInfo : this.columns) {
            for (ViewerColumnRegistry.ColumnState savedState : savedConfig) {
                if (!columnInfo.name.equals(savedState.name)) continue;
                columnInfo.visible = savedState.visible;
                columnInfo.order = savedState.order;
                columnInfo.width = savedState.width;
                continue block0;
            }
        }
    }

    public Object getColumnData(int columnIndex) {
        Control control = this.viewer.getControl();
        ColumnInfo columnInfo = control instanceof Tree ? (ColumnInfo)((Tree)control).getColumn(columnIndex).getData() : (ColumnInfo)((Table)control).getColumn(columnIndex).getData();
        return columnInfo.userData;
    }

    public <T> T[] getColumnsData(Class<T> type) {
        Object[] newArray = (Object[])Array.newInstance(type, this.columns.size());
        int i = 0;
        while (i < this.columns.size()) {
            newArray[i] = type.cast(this.columns.get((int)i).userData);
            ++i;
        }
        return newArray;
    }

    public void configureColumns() {
        ConfigDialog configDialog = new ConfigDialog();
        if (configDialog.open() != 0) {
            return;
        }
        this.saveColumnConfig();
    }

    private void updateColumnOrder(Item column, int[] order) {
        if (this.isPacking) {
            return;
        }
        ColumnInfo columnInfo = (ColumnInfo)column.getData();
        boolean updated = false;
        int i = 0;
        while (i < order.length) {
            if (order[i] == columnInfo.order) {
                columnInfo.order = i;
                updated = true;
                break;
            }
            ++i;
        }
        if (updated) {
            this.saveColumnConfig();
        }
    }

    private void saveColumnConfig() {
        ViewerColumnRegistry.getInstance().updateConfig(this.configId, this.columns);
    }

    public int getColumnsCount() {
        Control control = this.viewer.getControl();
        return control instanceof Tree ? ((Tree)control).getColumnCount() : ((Table)control).getColumnCount();
    }

    private static class ColumnInfo
    extends ViewerColumnRegistry.ColumnState {
        final String description;
        final int style;
        final boolean defaultVisible;
        final boolean required;
        final boolean numeric;
        final Object userData;
        final CellLabelProvider labelProvider;
        final EditingSupport editingSupport;
        Item column;
        SortListener sortListener;

        private ColumnInfo(String name, String description, int style, boolean defaultVisible, boolean required, boolean numeric, Object userData, CellLabelProvider labelProvider, EditingSupport editingSupport, int order) {
            this.name = name;
            this.description = description;
            this.style = style;
            this.defaultVisible = defaultVisible;
            this.required = required;
            this.numeric = numeric;
            this.userData = userData;
            this.visible = defaultVisible;
            this.labelProvider = labelProvider;
            this.editingSupport = editingSupport;
            this.order = order;
        }
    }

    private static class ColumnInfoComparator
    implements Comparator<ColumnInfo> {
        private ColumnInfoComparator() {
        }

        @Override
        public int compare(ColumnInfo o1, ColumnInfo o2) {
            return o1.order - o2.order;
        }
    }

    private class ConfigDialog
    extends BaseDialog {
        private Table colTable;

        protected ConfigDialog() {
            super(ViewerColumnController.this.viewer.getControl().getShell(), "Configure columns", (DBPImage)UIIcon.CONFIGURATION);
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle & 0xFFFFFBFF);
        }

        @Override
        protected boolean isResizable() {
            return true;
        }

        @Override
        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            UIUtils.createControlLabel(composite, "Select columns you want to display");
            ArrayList orderedList = new ArrayList(ViewerColumnController.this.columns);
            Collections.sort(orderedList, new ColumnInfoComparator());
            this.colTable = new Table(composite, 2848);
            this.colTable.setLayoutData((Object)new GridData(1808));
            this.colTable.setLinesVisible(true);
            this.colTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32 && ((TableItem)event.item).getGrayed()) {
                        ((TableItem)event.item).setChecked(true);
                        event.doit = false;
                    }
                }
            });
            TableColumn nameColumn = new TableColumn(this.colTable, 16384);
            nameColumn.setText("Name");
            TableColumn descColumn = new TableColumn(this.colTable, 16384);
            descColumn.setText("Description");
            for (ColumnInfo columnInfo : orderedList) {
                TableItem colItem = new TableItem(this.colTable, 0);
                colItem.setData((Object)columnInfo);
                colItem.setText(0, columnInfo.name);
                if (!CommonUtils.isEmpty((String)columnInfo.description)) {
                    colItem.setText(1, columnInfo.description);
                }
                colItem.setChecked(columnInfo.visible);
                if (!columnInfo.required) continue;
                colItem.setGrayed(true);
            }
            nameColumn.pack();
            if (nameColumn.getWidth() > 300) {
                nameColumn.setWidth(300);
            }
            descColumn.pack();
            if (descColumn.getWidth() > 400) {
                descColumn.setWidth(400);
            }
            return parent;
        }

        protected void okPressed() {
            boolean recreateColumns = false;
            TableItem[] tableItemArray = this.colTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                ColumnInfo ci = (ColumnInfo)item.getData();
                if (item.getChecked() != ci.visible) {
                    ci.visible = item.getChecked();
                    recreateColumns = true;
                }
                ++n2;
            }
            if (recreateColumns) {
                ViewerColumnController.this.recreateColumns(true);
            }
            super.okPressed();
        }
    }

    private class SortListener
    implements Listener {
        ColumnInfo columnInfo;
        int sortDirection = 1024;
        Item prevColumn = null;

        public SortListener(ColumnInfo columnInfo) {
            this.columnInfo = columnInfo;
        }

        public void handleEvent(Event e) {
            Item column = (Item)e.widget;
            if (this.prevColumn == column) {
                this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
            }
            this.prevColumn = column;
            this.sortViewer(column, this.sortDirection);
        }

        private void sortViewer(Item column, final int sortDirection) {
            Collator collator = Collator.getInstance();
            if (ViewerColumnController.this.viewer instanceof TreeViewer) {
                ((TreeViewer)ViewerColumnController.this.viewer).getTree().setSortColumn((TreeColumn)column);
                ((TreeViewer)ViewerColumnController.this.viewer).getTree().setSortDirection(sortDirection);
            } else {
                ((TableViewer)ViewerColumnController.this.viewer).getTable().setSortColumn((TableColumn)column);
                ((TableViewer)ViewerColumnController.this.viewer).getTable().setSortDirection(sortDirection);
            }
            final ILabelProvider labelProvider = (ILabelProvider)this.columnInfo.labelProvider;
            final ILabelProviderEx exLabelProvider = labelProvider instanceof ILabelProviderEx ? (ILabelProviderEx)labelProvider : null;
            ViewerColumnController.this.viewer.setComparator(new ViewerComparator(collator){
                private final NumberFormat numberFormat;
                {
                    super($anonymous0);
                    this.numberFormat = NumberFormat.getInstance();
                }

                public int compare(Viewer v, Object e1, Object e2) {
                    int result;
                    block13: {
                        String value2;
                        String value1;
                        if (exLabelProvider != null) {
                            value1 = exLabelProvider.getText(e1, false);
                            value2 = exLabelProvider.getText(e2, false);
                        } else {
                            value1 = labelProvider.getText(e1);
                            value2 = labelProvider.getText(e2);
                        }
                        if (value1 == null && value2 == null) {
                            result = 0;
                        } else if (value1 == null) {
                            result = -1;
                        } else if (value2 == null) {
                            result = 1;
                        } else if (SortListener.this.columnInfo.numeric) {
                            try {
                                Number num1 = this.numberFormat.parse(value1);
                                Number num2 = this.numberFormat.parse(value2);
                                if (num1.getClass() == num2.getClass() && num1 instanceof Comparable) {
                                    result = ((Comparable)((Object)num1)).compareTo(num2);
                                    break block13;
                                }
                                result = 0;
                            }
                            catch (Exception e) {
                                result = value1.compareToIgnoreCase(value2);
                            }
                        } else {
                            result = value1.compareToIgnoreCase(value2);
                        }
                    }
                    return sortDirection == 1024 ? result : -result;
                }
            });
        }
    }
}

