/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.jkiss.dbeaver.Log;

public class StyledTextFindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Log log = Log.getLog(StyledTextFindReplaceTarget.class);
    private final StyledText text;
    private Pattern searchPattern;
    private Color scopeHighlightColor;
    private boolean replaceAll;

    public StyledTextFindReplaceTarget(StyledText text) {
        this.text = text;
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public Point getSelection() {
        Point selection = this.text.getSelection();
        selection.y -= selection.x;
        return selection;
    }

    public String getSelectionText() {
        return this.text.getSelectionText();
    }

    public boolean isEditable() {
        return this.text.getEditable();
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void beginSession() {
    }

    public void endSession() {
    }

    public IRegion getScope() {
        return null;
    }

    public void setScope(IRegion scope) {
    }

    public Point getLineSelection() {
        return this.getSelection();
    }

    public void setSelection(int offset, int length) {
        this.text.setSelection(offset, length);
    }

    public void setScopeHighlightColor(Color color) {
        this.scopeHighlightColor = color;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        int textLength;
        Pattern findPattern;
        this.searchPattern = null;
        if (regExSearch) {
            try {
                findPattern = Pattern.compile(findString, caseSensitive ? 0 : 2);
            }
            catch (PatternSyntaxException e) {
                log.warn((Object)("Bad regex pattern: " + findString));
                return -1;
            }
        } else {
            findPattern = Pattern.compile(Pattern.quote(findString), caseSensitive ? 0 : 2);
        }
        if (offset == -1) {
            offset = 0;
        }
        if ((textLength = this.text.getCharCount()) <= 0 || offset >= textLength) {
            return -1;
        }
        String searchIn = this.text.getText();
        Matcher matcher = findPattern.matcher(searchIn);
        if (matcher.find(searchForward ? offset : 0)) {
            this.text.setSelection(matcher.start(), matcher.end());
            return matcher.start();
        }
        return -1;
    }

    public void replaceSelection(String str, boolean regExReplace) {
    }
}

