/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLogBase;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ObjectCompilerLogViewer
extends DBCCompileLogBase {
    private Table infoTable;

    public ObjectCompilerLogViewer(Composite parent, boolean bordered) {
        this.infoTable = new Table(parent, 0x10302 | (bordered ? 2048 : 0));
        this.infoTable.setHeaderVisible(true);
        this.infoTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn(this.infoTable, 16384, "Message");
        UIUtils.createTableColumn(this.infoTable, 16384, "Line");
        UIUtils.createTableColumn(this.infoTable, 16384, "Pos");
        this.createContextMenu();
    }

    public void clearLog() {
        super.clearLog();
        this.infoTable.removeAll();
    }

    public void layoutLog() {
        DBeaverUI.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ObjectCompilerLogViewer.this.infoTable.isDisposed()) {
                    ObjectCompilerLogViewer.this.infoTable.getColumn(0).setWidth(((ObjectCompilerLogViewer)ObjectCompilerLogViewer.this).infoTable.getBounds().width - 110);
                    ObjectCompilerLogViewer.this.infoTable.getColumn(1).setWidth(50);
                    ObjectCompilerLogViewer.this.infoTable.getColumn(2).setWidth(50);
                }
            }
        });
    }

    protected void log(final int type, final Object message, final Throwable t) {
        super.log(type, message, t);
        DBeaverUI.syncExec(new Runnable(){

            @Override
            public void run() {
                String messageStr;
                if (ObjectCompilerLogViewer.this.infoTable == null || ObjectCompilerLogViewer.this.infoTable.isDisposed()) {
                    return;
                }
                int color = -1;
                switch (type) {
                    case 1: {
                        color = 10;
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        color = 8;
                        break;
                    }
                    case 5: 
                    case 6: {
                        color = 4;
                        break;
                    }
                }
                DBCCompileError error = null;
                if (message instanceof DBCCompileError) {
                    error = (DBCCompileError)message;
                    messageStr = error.getMessage();
                } else {
                    messageStr = CommonUtils.toString((Object)message);
                }
                StringTokenizer st = new StringTokenizer(messageStr, "\n");
                while (st.hasMoreTokens()) {
                    TableItem item = new TableItem(ObjectCompilerLogViewer.this.infoTable, 0);
                    item.setText(0, st.nextToken());
                    if (error != null && error.getLine() > 0) {
                        item.setText(1, String.valueOf(((DBCCompileError)message).getLine()));
                        item.setText(2, String.valueOf(((DBCCompileError)message).getPosition()));
                    }
                    if (color != -1) {
                        item.setForeground(ObjectCompilerLogViewer.this.infoTable.getDisplay().getSystemColor(color));
                    }
                    ObjectCompilerLogViewer.this.infoTable.showItem(item);
                }
                if (t != null) {
                    String prevMessage = null;
                    Throwable ex = t;
                    while (error != null) {
                        String errorMessage = ex.getMessage();
                        if (errorMessage != null && !errorMessage.equals(prevMessage)) {
                            prevMessage = errorMessage;
                            TableItem stackItem = new TableItem(ObjectCompilerLogViewer.this.infoTable, 0);
                            stackItem.setText(errorMessage);
                            stackItem.setForeground(ObjectCompilerLogViewer.this.infoTable.getDisplay().getSystemColor(3));
                            ObjectCompilerLogViewer.this.infoTable.showItem(stackItem);
                        }
                        ex = ex.getCause();
                    }
                }
            }
        });
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.infoTable);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action copyAction = new Action(WorkbenchMessages.Workbench_copy){

                    public void run() {
                        ObjectCompilerLogViewer.this.copySelectionToClipboard();
                    }
                };
                copyAction.setEnabled(ObjectCompilerLogViewer.this.infoTable.getSelectionCount() > 0);
                copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
                Action selectAllAction = new Action(WorkbenchMessages.Workbench_selectAll){

                    public void run() {
                        ObjectCompilerLogViewer.this.infoTable.selectAll();
                    }
                };
                selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
                Action clearLogAction = new Action(WorkbenchMessages.Workbench_revert){

                    public void run() {
                        ObjectCompilerLogViewer.this.infoTable.removeAll();
                    }
                };
                manager.add((IAction)copyAction);
                manager.add((IAction)selectAllAction);
                manager.add((IAction)clearLogAction);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.infoTable.setMenu(menu);
    }

    public void copySelectionToClipboard() {
        Object[] selection = this.infoTable.getSelection();
        if (ArrayUtils.isEmpty((Object[])selection)) {
            return;
        }
        StringBuilder tdt = new StringBuilder();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            tdt.append(item.getText()).append(GeneralUtils.getDefaultLineSeparator());
            ++n2;
        }
        UIUtils.setClipboardContents(this.infoTable.getDisplay(), (Transfer)TextTransfer.getInstance(), tdt.toString());
    }
}

