/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ui.ImageUtils;
import org.jkiss.utils.CommonUtils;

public class CustomCheckboxCellEditor
extends CellEditor {
    private Label checkBox;
    private boolean checked;

    public CustomCheckboxCellEditor(Composite parent) {
        this(parent, 0);
    }

    public CustomCheckboxCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        this.checkBox = new Label(parent, 0);
        this.setCheckIcon();
        this.checkBox.setFont(parent.getFont());
        this.checkBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomCheckboxCellEditor.this.focusLost();
            }
        });
        this.addMouseListener();
        return this.checkBox;
    }

    private void setCheckIcon() {
        Image image = this.checked ? ImageUtils.getImageCheckboxEnabledOn() : ImageUtils.getImageCheckboxEnabledOff();
        this.checkBox.setImage(image);
    }

    protected Boolean doGetValue() {
        return this.checked;
    }

    protected void doSetFocus() {
        this.checkBox.setFocus();
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.checkBox != null && value instanceof Boolean ? 1 : 0) != 0);
        this.checked = CommonUtils.toBoolean((Object)value);
        this.setCheckIcon();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if ((this.getStyle() & 0x4000) == 16384) {
            layoutData.grabHorizontal = false;
            layoutData.horizontalAlignment = 16384;
        } else {
            layoutData.grabHorizontal = false;
            layoutData.horizontalAlignment = 0x1000000;
        }
        return layoutData;
    }

    void applyEditorValue() {
        Boolean newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.setCheckIcon();
    }

    protected int getDoubleClickTimeout() {
        return 0;
    }

    public void activate() {
        this.checked = !this.checked;
        this.setCheckIcon();
        this.applyEditorValue();
        DBeaverUI.asyncExec(() -> ((CustomCheckboxCellEditor)this).fireApplyEditorValue());
    }

    private void addMouseListener() {
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CustomCheckboxCellEditor.this.checked = !CustomCheckboxCellEditor.this.checked;
                CustomCheckboxCellEditor.this.setCheckIcon();
                CustomCheckboxCellEditor.this.applyEditorValue();
                CustomCheckboxCellEditor.this.fireApplyEditorValue();
            }
        });
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        if (activationEvent.eventType != 5) {
            super.activate(activationEvent);
        }
    }
}

