/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.edit.DBEObjectEditor;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseObject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionWizard;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInputFactory;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.FolderEditor;
import org.jkiss.dbeaver.ui.editors.entity.NodeEditorInput;
import org.jkiss.dbeaver.ui.editors.object.ObjectEditorInput;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.resources.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectOpen
extends NavigatorHandlerObjectBase
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerObjectOpen.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object element : structSelection) {
                DBNNode node = null;
                if (element instanceof IResource) {
                    NavigatorHandlerObjectOpen.openResource((IResource)element, HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
                    continue;
                }
                if (element instanceof DBNNode) {
                    node = (DBNNode)element;
                } else {
                    DBSObject object = (DBSObject)RuntimeUtils.getObjectAdapter(element, DBSObject.class);
                    if (object != null) {
                        node = NavigatorHandlerObjectOpen.getNodeByObject(object);
                    }
                }
                if (node == null) continue;
                NavigatorUtils.openNavigatorNode(node, HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
            }
        }
        return null;
    }

    public static void openResource(IResource resource, IWorkbenchWindow window) {
        try {
            DBPResourceHandler handler = DBeaverCore.getInstance().getProjectRegistry().getResourceHandler(resource);
            if (handler != null) {
                handler.openResource(resource);
            }
        }
        catch (Exception e) {
            DBUserInterface.getInstance().showError(CoreMessages.actions_navigator_error_dialog_open_resource_title, "Can't open resource '" + resource.getName() + "'", (Throwable)e);
        }
    }

    @Nullable
    public static IEditorPart openEntityEditor(DBSObject object) {
        DBNDatabaseNode node = NavigatorHandlerObjectOpen.getNodeByObject(object);
        if (node != null) {
            return NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)node, null, DBeaverUI.getActiveWorkbenchWindow());
        }
        return null;
    }

    public static IEditorPart openEntityEditor(DBNNode selectedNode, @Nullable String defaultPageId, IWorkbenchWindow workbenchWindow) {
        return NavigatorHandlerObjectOpen.openEntityEditor(selectedNode, defaultPageId, null, workbenchWindow);
    }

    public static IEditorPart openEntityEditor(@NotNull DBNNode selectedNode, @Nullable String defaultPageId, @Nullable Map<String, Object> attributes, IWorkbenchWindow workbenchWindow) {
        block10: {
            if (selectedNode instanceof DBNDataSource) {
                DataSourceDescriptor dataSourceContainer = (DataSourceDescriptor)((DBNDataSource)selectedNode).getDataSourceContainer();
                NavigatorHandlerObjectOpen.openConnectionEditor(workbenchWindow, dataSourceContainer);
                return null;
            }
            try {
                IEditorPart editor;
                String defaultFolderId = null;
                if (selectedNode instanceof DBNDatabaseFolder && !(selectedNode.getParentNode() instanceof DBNDatabaseFolder) && selectedNode.getParentNode() instanceof DBNDatabaseNode) {
                    defaultFolderId = selectedNode.getNodeType();
                    selectedNode = selectedNode.getParentNode();
                }
                if ((editor = NavigatorHandlerObjectOpen.findEntityEditor(workbenchWindow, selectedNode)) != null) {
                    if (editor instanceof ITabbedFolderContainer && defaultFolderId != null) {
                        ((ITabbedFolderContainer)editor).switchFolder(defaultFolderId);
                    }
                    workbenchWindow.getActivePage().activate((IWorkbenchPart)editor);
                    return editor;
                }
                if (selectedNode instanceof DBNDatabaseObject) {
                    DBNDatabaseObject objectNode = (DBNDatabaseObject)selectedNode;
                    ObjectEditorInput objectInput = new ObjectEditorInput(objectNode);
                    NavigatorHandlerObjectOpen.setInputAttributes(objectInput, defaultPageId, defaultFolderId, attributes);
                    return workbenchWindow.getActivePage().openEditor((IEditorInput)objectInput, objectNode.getMeta().getEditorId());
                }
                if (!(selectedNode instanceof DBNDatabaseNode)) break block10;
                DBNDatabaseNode dnNode = (DBNDatabaseNode)selectedNode;
                if (dnNode.getObject() != null) {
                    EntityEditorInput editorInput = new EntityEditorInput(dnNode);
                    if (DBeaverCore.getGlobalPreferenceStore().getBoolean("navigator.refresh.editor.open") && !(dnNode.getObject() instanceof DBSObjectContainer)) {
                        NavigatorHandlerObjectOpen.refreshDatabaseNode(dnNode);
                    }
                    NavigatorHandlerObjectOpen.setInputAttributes(editorInput, defaultPageId, defaultFolderId, attributes);
                    return workbenchWindow.getActivePage().openEditor((IEditorInput)editorInput, EntityEditor.class.getName());
                }
                DBUserInterface.getInstance().showError("No object", "Node do not has associated database object");
                return null;
            }
            catch (Exception ex) {
                DBUserInterface.getInstance().showError(CoreMessages.actions_navigator_error_dialog_open_entity_title, "Can't open entity '" + selectedNode.getNodeName() + "'", (Throwable)ex);
                return null;
            }
        }
        NodeEditorInput folderInput = new NodeEditorInput(selectedNode);
        return workbenchWindow.getActivePage().openEditor((IEditorInput)folderInput, FolderEditor.class.getName());
    }

    public static IEditorPart findEntityEditor(IWorkbenchWindow workbenchWindow, DBNNode node) {
        DatabaseEditorInputFactory.setLookupEditor(true);
        try {
            IEditorReference[] iEditorReferenceArray = workbenchWindow.getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    IEditorInput editorInput;
                    IEditorReference ref = iEditorReferenceArray[n2];
                    try {
                        editorInput = ref.getEditorInput();
                    }
                    catch (Throwable e) {
                        break block11;
                    }
                    if (editorInput instanceof INavigatorEditorInput) {
                        boolean matches;
                        if (editorInput instanceof DatabaseLazyEditorInput) {
                            matches = node.getNodeItemPath().equals(((DatabaseLazyEditorInput)editorInput).getNodePath());
                        } else {
                            boolean bl = matches = ((INavigatorEditorInput)editorInput).getNavigatorNode() == node;
                        }
                        if (matches) {
                            IEditorPart iEditorPart = ref.getEditor(true);
                            return iEditorPart;
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            DatabaseEditorInputFactory.setLookupEditor(false);
        }
        return null;
    }

    private static void refreshDatabaseNode(@NotNull DBNDatabaseNode selectedNode) throws InvocationTargetException, InterruptedException {
        final DBNDatabaseNode nodeToRefresh = selectedNode;
        DBeaverUI.runInProgressService(new DBRRunnableWithProgress(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    nodeToRefresh.refreshNode(monitor, (Object)nodeToRefresh);
                }
                catch (DBException e) {
                    log.error((Object)"Error refreshing database object", (Throwable)e);
                }
            }
        });
    }

    private static void openConnectionEditor(IWorkbenchWindow workbenchWindow, DataSourceDescriptor dataSourceContainer) {
        EditConnectionDialog dialog = new EditConnectionDialog(workbenchWindow, new EditConnectionWizard(dataSourceContainer));
        dialog.open();
    }

    public static void openResourceEditor(IWorkbenchWindow workbenchWindow, ResourceUtils.ResourceInfo resourceInfo) {
        if (resourceInfo.getResource() != null) {
            NavigatorHandlerObjectOpen.openResource(resourceInfo.getResource(), workbenchWindow);
        } else if (resourceInfo.getLocalFile() != null) {
            EditorUtils.openExternalFileEditor(resourceInfo.getLocalFile(), workbenchWindow);
        }
    }

    private static void setInputAttributes(DatabaseEditorInput<?> editorInput, String defaultPageId, String defaultFolderId, Map<String, Object> attributes) {
        editorInput.setDefaultPageId(defaultPageId);
        editorInput.setDefaultFolderId(defaultFolderId);
        if (!CommonUtils.isEmpty(attributes)) {
            for (Map.Entry<String, Object> attr : attributes.entrySet()) {
                editorInput.setAttribute(attr.getKey(), attr.getValue());
            }
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        ISelection selection;
        DBNNode node;
        if (!updateUI) {
            return;
        }
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider(element.getServiceLocator());
        if (selectionProvider != null && (node = NavigatorUtils.getSelectedNode(selection = selectionProvider.getSelection())) != null) {
            DBSObject object;
            String actionName = CoreMessages.actions_navigator_open;
            if (node instanceof DBNDataSource) {
                actionName = CoreMessages.actions_navigator_edit;
            } else if (node instanceof DBNDatabaseNode && (object = ((DBNDatabaseNode)node).getObject()) != null) {
                DBEObjectEditor objectManager = EntityEditorsRegistry.getInstance().getObjectManager(object.getClass(), DBEObjectEditor.class);
                actionName = objectManager == null || !objectManager.canEditObject((DBPObject)object) ? CoreMessages.actions_navigator_view : CoreMessages.actions_navigator_edit;
            }
            String label = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1 ? String.valueOf(actionName) + CoreMessages.actions_navigator__objects : String.valueOf(actionName) + " " + node.getNodeType();
            element.setText(label);
        }
    }
}

