/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerProjectCreate;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorInput;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class NavigatorHandlerObjectCreateBase
extends NavigatorHandlerObjectBase {
    protected boolean createNewObject(IWorkbenchWindow workbenchWindow, DBNNode element, DBNDatabaseNode copyFrom) {
        try {
            DBNContainer container = null;
            if (element instanceof DBNContainer && !(element instanceof DBNDataSource)) {
                container = (DBNContainer)element;
            } else {
                DBNNode parentNode = element.getParentNode();
                if (parentNode instanceof DBNContainer) {
                    container = (DBNContainer)parentNode;
                }
            }
            if (container == null) {
                throw new DBException("Can't detect container for '" + element.getNodeName() + "'");
            }
            Class childType = container.getChildrenClass();
            if (childType == null) {
                throw new DBException("Can't determine child element type for container '" + container + "'");
            }
            if (childType == IProject.class) {
                return NavigatorHandlerProjectCreate.createNewProject(workbenchWindow);
            }
            DBSObject sourceObject = copyFrom == null ? null : copyFrom.getObject();
            EntityEditorsRegistry editorsRegistry = EntityEditorsRegistry.getInstance();
            DBEObjectManager<?> objectManager = editorsRegistry.getObjectManager(childType);
            if (objectManager == null) {
                throw new DBException("Object manager not found for type '" + childType.getName() + "'");
            }
            DBEObjectMaker objectMaker = (DBEObjectMaker)objectManager;
            DBPDataSource dataSource = container instanceof DBNDatabaseNode ? ((DBNDatabaseNode)container).getDataSource() : null;
            boolean openEditor = dataSource != null && (objectMaker.getMakerOptions(dataSource) & 4L) != 0L;
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectCreateBase.getCommandTarget(workbenchWindow, container, childType, openEditor);
            Object parentObject = container.getValueObject();
            if (!(parentObject instanceof DBPObject)) {
                throw new DBException("Parent object type is not supported: " + parentObject);
            }
            this.createDatabaseObject(commandTarget, objectMaker, (DBPObject)parentObject, sourceObject);
        }
        catch (Throwable e) {
            DBUserInterface.getInstance().showError("Create object", null, e);
            return false;
        }
        return true;
    }

    private <OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject> void createDatabaseObject(NavigatorHandlerObjectBase.CommandTarget commandTarget, DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, CONTAINER_TYPE parentObject, DBSObject sourceObject) throws DBException {
        CreateJob<OBJECT_TYPE, CONTAINER_TYPE> job = new CreateJob<OBJECT_TYPE, CONTAINER_TYPE>(commandTarget, objectMaker, parentObject, sourceObject);
        job.schedule();
    }

    static class CreateJob<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject>
    extends AbstractJob {
        private final NavigatorHandlerObjectBase.CommandTarget commandTarget;
        private final DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker;
        private final CONTAINER_TYPE parentObject;
        private final DBSObject sourceObject;
        private OBJECT_TYPE newObject;

        public CreateJob(NavigatorHandlerObjectBase.CommandTarget commandTarget, DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, CONTAINER_TYPE parentObject, DBSObject sourceObject) {
            super("Create new database object with " + objectMaker.getClass().getSimpleName());
            this.setUser(true);
            this.commandTarget = commandTarget;
            this.objectMaker = objectMaker;
            this.parentObject = parentObject;
            this.sourceObject = sourceObject;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                this.newObject = this.objectMaker.createNewObject(monitor, this.commandTarget.getContext(), this.parentObject, (Object)this.sourceObject);
                if (this.newObject == null) {
                    return Status.CANCEL_STATUS;
                }
                if (this.parentObject instanceof DBSObject && (this.objectMaker.getMakerOptions(((DBSObject)this.parentObject).getDataSource()) & 1L) != 0L) {
                    DBNDatabaseNode newChild;
                    this.commandTarget.getContext().saveChanges(monitor, DBPScriptObject.EMPTY_OPTIONS);
                    if (this.newObject instanceof DBPRefreshableObject && (newChild = DBeaverCore.getInstance().getNavigatorModel().findNode(this.newObject)) != null) {
                        newChild.refreshNode(monitor, (Object)this);
                        this.newObject = newChild.getObject();
                    }
                }
                int i = 0;
                while (i < 50) {
                    if (DBeaverCore.getInstance().getNavigatorModel().findNode(this.newObject) != null) break;
                    RuntimeUtils.pause((int)100);
                    ++i;
                }
                DBeaverUI.syncExec(this::openNewObject);
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                return GeneralUtils.makeExceptionStatus((Throwable)e);
            }
        }

        private void openNewObject() {
            block7: {
                IWorkbenchWindow workbenchWindow = DBeaverUI.getActiveWorkbenchWindow();
                try {
                    DBNDatabaseNode newChild = DBeaverCore.getInstance().getNavigatorModel().findNode(this.newObject);
                    if (newChild != null) {
                        DatabaseNavigatorView view = UIUtils.findView(workbenchWindow, DatabaseNavigatorView.class);
                        if (view != null) {
                            view.showNode((DBNNode)newChild);
                        }
                        boolean openEditor = this.parentObject instanceof DBSObject && (this.objectMaker.getMakerOptions(((DBSObject)this.parentObject).getDataSource()) & 4L) != 0L;
                        IDatabaseEditor editor = this.commandTarget.getEditor();
                        if (editor != null) {
                            workbenchWindow.getActivePage().activate((IWorkbenchPart)editor);
                        } else if (openEditor) {
                            EntityEditorInput editorInput = new EntityEditorInput(newChild, this.commandTarget.getContext());
                            workbenchWindow.getActivePage().openEditor((IEditorInput)editorInput, EntityEditor.class.getName());
                        }
                        break block7;
                    }
                    throw new DBException("Can't find node corresponding to new object");
                }
                catch (Throwable e) {
                    DBUserInterface.getInstance().showError("Create object", null, e);
                }
            }
        }
    }
}

