/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.IOUtils;

public class StreamTransferConsumer
implements IDataTransferConsumer<StreamConsumerSettings, IStreamDataExporter> {
    private static final Log log = Log.getLog(StreamTransferConsumer.class);
    private static final String LOB_DIRECTORY_NAME = "files";
    public static final String VARIABLE_TABLE = "table";
    public static final String VARIABLE_TIMESTAMP = "timestamp";
    public static final String VARIABLE_DATE = "date";
    public static final String VARIABLE_PROJECT = "project";
    public static final String VARIABLE_FILE = "file";
    private IStreamDataExporter processor;
    private StreamConsumerSettings settings;
    private DBSObject sourceObject;
    private OutputStream outputStream;
    private ZipOutputStream zipStream;
    private PrintWriter writer;
    private List<DBDAttributeBinding> metaColumns;
    private Object[] row;
    private File lobDirectory;
    private long lobCount;
    private File outputFile;
    private StreamExportSite exportSite;
    private Map<Object, Object> processorProperties;
    private StringWriter outputBuffer;
    private boolean initialized = false;

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        if (!this.initialized) {
            this.initExporter(session);
        }
        this.metaColumns = new ArrayList<DBDAttributeBinding>();
        List attributes = resultSet.getMeta().getAttributes();
        for (DBCAttributeMetaData attribute : attributes) {
            DBDAttributeBindingMeta columnBinding = DBUtils.getAttributeBinding((DBCSession)session, (DBCAttributeMetaData)attribute);
            this.metaColumns.add((DBDAttributeBinding)columnBinding);
        }
        this.row = new Object[this.metaColumns.size()];
        if (!this.initialized) {
            try {
                this.processor.exportHeader(session);
            }
            catch (DBException e) {
                log.warn((Object)"Error while exporting table header", (Throwable)e);
            }
            catch (IOException e) {
                throw new DBCException("IO error", (Throwable)e);
            }
        }
        this.initialized = true;
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        try {
            int i = 0;
            while (i < this.metaColumns.size()) {
                DBDAttributeBinding column = this.metaColumns.get(i);
                Object value = column.getValueHandler().fetchValueObject(session, resultSet, (DBSTypedObject)column.getAttribute(), column.getOrdinalPosition());
                if (value instanceof DBDContent && !this.settings.isOutputClipboard() && !ContentUtils.isTextContent((DBDContent)((DBDContent)value))) {
                    switch (this.settings.getLobExtractType()) {
                        case SKIP: {
                            value = null;
                            break;
                        }
                        case INLINE: {
                            break;
                        }
                        case FILES: {
                            value = this.saveContentToFile(session.getProgressMonitor(), (DBDContent)value);
                        }
                    }
                }
                this.row[i] = value;
                ++i;
            }
            this.processor.exportRow(session, this.row);
        }
        catch (IOException e) {
            throw new DBCException("IO error", (Throwable)e);
        }
        catch (Throwable e) {
            throw new DBCException("Error while exporting table row", e);
        }
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
    }

    public void close() {
        this.metaColumns = null;
        this.row = null;
    }

    private File saveContentToFile(DBRProgressMonitor monitor, DBDContent content) throws IOException, DBCException {
        DBDContentStorage contents = content.getContents(monitor);
        if (contents == null) {
            log.warn((Object)"Null value content");
            return null;
        }
        if (this.lobDirectory == null) {
            this.lobDirectory = new File(this.settings.getOutputFolder(), LOB_DIRECTORY_NAME);
            if (!this.lobDirectory.exists() && !this.lobDirectory.mkdir()) {
                throw new IOException("Can't create directory for CONTENT files: " + this.lobDirectory.getAbsolutePath());
            }
        }
        ++this.lobCount;
        Boolean extractImages = (Boolean)this.processorProperties.get("extractImages");
        String fileExt = extractImages != null && extractImages != false ? ".jpg" : ".data";
        File lobFile = new File(this.lobDirectory, String.valueOf(this.outputFile.getName()) + "-" + this.lobCount + fileExt);
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream cs = contents.getContentStream();){
            ContentUtils.saveContentToFile((InputStream)cs, (File)lobFile, (DBRProgressMonitor)monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lobFile;
    }

    private void initExporter(DBCSession session) throws DBCException {
        if (this.settings.getFormatterProfile() != null) {
            session.setDataFormatterProfile(this.settings.getFormatterProfile());
        }
        this.exportSite = new StreamExportSite();
        boolean outputClipboard = this.settings.isOutputClipboard();
        this.outputFile = outputClipboard ? null : this.makeOutputFile();
        try {
            byte[] bom;
            if (outputClipboard) {
                this.outputBuffer = new StringWriter(2048);
                this.writer = new PrintWriter((Writer)this.outputBuffer, true);
            } else {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile), 10000);
                if (this.settings.isCompressResults()) {
                    this.zipStream = new ZipOutputStream(this.outputStream);
                    this.zipStream.putNextEntry(new ZipEntry(this.getOutputFileName()));
                    this.outputStream = this.zipStream;
                }
                this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, this.settings.getOutputEncoding()), true);
            }
            if (!outputClipboard && this.settings.isOutputEncodingBOM() && (bom = GeneralUtils.getCharsetBOM((String)this.settings.getOutputEncoding())) != null) {
                this.outputStream.write(bom);
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            this.closeExporter();
            throw new DBCException("Data transfer IO error", (Throwable)e);
        }
        try {
            this.processor.init(this.exportSite);
        }
        catch (DBException e) {
            throw new DBCException("Can't initialize data exporter", (Throwable)e);
        }
    }

    private void closeExporter() {
        if (this.exportSite != null) {
            try {
                this.exportSite.flush();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
        }
        if (this.processor != null) {
            this.processor.dispose();
            this.processor = null;
        }
        if (this.zipStream != null) {
            try {
                this.zipStream.closeEntry();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            try {
                this.zipStream.finish();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
        }
        if (this.writer != null) {
            ContentUtils.close((Closeable)this.writer);
            this.writer = null;
        }
        if (this.outputStream != null) {
            ContentUtils.close((Closeable)this.outputStream);
            this.outputStream = null;
        }
    }

    @Override
    public void initTransfer(DBSObject sourceObject, StreamConsumerSettings settings, IStreamDataExporter processor, Map<Object, Object> processorProperties) {
        this.sourceObject = sourceObject;
        this.processor = processor;
        this.settings = settings;
        this.processorProperties = processorProperties;
    }

    @Override
    public void startTransfer(DBRProgressMonitor monitor) {
    }

    @Override
    public void finishTransfer(DBRProgressMonitor monitor, boolean last) {
        if (!last) {
            try {
                this.processor.exportFooter(monitor);
            }
            catch (Exception e) {
                log.warn((Object)"Error while exporting table footer", (Throwable)e);
            }
            this.closeExporter();
            if (!this.settings.isOutputClipboard() && this.settings.isExecuteProcessOnFinish()) {
                this.executeFinishCommand();
            }
            return;
        }
        if (this.settings.isOutputClipboard()) {
            if (this.outputBuffer != null) {
                DBeaverUI.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        new Clipboard(DBeaverUI.getDisplay()).setContents(new Object[]{StreamTransferConsumer.this.outputBuffer.toString()}, new Transfer[]{textTransfer});
                    }
                });
                this.outputBuffer = null;
            }
        } else if (this.settings.isOpenFolderOnFinish()) {
            DBeaverUI.asyncExec(new Runnable(){

                @Override
                public void run() {
                    UIUtils.launchProgram(StreamTransferConsumer.this.settings.getOutputFolder());
                }
            });
        }
    }

    private void executeFinishCommand() {
        String commandLine = this.translatePattern(this.settings.getFinishProcessCommand(), DBUtils.getObjectOwnerProject((DBSObject)this.sourceObject), StreamTransferConsumer.stripObjectName(this.sourceObject.getName()), this.outputFile);
        DBRShellCommand command = new DBRShellCommand(commandLine);
        DBRProcessDescriptor processDescriptor = new DBRProcessDescriptor(command);
        try {
            processDescriptor.execute();
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Run process", "Error running process [" + commandLine + "]", (Throwable)e);
        }
    }

    @Override
    public String getTargetName() {
        return this.settings.isOutputClipboard() ? "Clipboard" : this.makeOutputFile().getAbsolutePath();
    }

    public String getOutputFileName() {
        Object extension = this.processorProperties.get("extension");
        String fileName = this.translatePattern(this.settings.getOutputFilePattern(), DBUtils.getObjectOwnerProject((DBSObject)this.sourceObject), StreamTransferConsumer.stripObjectName(this.sourceObject.getName()), null);
        if (extension != null) {
            return String.valueOf(fileName) + "." + extension;
        }
        return fileName;
    }

    public File makeOutputFile() {
        File dir = new File(this.settings.getOutputFolder());
        if (!dir.exists() && !dir.mkdirs()) {
            log.error((Object)("Can't create output directory '" + dir.getAbsolutePath() + "'"));
        }
        String fileName = this.getOutputFileName();
        if (this.settings.isCompressResults()) {
            fileName = String.valueOf(fileName) + ".zip";
        }
        return new File(dir, fileName);
    }

    private String translatePattern(String pattern, IProject project, String tableName, File targetFile) {
        pattern = GeneralUtils.replaceVariables((String)pattern, name -> {
            switch (name) {
                case "table": {
                    return tableName;
                }
                case "timestamp": {
                    return RuntimeUtils.getCurrentTimeStamp();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
                case "project": {
                    return project == null ? "" : project.getName();
                }
                case "file": {
                    return targetFile == null ? "" : targetFile.getAbsolutePath();
                }
            }
            return null;
        });
        return pattern.replace("{table}", tableName).replace("{timestamp}", RuntimeUtils.getCurrentTimeStamp());
    }

    private static String stripObjectName(String name) {
        StringBuilder result = new StringBuilder();
        boolean lastUnd = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                result.append(c);
                lastUnd = false;
            } else if (!lastUnd) {
                result.append('_');
                lastUnd = true;
            }
            if (result.length() >= 64) break;
            ++i;
        }
        return result.toString();
    }

    private class StreamExportSite
    implements IStreamDataExporterSite {
        private StreamExportSite() {
        }

        @Override
        public DBPNamedObject getSource() {
            return StreamTransferConsumer.this.sourceObject;
        }

        @Override
        public DBDDisplayFormat getExportFormat() {
            DBDDisplayFormat format = DBDDisplayFormat.UI;
            Object formatProp = StreamTransferConsumer.this.processorProperties.get("format");
            if (formatProp != null) {
                format = DBDDisplayFormat.valueOf((String)formatProp.toString().toUpperCase(Locale.ENGLISH));
            }
            return format;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return StreamTransferConsumer.this.processorProperties;
        }

        @Override
        public List<DBDAttributeBinding> getAttributes() {
            return StreamTransferConsumer.this.metaColumns;
        }

        @Override
        public OutputStream getOutputStream() {
            return StreamTransferConsumer.this.outputStream;
        }

        @Override
        public PrintWriter getWriter() {
            return StreamTransferConsumer.this.writer;
        }

        @Override
        public void flush() throws IOException {
            if (StreamTransferConsumer.this.writer != null) {
                StreamTransferConsumer.this.writer.flush();
            }
            if (StreamTransferConsumer.this.outputStream != null) {
                StreamTransferConsumer.this.outputStream.flush();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void writeBinaryData(@NotNull DBDContentStorage cs) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream stream = cs.getContentStream();){
                StreamTransferConsumer.this.exportSite.flush();
                DBPDataSource dataSource = StreamTransferConsumer.this.sourceObject.getDataSource();
                if (dataSource instanceof SQLDataSource) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream((int)cs.getContentLength());
                    IOUtils.copyStream((InputStream)stream, (OutputStream)buffer);
                    byte[] bytes = buffer.toByteArray();
                    String binaryString = ((SQLDataSource)dataSource).getSQLDialect().getNativeBinaryFormatter().toString(bytes, 0, bytes.length);
                    StreamTransferConsumer.this.writer.write(binaryString);
                    return;
                }
                switch (StreamTransferConsumer.this.settings.getLobEncoding()) {
                    case BASE64: {
                        Base64.encode((InputStream)stream, (long)cs.getContentLength(), (Writer)StreamTransferConsumer.this.writer);
                        return;
                    }
                    case HEX: {
                        StreamTransferConsumer.this.writer.write("0x");
                        byte[] buffer = new byte[5000];
                        while (true) {
                            int count;
                            if ((count = stream.read(buffer)) <= 0) {
                                return;
                            }
                            GeneralUtils.writeBytesAsHex((Writer)StreamTransferConsumer.this.writer, (byte[])buffer, (int)0, (int)count);
                        }
                    }
                    default: {
                        Throwable throwable2 = null;
                        Object var7_14 = null;
                        try (InputStreamReader reader = new InputStreamReader(stream, cs.getCharset());){
                            IOUtils.copyText((Reader)reader, (Writer)StreamTransferConsumer.this.writer);
                            return;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }
}

