/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.handlers;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.handlers.DataTransferHandler;
import org.jkiss.dbeaver.ui.dialogs.BrowseObjectDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DataImportHandler
extends DataTransferHandler
implements IElementUpdater {
    @Override
    protected IDataTransferNode adaptTransferNode(Object object) {
        DBSDataManipulator adapted = (DBSDataManipulator)RuntimeUtils.getObjectAdapter((Object)object, DBSDataManipulator.class);
        if (adapted != null) {
            return new DatabaseTransferConsumer(adapted);
        }
        return null;
    }

    @Override
    protected IDataTransferProducer chooseProducer(ExecutionEvent event, IDataTransferConsumer consumer) {
        DBSObject object;
        DBNModel navigatorModel = DBeaverCore.getInstance().getNavigatorModel();
        DBNRoot rootNode = DBeaverCore.getInstance().getLiveProjects().size() == 1 ? navigatorModel.getRoot().getProject(DBeaverCore.getInstance().getProjectRegistry().getActiveProject()) : navigatorModel.getRoot();
        DBNNode node = BrowseObjectDialog.selectObject(HandlerUtil.getActiveShell((ExecutionEvent)event), "Select source container for '" + consumer.getTargetName() + "'", (DBNNode)rootNode, null, new Class[]{DBSObjectContainer.class, DBSDataContainer.class}, new Class[]{DBSDataContainer.class});
        if (node instanceof DBNDatabaseNode && (object = ((DBNDatabaseNode)node).getObject()) instanceof DBSDataContainer) {
            return new DatabaseTransferProducer((DBSDataContainer)object);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        DBNNode node = NavigatorUtils.getSelectedNode(element);
        if (node != null) {
            element.setText("Import " + node.getNodeType() + " Data");
        }
    }
}

