/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;

public class DatabaseTransferProducer
implements IDataTransferProducer<DatabaseProducerSettings> {
    private static final Log log = Log.getLog(DatabaseTransferProducer.class);
    @NotNull
    private DBSDataContainer dataContainer;
    @Nullable
    private DBDDataFilter dataFilter;

    public DatabaseTransferProducer(@NotNull DBSDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public DatabaseTransferProducer(@NotNull DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter) {
        this.dataContainer = dataContainer;
        this.dataFilter = dataFilter;
    }

    public DBSDataContainer getSourceObject() {
        return this.dataContainer;
    }

    @Override
    public void transferData(DBRProgressMonitor monitor, IDataTransferConsumer consumer, DatabaseProducerSettings settings) throws DBException {
        block40: {
            boolean selectiveExportFromUI;
            String contextTask = CoreMessages.data_transfer_wizard_job_task_export;
            DBPDataSource dataSource = this.getSourceObject().getDataSource();
            assert (dataSource != null);
            boolean bl = selectiveExportFromUI = settings.isSelectedColumnsOnly() || settings.isSelectedRowsOnly();
            if (this.dataContainer instanceof ResultSetDataContainer) {
                ((ResultSetDataContainer)this.dataContainer).getOptions().setExportSelectedRows(settings.isSelectedRowsOnly());
                ((ResultSetDataContainer)this.dataContainer).getOptions().setExportSelectedColumns(settings.isSelectedColumnsOnly());
            }
            boolean newConnection = settings.isOpenNewConnections();
            boolean forceDataReadTransactions = Boolean.TRUE.equals(dataSource.getDataSourceFeature("data-transfer.force-transactions"));
            DBCExecutionContext context = !selectiveExportFromUI && newConnection ? dataSource.openIsolatedContext(monitor, "Data transfer producer") : dataSource.getDefaultContext(false);
            Throwable throwable = null;
            Object var11_12 = null;
            try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, contextTask);){
                try {
                    long totalRows;
                    AbstractExecutionSource transferSource;
                    block39: {
                        transferSource = new AbstractExecutionSource(this.dataContainer, context, (Object)consumer);
                        session.enableLogging(false);
                        if (!selectiveExportFromUI && (newConnection || forceDataReadTransactions)) {
                            try {
                                DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                                if (txnManager != null) {
                                    txnManager.setAutoCommit(monitor, false);
                                }
                            }
                            catch (DBCException e) {
                                log.warn((Object)"Can't change auto-commit", (Throwable)e);
                            }
                        }
                        totalRows = 0L;
                        if (settings.isQueryRowCount() && (this.dataContainer.getSupportedFeatures() & 1) != 0) {
                            monitor.beginTask(CoreMessages.data_transfer_wizard_job_task_retrieve, 1);
                            try {
                                try {
                                    totalRows = this.dataContainer.countData((DBCExecutionSource)transferSource, session, this.dataFilter);
                                }
                                catch (Throwable e) {
                                    log.warn((Object)("Can't retrieve row count from '" + this.dataContainer.getName() + "'"), e);
                                    try {
                                        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                                        if (txnManager != null && !txnManager.isAutoCommit()) {
                                            txnManager.rollback(session, null);
                                        }
                                    }
                                    catch (Throwable e1) {
                                        log.warn((Object)"Error rolling back transaction", e1);
                                    }
                                    monitor.done();
                                    break block39;
                                }
                            }
                            catch (Throwable throwable2) {
                                monitor.done();
                                throw throwable2;
                            }
                            monitor.done();
                        }
                    }
                    monitor.beginTask(CoreMessages.data_transfer_wizard_job_task_export_table_data, (int)totalRows);
                    try {
                        DBCStatistics statistics;
                        if (settings.getExtractType() == DatabaseProducerSettings.ExtractType.SINGLE_QUERY) {
                            this.dataContainer.readData((DBCExecutionSource)transferSource, session, (DBDDataReceiver)consumer, this.dataFilter, -1L, -1L, 0L);
                            break block40;
                        }
                        long offset = 0L;
                        int segmentSize = settings.getSegmentSize();
                        while ((statistics = this.dataContainer.readData((DBCExecutionSource)transferSource, session, (DBDDataReceiver)consumer, this.dataFilter, offset, (long)segmentSize, 0L)) != null) {
                            if (statistics.getRowsFetched() < (long)segmentSize) {
                                break;
                            }
                            offset += statistics.getRowsFetched();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                finally {
                    DBCTransactionManager txnManager;
                    if (!selectiveExportFromUI && (newConnection || forceDataReadTransactions) && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context)) != null) {
                        try {
                            txnManager.commit(session);
                        }
                        catch (DBCException e) {
                            log.error((Object)"Can't finish transaction in data producer connection", (Throwable)e);
                        }
                    }
                    if (newConnection) {
                        context.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }
}

