/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.database.ColumnsMappingDialog;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.BrowseObjectDialog;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.dialogs.sql.ViewSQLDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerPageMapping
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(DatabaseConsumerPageMapping.class);
    private static final String TARGET_NAME_BROWSE = "[browse]";
    private TreeViewer mappingViewer;
    private Label containerIcon;
    private Text containerName;

    public DatabaseConsumerPageMapping() {
        super("Tables mapping");
        this.setTitle("Tables mapping");
        this.setDescription("Map tables and columns transfer");
        this.setPageComplete(false);
    }

    private DatabaseConsumerSettings getDatabaseConsumerSettings() {
        return ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        final DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Composite containerPanel = new Composite(composite, 0);
        containerPanel.setLayout((Layout)new GridLayout(4, false));
        containerPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel(containerPanel, "Target container");
        this.containerIcon = new Label(containerPanel, 0);
        this.containerIcon.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_UNKNOWN));
        this.containerName = new Text(containerPanel, 2056);
        this.containerName.setLayoutData((Object)new GridData(768));
        this.containerName.setText("");
        Button browseButton = new Button(containerPanel, 8);
        browseButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject activeProject = DBeaverCore.getInstance().getProjectRegistry().getActiveProject();
                if (activeProject != null) {
                    DBNNode node;
                    DBNModel navigatorModel = DBeaverCore.getInstance().getNavigatorModel();
                    DBNProject rootNode = navigatorModel.getRoot().getProject(activeProject);
                    DBNDatabaseNode selectedNode = settings.getContainerNode();
                    if (selectedNode == null && !settings.getDataMappings().isEmpty()) {
                        DBSDataContainer firstSource = settings.getDataMappings().keySet().iterator().next();
                        selectedNode = navigatorModel.getNodeByObject((DBSObject)firstSource);
                        while (selectedNode != null) {
                            if (selectedNode instanceof DBSWrapper && ((DBSWrapper)selectedNode).getObject() instanceof DBSObjectContainer) break;
                            selectedNode = selectedNode.getParentNode();
                        }
                    }
                    if ((node = BrowseObjectDialog.selectObject(DatabaseConsumerPageMapping.this.getShell(), "Choose container", (DBNNode)rootNode.getDatabases(), (DBNNode)selectedNode, new Class[]{DBSObjectContainer.class}, null)) instanceof DBNDatabaseNode) {
                        settings.setContainerNode((DBNDatabaseNode)node);
                        DatabaseConsumerPageMapping.this.containerIcon.setImage(DBeaverIcons.getImage(node.getNodeIconDefault()));
                        DatabaseConsumerPageMapping.this.containerName.setText(settings.getContainerFullName());
                        for (DatabaseMappingContainer mappingContainer : settings.getDataMappings().values()) {
                            if (mappingContainer.getMappingType() != DatabaseMappingType.create) continue;
                            try {
                                mappingContainer.refreshMappingType((IRunnableContext)DatabaseConsumerPageMapping.this.getContainer(), DatabaseMappingType.create);
                            }
                            catch (DBException e1) {
                                log.error((Object)e1);
                            }
                        }
                        DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                        DatabaseConsumerPageMapping.this.updatePageCompletion();
                    }
                }
            }
        });
        this.createMappingsTree(composite);
        Composite buttonsPanel = new Composite(composite, 0);
        buttonsPanel.setLayout((Layout)new GridLayout(4, false));
        buttonsPanel.setLayoutData((Object)new GridData(768));
        final Button mapTableButton = new Button(buttonsPanel, 8);
        mapTableButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
        mapTableButton.setText("Existing table ...");
        mapTableButton.setEnabled(false);
        mapTableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.mapExistingTable((DatabaseMappingContainer)DatabaseConsumerPageMapping.this.getSelectedMapping());
            }
        });
        final Button createNewButton = new Button(buttonsPanel, 8);
        createNewButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_VIEW));
        createNewButton.setText("New table...");
        createNewButton.setEnabled(false);
        createNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.mapNewTable((DatabaseMappingContainer)DatabaseConsumerPageMapping.this.getSelectedMapping());
            }
        });
        final Button columnsButton = new Button(buttonsPanel, 8);
        columnsButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_COLUMNS));
        columnsButton.setText("Columns' mappings ...");
        columnsButton.setEnabled(false);
        columnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                DatabaseConsumerPageMapping.this.mapColumns(selectedMapping instanceof DatabaseMappingContainer ? (DatabaseMappingContainer)selectedMapping : ((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
        final Button ddlButton = new Button(buttonsPanel, 8);
        ddlButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_TEXT));
        ddlButton.setText("DDL ...");
        ddlButton.setEnabled(false);
        ddlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                DatabaseConsumerPageMapping.this.showDDL(selectedMapping instanceof DatabaseMappingContainer ? (DatabaseMappingContainer)selectedMapping : ((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
        this.mappingViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    boolean updated = false;
                    Object element = null;
                    if (e.character != '\r') {
                        TreeItem item;
                        int n;
                        if (e.character == '\u007f') {
                            TreeItem[] treeItemArray = DatabaseConsumerPageMapping.this.mappingViewer.getTree().getSelection();
                            int n2 = treeItemArray.length;
                            n = 0;
                            while (n < n2) {
                                item = treeItemArray[n];
                                element = item.getData();
                                if (element instanceof DatabaseMappingAttribute) {
                                    DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)element;
                                    attribute.setMappingType(DatabaseMappingType.skip);
                                } else if (element instanceof DatabaseMappingContainer) {
                                    DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                                    container.refreshMappingType((IRunnableContext)DatabaseConsumerPageMapping.this.getContainer(), DatabaseMappingType.skip);
                                }
                                ++n;
                            }
                            updated = true;
                        } else if (e.character == ' ') {
                            TreeItem[] treeItemArray = DatabaseConsumerPageMapping.this.mappingViewer.getTree().getSelection();
                            int n3 = treeItemArray.length;
                            n = 0;
                            while (n < n3) {
                                item = treeItemArray[n];
                                element = item.getData();
                                if (element instanceof DatabaseMappingAttribute) {
                                    DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)item.getData();
                                    attribute.setMappingType(DatabaseMappingType.existing);
                                    attribute.updateMappingType((DBRProgressMonitor)new VoidProgressMonitor());
                                } else if (element instanceof DatabaseMappingContainer) {
                                    DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                                    DatabaseConsumerPageMapping.this.setMappingTarget(container, container.getSource().getName());
                                }
                                ++n;
                            }
                            updated = true;
                        }
                    }
                    if (updated) {
                        List model;
                        int curIndex;
                        DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                        DatabaseConsumerPageMapping.this.updatePageCompletion();
                        if (element instanceof DatabaseMappingContainer && (curIndex = (model = (List)DatabaseConsumerPageMapping.this.mappingViewer.getInput()).indexOf(element)) < model.size() - 1) {
                            DatabaseConsumerPageMapping.this.mappingViewer.setSelection((ISelection)new StructuredSelection(model.get(curIndex + 1)), true);
                        }
                    }
                }
                catch (DBException e1) {
                    DBUserInterface.getInstance().showError("Error mapping table", "Error mapping target table", (Throwable)e1);
                }
            }
        });
        this.mappingViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DatabaseMappingObject mapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                mapTableButton.setEnabled(mapping instanceof DatabaseMappingContainer);
                createNewButton.setEnabled(mapping instanceof DatabaseMappingContainer && settings.getContainerNode() != null);
                boolean hasMappings = mapping instanceof DatabaseMappingContainer && mapping.getMappingType() != DatabaseMappingType.unspecified || mapping instanceof DatabaseMappingAttribute && ((DatabaseMappingAttribute)mapping).getParent().getMappingType() != DatabaseMappingType.unspecified;
                columnsButton.setEnabled(hasMappings);
                ddlButton.setEnabled(hasMappings);
            }
        });
        this.mappingViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                if (selectedMapping != null) {
                    boolean cfr_ignored_0 = selectedMapping instanceof DatabaseMappingContainer;
                }
            }
        });
        Composite hintPanel = new Composite(composite, 0);
        hintPanel.setLayout((Layout)new GridLayout(3, false));
        hintPanel.setLayoutData((Object)new GridData(32));
        new Label(hintPanel, 0).setText("* DEL - skip column(s)  SPACE - map column(s)");
        this.setControl((Control)composite);
    }

    private void createMappingsTree(Composite composite) {
        this.mappingViewer = new TreeViewer(composite, 67586);
        this.mappingViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.mappingViewer.getTree().setLinesVisible(true);
        this.mappingViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn columnSource = new TreeViewerColumn(this.mappingViewer, 16384);
        columnSource.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(DBUtils.getObjectFullName((DBPNamedObject)mapping.getSource(), (DBPEvaluationContext)DBPEvaluationContext.UI));
                if (mapping.getIcon() != null) {
                    cell.setImage(DBeaverIcons.getImage(mapping.getIcon()));
                }
                super.update(cell);
            }
        });
        columnSource.getColumn().setText("Source");
        TreeViewerColumn columnTarget = new TreeViewerColumn(this.mappingViewer, 16384);
        columnTarget.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(mapping.getTargetName());
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    cell.setBackground(DBeaverUI.getSharedTextColors().getColor(SharedTextColors.COLOR_WARNING));
                } else {
                    cell.setBackground(null);
                }
                super.update(cell);
            }
        });
        columnTarget.getColumn().setText("Target");
        columnTarget.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                try {
                    return DatabaseConsumerPageMapping.this.createTargetEditor(element);
                }
                catch (DBException e) {
                    DatabaseConsumerPageMapping.this.setErrorMessage(e.getMessage());
                    return null;
                }
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    return DatabaseConsumerPageMapping.this.transformTargetName(mapping.getSource().getName());
                }
                if (mapping instanceof DatabaseMappingContainer) {
                    if (mapping.getMappingType() == DatabaseMappingType.existing) {
                        return ((DatabaseMappingContainer)mapping).getTarget();
                    }
                    return mapping.getTargetName();
                }
                if (mapping.getMappingType() == DatabaseMappingType.existing) {
                    return ((DatabaseMappingAttribute)mapping).getTarget();
                }
                return mapping.getTargetName();
            }

            protected void setValue(Object element, Object value) {
                try {
                    DatabaseConsumerSettings settings = DatabaseConsumerPageMapping.this.getDatabaseConsumerSettings();
                    String name = CommonUtils.toString((Object)value);
                    DBPDataSource dataSource = settings.getTargetDataSource((DatabaseMappingObject)element);
                    if (!name.equals("[skip]") && !name.equals(DatabaseConsumerPageMapping.TARGET_NAME_BROWSE) && dataSource != null) {
                        name = DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)name);
                    }
                    DatabaseConsumerPageMapping.this.setMappingTarget((DatabaseMappingObject)element, name);
                    DatabaseConsumerPageMapping.this.mappingViewer.update(element, null);
                    DatabaseConsumerPageMapping.this.updatePageCompletion();
                }
                catch (DBException e) {
                    DBUserInterface.getInstance().showError("Mapping error", "Error setting target table", (Throwable)e);
                }
            }
        });
        TreeViewerColumn columnMapping = new TreeViewerColumn(this.mappingViewer, 16384);
        columnMapping.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(mapping.getMappingType().name());
                super.update(cell);
            }
        });
        columnMapping.getColumn().setText("Mapping");
        columnMapping.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                ArrayList<String> mappingTypes = new ArrayList<String>();
                mappingTypes.add(DatabaseMappingType.skip.name());
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                if (mapping instanceof DatabaseMappingAttribute) {
                    mappingTypes.add(((DatabaseMappingAttribute)mapping).getParent().getMappingType().name());
                } else {
                    mappingTypes.add(mapping.getMappingType().name());
                }
                return new CustomComboBoxCellEditor((ColumnViewer)DatabaseConsumerPageMapping.this.mappingViewer, (Composite)DatabaseConsumerPageMapping.this.mappingViewer.getTree(), mappingTypes.toArray(new String[mappingTypes.size()]), 12);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                return mapping.getMappingType().name();
            }

            protected void setValue(Object element, Object value) {
                try {
                    DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                    DatabaseMappingType mappingType = DatabaseMappingType.valueOf(value.toString());
                    if (mapping instanceof DatabaseMappingAttribute) {
                        ((DatabaseMappingAttribute)mapping).setMappingType(mappingType);
                    } else {
                        ((DatabaseMappingContainer)mapping).refreshMappingType((IRunnableContext)((DataTransferWizard)((Object)DatabaseConsumerPageMapping.this.getWizard())).getContainer(), mappingType);
                    }
                    DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                    DatabaseConsumerPageMapping.this.setErrorMessage(null);
                }
                catch (DBException e) {
                    DatabaseConsumerPageMapping.this.setErrorMessage(e.getMessage());
                }
            }
        });
        this.mappingViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public boolean hasChildren(Object element) {
                return element instanceof DatabaseMappingContainer;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof DatabaseMappingContainer) {
                    return ((DatabaseMappingContainer)parentElement).getAttributeMappings((IRunnableContext)DatabaseConsumerPageMapping.this.getContainer()).toArray();
                }
                return null;
            }
        });
    }

    private CellEditor createTargetEditor(Object element) throws DBException {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        boolean allowsCreate = true;
        ArrayList<String> items = new ArrayList<String>();
        if (element instanceof DatabaseMappingContainer) {
            if (settings.getContainerNode() == null) {
                allowsCreate = false;
            }
            if (settings.getContainer() != null) {
                DBSObjectContainer container = settings.getContainer();
                for (DBSObject child : container.getChildren((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (!(child instanceof DBSDataManipulator)) continue;
                    items.add(this.transformTargetName(child.getName()));
                }
            }
            items.add(TARGET_NAME_BROWSE);
        } else {
            DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)element;
            switch (mapping.getParent().getMappingType()) {
                case unspecified: 
                case skip: {
                    allowsCreate = false;
                }
            }
            if (mapping.getParent().getTarget() instanceof DBSEntity) {
                DBSEntity parentEntity = (DBSEntity)mapping.getParent().getTarget();
                for (DBSEntityAttribute attr : parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
                    items.add(this.transformTargetName(attr.getName()));
                }
            }
        }
        items.add("[skip]");
        CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)this.mappingViewer, (Composite)this.mappingViewer.getTree(), items.toArray(new String[items.size()]), 4 | (allowsCreate ? 0 : 8));
        return editor;
    }

    private void setMappingTarget(DatabaseMappingObject mapping, String name) throws DBException {
        if (name.equals("[skip]")) {
            if (mapping instanceof DatabaseMappingAttribute) {
                ((DatabaseMappingAttribute)mapping).setMappingType(DatabaseMappingType.skip);
            } else {
                ((DatabaseMappingContainer)mapping).refreshMappingType((IRunnableContext)((DataTransferWizard)((Object)this.getWizard())).getContainer(), DatabaseMappingType.skip);
            }
        } else if (name.equals(TARGET_NAME_BROWSE)) {
            this.mapExistingTable((DatabaseMappingContainer)mapping);
        } else {
            name = this.transformTargetName(name);
            DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
            if (mapping instanceof DatabaseMappingContainer) {
                DatabaseMappingContainer containerMapping = (DatabaseMappingContainer)mapping;
                if (settings.getContainer() != null) {
                    DBSObjectContainer container = settings.getContainer();
                    for (DBSObject child : container.getChildren((DBRProgressMonitor)new VoidProgressMonitor())) {
                        if (!(child instanceof DBSDataManipulator) || !name.equalsIgnoreCase(child.getName())) continue;
                        containerMapping.setTarget((DBSDataManipulator)child);
                        containerMapping.refreshMappingType((IRunnableContext)((DataTransferWizard)((Object)this.getWizard())).getContainer(), DatabaseMappingType.existing);
                        return;
                    }
                }
                containerMapping.refreshMappingType((IRunnableContext)((DataTransferWizard)((Object)this.getWizard())).getContainer(), DatabaseMappingType.create);
                ((DatabaseMappingContainer)mapping).setTargetName(name);
            } else {
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)mapping;
                if (attrMapping.getParent().getTarget() instanceof DBSEntity) {
                    DBSEntity parentEntity = (DBSEntity)attrMapping.getParent().getTarget();
                    for (DBSEntityAttribute attr : parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
                        if (!name.equalsIgnoreCase(attr.getName())) continue;
                        attrMapping.setMappingType(DatabaseMappingType.existing);
                        attrMapping.setTarget(attr);
                        return;
                    }
                }
                attrMapping.setMappingType(DatabaseMappingType.create);
                attrMapping.setTargetName(name);
            }
        }
    }

    private void mapExistingTable(DatabaseMappingContainer mapping) {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        IProject activeProject = DBeaverCore.getInstance().getProjectRegistry().getActiveProject();
        if (activeProject != null) {
            DBNNode node;
            DBNDatabaseNode rootNode = settings.getContainerNode();
            if (rootNode == null) {
                rootNode = DBeaverCore.getInstance().getNavigatorModel().getRoot().getProject(activeProject).getDatabases();
            }
            DBNDatabaseNode selectedNode = rootNode;
            if (mapping.getTarget() != null) {
                selectedNode = NavigatorUtils.getNodeByObject((DBSObject)mapping.getTarget());
            }
            if ((node = BrowseObjectDialog.selectObject(this.getShell(), "Choose target table", (DBNNode)rootNode, (DBNNode)selectedNode, new Class[]{DBSObjectContainer.class, DBSDataManipulator.class}, new Class[]{DBSDataManipulator.class})) != null && node instanceof DBSWrapper) {
                DBSObject object = ((DBSWrapper)node).getObject();
                try {
                    if (object instanceof DBSDataManipulator) {
                        mapping.setTarget((DBSDataManipulator)object);
                        mapping.refreshMappingType((IRunnableContext)((DataTransferWizard)((Object)this.getWizard())).getContainer(), DatabaseMappingType.existing);
                        this.mapColumns(mapping);
                    } else {
                        mapping.setTarget(null);
                        mapping.refreshMappingType((IRunnableContext)((DataTransferWizard)((Object)this.getWizard())).getContainer(), DatabaseMappingType.unspecified);
                    }
                }
                catch (DBException e) {
                    DBUserInterface.getInstance().showError("Error mapping table", "Error mapping existing table", (Throwable)e);
                }
                this.mappingViewer.refresh();
                this.updatePageCompletion();
            }
        }
    }

    private void mapNewTable(DatabaseMappingContainer mapping) {
        String tableName = EnterNameDialog.chooseName(this.getShell(), "New table name", this.transformTargetName(mapping.getMappingType() == DatabaseMappingType.create ? mapping.getTargetName() : ""));
        if (!CommonUtils.isEmpty((String)tableName)) {
            try {
                mapping.setTargetName(tableName);
                mapping.refreshMappingType((IRunnableContext)((DataTransferWizard)((Object)this.getWizard())).getContainer(), DatabaseMappingType.create);
                this.mappingViewer.refresh();
                this.updatePageCompletion();
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Mapping error", "Error mapping new table", (Throwable)e);
            }
        }
    }

    private String transformTargetName(String name) {
        DBSObjectContainer container = this.getDatabaseConsumerSettings().getContainer();
        if (container == null) {
            return name;
        }
        return DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)name);
    }

    private void mapColumns(DatabaseMappingContainer mapping) {
        ColumnsMappingDialog dialog = new ColumnsMappingDialog((DataTransferWizard)((Object)this.getWizard()), this.getDatabaseConsumerSettings(), mapping);
        if (dialog.open() == 0) {
            this.mappingViewer.refresh();
            this.updatePageCompletion();
        }
    }

    private void showDDL(DatabaseMappingContainer mapping) {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        DBSObjectContainer container = settings.getContainer();
        if (container == null) {
            return;
        }
        DBPDataSource dataSource = container.getDataSource();
        try {
            String ddl = DatabaseTransferConsumer.generateTargetTableDDL((DBRProgressMonitor)new VoidProgressMonitor(), dataSource, container, mapping);
            ViewSQLDialog dialog = new ViewSQLDialog(DBeaverUI.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), dataSource.getDefaultContext(true), "Target DDL", null, ddl);
            dialog.open();
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Target DDL", "Error generatiung target DDL", (Throwable)e);
        }
    }

    DatabaseMappingObject getSelectedMapping() {
        IStructuredSelection selection = (IStructuredSelection)this.mappingViewer.getSelection();
        return selection.isEmpty() ? null : (DatabaseMappingObject)selection.getFirstElement();
    }

    @Override
    public void activatePage() {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        settings.loadNode((IRunnableContext)this.getContainer());
        DBNDatabaseNode containerNode = settings.getContainerNode();
        if (containerNode != null) {
            this.containerIcon.setImage(DBeaverIcons.getImage(containerNode.getNodeIconDefault()));
            this.containerName.setText(containerNode.getNodeFullName());
        }
        if (this.mappingViewer.getInput() == null) {
            Map<DBSDataContainer, DatabaseMappingContainer> dataMappings = settings.getDataMappings();
            for (DataTransferPipe pipe : ((DataTransferWizard)((Object)this.getWizard())).getSettings().getDataPipes()) {
                DatabaseMappingContainer mapping;
                DBSDataContainer sourceObject;
                if (pipe.getProducer() == null || dataMappings.containsKey(sourceObject = (DBSDataContainer)pipe.getProducer().getSourceObject())) continue;
                if (pipe.getConsumer() instanceof DatabaseTransferConsumer && ((DatabaseTransferConsumer)pipe.getConsumer()).getTargetObject() != null) {
                    try {
                        mapping = new DatabaseMappingContainer((IRunnableContext)this.getContainer(), this.getDatabaseConsumerSettings(), sourceObject, ((DatabaseTransferConsumer)pipe.getConsumer()).getTargetObject());
                    }
                    catch (DBException e) {
                        this.setMessage(e.getMessage(), 3);
                        mapping = new DatabaseMappingContainer(this.getDatabaseConsumerSettings(), sourceObject);
                    }
                } else {
                    mapping = new DatabaseMappingContainer(this.getDatabaseConsumerSettings(), sourceObject);
                }
                dataMappings.put(sourceObject, mapping);
            }
            ArrayList<DatabaseMappingContainer> model = new ArrayList<DatabaseMappingContainer>(dataMappings.values());
            this.mappingViewer.setInput(model);
            Tree table = this.mappingViewer.getTree();
            int totalWidth = table.getClientArea().width;
            TreeColumn[] columns = table.getColumns();
            columns[0].setWidth(totalWidth * 40 / 100);
            columns[1].setWidth(totalWidth * 40 / 100);
            columns[2].setWidth(totalWidth * 20 / 100);
        }
        this.updatePageCompletion();
    }

    @Override
    protected boolean determinePageCompletion() {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        if (settings.getContainerNode() == null) {
            this.setErrorMessage("Set target container");
            return false;
        }
        if (!settings.isCompleted(((DataTransferWizard)((Object)this.getWizard())).getSettings().getDataPipes())) {
            this.setErrorMessage("Set all tables mappings");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private static abstract class MappingLabelProvider
    extends CellLabelProvider {
        private MappingLabelProvider() {
        }

        public void update(ViewerCell cell) {
        }
    }
}

