/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.tools.compare.CompareObjectsSettings;
import org.jkiss.dbeaver.tools.compare.CompareObjectsWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

class CompareObjectsPageSettings
extends ActiveWizardPage<CompareObjectsWizard> {
    private Table nodesTable;
    private Button skipSystemObjects;
    private Button compareLazyProperties;
    private Button compareOnlyStructure;

    CompareObjectsPageSettings() {
        super("Compare objects");
        this.setTitle("Compare database objects");
        this.setDescription("Settings of objects compare");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final CompareObjectsSettings settings = ((CompareObjectsWizard)((Object)this.getWizard())).getSettings();
        Group sourceSettings = new Group(composite, 0);
        sourceSettings.setText("Objects");
        gl = new GridLayout(1, false);
        sourceSettings.setLayout((Layout)gl);
        sourceSettings.setLayoutData((Object)new GridData(1808));
        this.nodesTable = new Table((Composite)sourceSettings, 67588);
        this.nodesTable.setLayoutData((Object)new GridData(1808));
        this.nodesTable.setHeaderVisible(true);
        UIUtils.createTableColumn(this.nodesTable, 16384, "Name");
        UIUtils.createTableColumn(this.nodesTable, 16384, "Type");
        UIUtils.createTableColumn(this.nodesTable, 16384, "Full qualified name");
        for (DBNDatabaseNode node : settings.getNodes()) {
            TableItem item = new TableItem(this.nodesTable, 0);
            item.setImage(DBeaverIcons.getImage(node.getNodeIconDefault()));
            item.setText(0, node.getNodeName());
            item.setText(1, node.getNodeType());
            item.setText(2, node.getNodeFullName());
        }
        Group compareSettings = new Group(composite, 0);
        compareSettings.setText("Compare settings");
        compareSettings.setLayoutData((Object)new GridData(768));
        compareSettings.setLayout((Layout)new GridLayout(1, false));
        this.skipSystemObjects = UIUtils.createCheckbox((Composite)compareSettings, "Skip system objects", settings.isSkipSystemObjects());
        this.skipSystemObjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setSkipSystemObjects(CompareObjectsPageSettings.this.skipSystemObjects.getSelection());
            }
        });
        this.compareLazyProperties = UIUtils.createCheckbox((Composite)compareSettings, "Compare expensive properties", settings.isCompareLazyProperties());
        this.compareLazyProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompareLazyProperties(CompareObjectsPageSettings.this.compareLazyProperties.getSelection());
            }
        });
        this.compareOnlyStructure = UIUtils.createCheckbox((Composite)compareSettings, "Compare only structure (ignore properties)", settings.isCompareOnlyStructure());
        this.compareOnlyStructure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompareOnlyStructure(CompareObjectsPageSettings.this.compareOnlyStructure.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    @Override
    public void activatePage() {
        UIUtils.packColumns(this.nodesTable, true);
        this.updatePageCompletion();
    }

    @Override
    public void deactivatePage() {
        super.deactivatePage();
    }

    @Override
    protected boolean determinePageCompletion() {
        return true;
    }
}

