/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.qm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.qm.QMController;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMMCollector;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.runtime.qm.QMMCollectorImpl;

public class QMControllerImpl
implements QMController {
    private static final Log log = Log.getLog(QMControllerImpl.class);
    private QMExecutionHandler defaultHandler;
    private QMMCollectorImpl metaHandler;
    private final List<QMExecutionHandler> handlers = new ArrayList<QMExecutionHandler>();

    public QMControllerImpl() {
        this.defaultHandler = (QMExecutionHandler)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{QMExecutionHandler.class}, (InvocationHandler)new NotifyInvocationHandler());
        this.metaHandler = new QMMCollectorImpl();
        this.registerHandler(this.metaHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.metaHandler != null) {
            this.unregisterHandler(this.metaHandler);
            this.metaHandler.dispose();
            this.metaHandler = null;
        }
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.isEmpty()) {
                log.warn((Object)("Some QM handlers are still registered: " + this.handlers));
                this.handlers.clear();
            }
        }
        this.defaultHandler = null;
    }

    public QMMCollector getMetaCollector() {
        return this.metaHandler;
    }

    public QMExecutionHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(QMExecutionHandler handler) {
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(QMExecutionHandler handler) {
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.remove(handler)) {
                log.warn((Object)("QM handler '" + handler + "' isn't registered within QM controller"));
            }
        }
    }

    public void registerMetaListener(QMMetaListener metaListener) {
        this.metaHandler.addListener(metaListener);
    }

    public void unregisterMetaListener(QMMetaListener metaListener) {
        this.metaHandler.removeListener(metaListener);
    }

    public List<QMMetaEvent> getPastMetaEvents() {
        return this.metaHandler.getPastEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<QMExecutionHandler> getHandlers() {
        List<QMExecutionHandler> list = this.handlers;
        synchronized (list) {
            return this.handlers;
        }
    }

    private class NotifyInvocationHandler
    implements InvocationHandler {
        private NotifyInvocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            block11: {
                block10: {
                    try {
                        QMExecutionHandler[] handlersCopy;
                        if (method.getReturnType() != Void.TYPE || !method.getName().startsWith("handle")) break block10;
                        List list = QMControllerImpl.this.handlers;
                        synchronized (list) {
                            handlersCopy = QMControllerImpl.this.handlers.toArray(new QMExecutionHandler[QMControllerImpl.this.handlers.size()]);
                        }
                        QMExecutionHandler[] qMExecutionHandlerArray = handlersCopy;
                        int n = handlersCopy.length;
                        int n2 = 0;
                        while (n2 < n) {
                            QMExecutionHandler handler = qMExecutionHandlerArray[n2];
                            try {
                                method.invoke((Object)handler, args);
                            }
                            catch (InvocationTargetException e) {
                                log.debug((Object)("Error notifying QM handler '" + handler.getHandlerName() + "'"), e.getTargetException());
                            }
                            ++n2;
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        log.debug((Object)("Error executing QM method " + method), e);
                        return null;
                    }
                }
                if (!method.getName().equals("getHandlerName")) break block11;
                return "Default";
            }
            return method.invoke((Object)this, args);
        }
    }
}

