/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.qm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.utils.CommonUtils;

public class DefaultEventFilter
implements QMEventFilter {
    private boolean showSessions = false;
    private boolean showTransactions = false;
    private boolean showQueries = false;
    private List<DBCExecutionPurpose> showPurposes = new ArrayList<DBCExecutionPurpose>();

    public DefaultEventFilter() {
        this.reloadPreferences();
    }

    public void reloadPreferences() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        Collection objectTypes = QMObjectType.fromString((String)store.getString("qm.objectTypes"));
        this.showSessions = objectTypes.contains(QMObjectType.session);
        this.showTransactions = objectTypes.contains(QMObjectType.txn);
        this.showQueries = objectTypes.contains(QMObjectType.query);
        this.showPurposes.clear();
        for (String queryType : CommonUtils.splitString((String)store.getString("qm.queryTypes"), (char)',')) {
            try {
                this.showPurposes.add(DBCExecutionPurpose.valueOf((String)queryType));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public boolean accept(QMMetaEvent event) {
        QMMObject object = event.getObject();
        if (object instanceof QMMStatementExecuteInfo) {
            return this.showQueries && this.showPurposes.contains(((QMMStatementExecuteInfo)object).getStatement().getPurpose());
        }
        if (object instanceof QMMTransactionInfo || object instanceof QMMTransactionSavepointInfo) {
            return this.showTransactions;
        }
        if (object instanceof QMMSessionInfo) {
            return this.showSessions;
        }
        return true;
    }
}

