/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.properties.IPropertySourceEditable;
import org.jkiss.dbeaver.runtime.properties.ObjectAttributeDescriptor;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyGroupDescriptor;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ObjectPropertyDescriptor
extends ObjectAttributeDescriptor
implements DBPPropertyDescriptor,
IPropertyValueListProvider<Object> {
    private final Property propInfo;
    private final String propName;
    private final String propDescription;
    private Method setter;
    private IPropertyValueTransformer valueTransformer;
    private IPropertyValueTransformer valueRenderer;
    private final Class<?> declaringClass;
    private Format displayFormat = null;

    public ObjectPropertyDescriptor(DBPPropertySource source, ObjectPropertyGroupDescriptor parent, Property propInfo, Method getter) {
        super(source, parent, getter, propInfo.id(), propInfo.order());
        Class valueRendererClass;
        this.propInfo = propInfo;
        String propertyName = BeanUtils.getPropertyNameFromGetter((String)getter.getName());
        this.declaringClass = getter.getDeclaringClass();
        Class<?> c = this.declaringClass;
        while (this.setter == null && c != Object.class && c != null) {
            this.setter = BeanUtils.getSetMethod(c, (String)propertyName);
            if (this.setter != null) continue;
            c = c.getSuperclass();
        }
        Class valueTransformerClass = propInfo.valueTransformer();
        if (valueTransformerClass != null && valueTransformerClass != IPropertyValueTransformer.class) {
            try {
                this.valueTransformer = (IPropertyValueTransformer)valueTransformerClass.newInstance();
            }
            catch (Throwable e) {
                log.warn((Object)"Can't create value transformer", e);
            }
        }
        if ((valueRendererClass = propInfo.valueRenderer()) != null && valueRendererClass != IPropertyValueTransformer.class) {
            try {
                this.valueRenderer = (IPropertyValueTransformer)valueRendererClass.newInstance();
            }
            catch (Throwable e) {
                log.warn((Object)"Can't create value renderer", e);
            }
        }
        this.propName = this.getLocalizedString(propInfo.name(), "name", (String)this.getId(), !propInfo.hidden());
        this.propDescription = CommonUtils.isEmpty((String)propInfo.description()) ? this.propName : this.getLocalizedString(propInfo.name(), "description", this.propName, false);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isViewable() {
        return this.propInfo.viewable() && !this.propInfo.hidden();
    }

    public boolean isHidden() {
        return this.propInfo.hidden();
    }

    public boolean isExpensive() {
        return this.propInfo.expensive();
    }

    public boolean isNumeric() {
        Class<?> propType = this.getGetter().getReturnType();
        return propType != null && BeanUtils.isNumericType(propType);
    }

    public boolean isDateTime() {
        Class<?> propType = this.getGetter().getReturnType();
        return propType != null && Date.class.isAssignableFrom(propType);
    }

    public boolean supportsPreview() {
        return this.propInfo.supportsPreview();
    }

    public IPropertyValueTransformer getValueTransformer() {
        return this.valueTransformer;
    }

    public IPropertyValueTransformer getValueRenderer() {
        return this.valueRenderer;
    }

    public boolean isEditable(Object object) {
        DBPPropertySource propertySource = this.getSource();
        if (!(propertySource instanceof IPropertySourceEditable) || !((IPropertySourceEditable)propertySource).isEditable(object)) {
            return false;
        }
        return this.isNewObject(object) ? this.propInfo.editable() : this.propInfo.updatable();
    }

    public boolean isEditPossible() {
        return this.propInfo.editable();
    }

    private boolean isNewObject(Object object) {
        return object instanceof DBPPersistedObject && !((DBPPersistedObject)object).isPersisted();
    }

    @Override
    public String getCategory() {
        return CommonUtils.isEmpty((String)this.propInfo.category()) ? null : this.propInfo.category();
    }

    @Override
    public String getDescription() {
        return this.propDescription;
    }

    @NotNull
    public String getDisplayName() {
        return this.propName;
    }

    public Format getDisplayFormat() {
        if (this.displayFormat == null) {
            String format = this.propInfo.format();
            if (format == null || format.isEmpty()) {
                return null;
            }
            if (this.isNumeric()) {
                this.displayFormat = new DecimalFormat(format);
            } else if (this.isDateTime()) {
                this.displayFormat = new SimpleDateFormat(format);
            } else {
                log.debug((Object)("Don't know how to apply format to property " + (String)this.getId()));
                this.displayFormat = null;
            }
        }
        return this.displayFormat;
    }

    public Object readValue(Object object, @Nullable DBRProgressMonitor progressMonitor) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Format displayFormat;
        if (object == null) {
            return null;
        }
        if (this.getParent() != null && (object = this.getParent().getGroupObject(object, progressMonitor)) == null) {
            return null;
        }
        Method getter = this.getGetter();
        Object[] params = null;
        if (getter.getParameterCount() > 0) {
            params = new Object[getter.getParameterCount()];
        }
        if (this.isLazy() && params != null) {
            if (this.isLazy(object, true) && progressMonitor == null && !this.supportsPreview()) {
                throw new IllegalAccessException("Lazy property can't be read with null progress monitor");
            }
            params[0] = progressMonitor;
        }
        Object value = getter.invoke(object, params);
        if (this.valueRenderer != null) {
            value = this.valueRenderer.transform(object, value);
        }
        if (value instanceof Number && (displayFormat = this.getDisplayFormat()) != null) {
            return displayFormat.format(value);
        }
        return value;
    }

    public void writeValue(Object object, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.setter != null) {
            if (value == null) {
                Annotation[] valueAnnotations;
                Annotation[] annotationArray = valueAnnotations = this.setter.getParameterAnnotations()[0];
                int n = valueAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation va = annotationArray[n2];
                    if (va.annotationType() == NotNull.class) {
                        throw new IllegalArgumentException("Property '" + (String)this.getId() + "' can't be set into NULL");
                    }
                    ++n2;
                }
            }
            if (this.getParent() != null) {
                object = this.getParent().getGroupObject(object, (DBRProgressMonitor)new VoidProgressMonitor());
            }
            if (value == null) {
                Class<?> argType = this.setter.getParameterTypes()[0];
                if (argType == Integer.TYPE) {
                    value = 0;
                } else if (argType == Short.TYPE) {
                    value = (short)0;
                } else if (argType == Long.TYPE) {
                    value = 0L;
                } else if (argType == Float.TYPE) {
                    value = Float.valueOf(0.0f);
                } else if (argType == Double.TYPE) {
                    value = 0.0;
                } else if (argType == Boolean.TYPE) {
                    value = false;
                } else if (argType == Character.TYPE) {
                    value = Character.valueOf(' ');
                }
            }
        } else {
            throw new IllegalAccessError("No setter found for property " + (String)this.getId());
        }
        this.setter.invoke(object, value);
    }

    public String toString() {
        return String.valueOf(this.getId()) + " (" + this.propInfo.name() + ")";
    }

    public Class<?> getDataType() {
        return this.getGetter().getReturnType();
    }

    public boolean isRequired() {
        return false;
    }

    public Object getDefaultValue() {
        return null;
    }

    public boolean allowCustomValue() {
        if (this.propInfo.listProvider() != IPropertyValueListProvider.class) {
            try {
                return ((IPropertyValueListProvider)this.propInfo.listProvider().newInstance()).allowCustomValue();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return false;
    }

    public Object[] getPossibleValues(Object object) {
        if (this.propInfo.listProvider() != IPropertyValueListProvider.class) {
            try {
                return ((IPropertyValueListProvider)this.propInfo.listProvider().newInstance()).getPossibleValues(object);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        } else if (this.getDataType().isEnum()) {
            return this.getDataType().getEnumConstants();
        }
        return null;
    }

    public int hashCode() {
        return this.propInfo.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ObjectPropertyDescriptor && this.propInfo.equals((Object)((ObjectPropertyDescriptor)obj).propInfo) && CommonUtils.equalObjects((Object)this.getGetter(), (Object)((ObjectPropertyDescriptor)obj).getGetter());
    }

    /*
     * Unable to fully structure code
     */
    private String getLocalizedString(String string, String type, String defaultValue, boolean warnMissing) {
        if ("#".equals(string)) {
            block12: {
                getter = this.getGetter();
                propertyName = BeanUtils.getPropertyNameFromGetter((String)getter.getName());
                propOwner = getter.getDeclaringClass();
                bundle = FrameworkUtil.getBundle(propOwner);
                resourceBundle = Platform.getResourceBundle((Bundle)bundle);
                messageID = "meta." + propOwner.getName() + "." + propertyName + "." + type;
                result = null;
                try {
                    result = resourceBundle.getString(messageID);
                    break block12;
                }
                catch (Exception e) {
                    parent = getter.getDeclaringClass().getSuperclass();
                    ** while (parent != null && parent != Object.class)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        parentGetter = parent.getMethod(getter.getName(), getter.getParameterTypes());
                        parentOwner = parentGetter.getDeclaringClass();
                        parentBundle = FrameworkUtil.getBundle(parentOwner);
                        if (parentBundle != null && parentBundle != bundle) {
                            parentResourceBundle = Platform.getResourceBundle((Bundle)parentBundle);
                            messageID = "meta." + parentOwner.getName() + "." + propertyName + "." + type;
                            try {
                                result = parentResourceBundle.getString(messageID);
                                break;
                            }
                            catch (Exception var18_19) {}
                        }
                    }
                    catch (NoSuchMethodException var14_15) {
                        // empty catch block
                    }
                    parent = parent.getSuperclass();
                    continue;
                }
lbl31:
                // 2 sources

                if (result == null) {
                    if (type.equals("name")) {
                        ObjectPropertyDescriptor.log.debug((Object)("Resource '" + messageID + "' not found in bundle " + bundle.getSymbolicName()));
                    }
                    return defaultValue;
                }
            }
            if (!result.equals(messageID)) {
                return result;
            }
            return defaultValue;
        }
        return string;
    }
}

