/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.editors.IPersistentStorage;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class LocalFileStorage
implements IStorage,
IPersistentStorage,
IEncodedStorage {
    private final File file;
    private final String charset;

    public LocalFileStorage(File file, String charset) {
        this.file = file;
        this.charset = charset;
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
    }

    public IPath getFullPath() {
        return new Path(this.file.getAbsolutePath());
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return !this.file.canWrite();
    }

    @Override
    public void setContents(IProgressMonitor monitor, InputStream stream) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream os = new FileOutputStream(this.file);){
                ContentUtils.copyStreams((InputStream)stream, (long)0L, (OutputStream)os, (DBRProgressMonitor)RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public String getCharset() throws CoreException {
        return this.charset;
    }
}

