/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.xml;

import com.dbeaver.ee.runtime.ui.resultset.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.TextRenderer;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLRenderer
extends TextRenderer {
    private static final Log log = Log.getLog(XMLRenderer.class);
    private Color colorDefault;
    private Color colorTag;
    private Color colorAttributeName;
    private Color colorAttributeValue;
    private int x;
    private int y;

    public XMLRenderer(IDocumentFrame iDocumentFrame) {
        super(iDocumentFrame);
    }

    @Override
    public void paintDocument(@NotNull GC gC, @NotNull Canvas canvas, @NotNull Rectangle rectangle) {
        ColorRegistry colorRegistry = this.documentFrame.getController().getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorTag = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
        this.colorAttributeName = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.datatype.foreground");
        this.colorAttributeValue = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.string.foreground");
        this.colorDefault = canvas.getForeground();
        super.paintDocument(gC, canvas, rectangle);
    }

    @Override
    protected void renderNode(TextRenderer.TextProcessor textProcessor, Object object, int n, int n2) {
        this.x = n;
        this.y = n2;
        this.renderTag(textProcessor, (Element)object, 1);
    }

    private void renderTag(TextRenderer.TextProcessor textProcessor, Element element, int n) {
        Object object;
        if (textProcessor.isOutOfRange(this.y)) {
            return;
        }
        String string = element.getTagName();
        textProcessor.drawText("<" + string, this.x, this.y, this.colorTag);
        boolean bl = false;
        this.x += string.length() + 1;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = 0;
        while (n2 < namedNodeMap.getLength()) {
            object = (Attr)namedNodeMap.item(n2);
            String string2 = object.getValue();
            String string3 = object.getName();
            textProcessor.drawText(" " + string3 + "=", this.x, this.y, this.colorAttributeName);
            this.x += string3.length() + 2;
            String string4 = XMLUtils.escapeXml((CharSequence)CommonUtils.toString((Object)string2));
            textProcessor.drawText("\"" + string4 + "\"", this.x, this.y, this.colorAttributeValue);
            this.x += string4.length() + 2;
            ++n2;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (!bl) {
                textProcessor.drawText(">", this.x, this.y, this.colorTag);
                ++this.x;
            }
            bl = true;
            if (node instanceof Element) {
                this.renderTag(textProcessor, (Element)node, n + 1);
            } else if (node instanceof Text) {
                object = ((Text)node).getWholeText();
                this.renderText(textProcessor, (String)object, this.colorDefault);
            }
            node = node.getNextSibling();
        }
        if (!bl) {
            textProcessor.drawText("/>", this.x, this.y, this.colorTag);
        } else {
            textProcessor.drawText("</" + string + ">", this.x, this.y, this.colorTag);
        }
    }

    private void renderText(TextRenderer.TextProcessor textProcessor, String string, Color color) {
        int n = string.indexOf(10);
        if (n == -1) {
            textProcessor.drawText(string, this.x, this.y, color);
            this.x += string.length();
            return;
        }
        int n2 = 0;
        do {
            textProcessor.drawText(string.substring(n2, n), this.x, this.y, color);
            ++this.y;
            this.x = 0;
        } while ((n = string.indexOf(10, n2 = n + 1)) >= 0);
        textProcessor.drawText(string.substring(n2, string.length()), this.x, this.y, color);
        this.x = string.length() - n2;
    }
}

