/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.redis.exec;

import com.dbeaver.ent.redis.exec.RedisBaseResultSet;
import com.dbeaver.ent.redis.exec.RedisBaseStatement;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;

public class RedisResultSetList
extends RedisBaseResultSet {
    private static final Log log = Log.getLog(RedisResultSetList.class);
    public static final String ATTR_VALUE = "value";
    private final RedisBaseResultSet.OutputAttribute valueAttribute = new RedisBaseResultSet.OutputAttribute("value", 0, 1, DBPDataKind.OBJECT);
    private String keyName;
    private String curValue;

    public RedisResultSetList(RedisBaseStatement statement, String keyName) {
        super(statement);
        this.keyName = keyName;
    }

    public Object getAttributeValue(int index) throws DBCException {
        if (index == 0) {
            return this.curValue;
        }
        throw new DBCException("Bad attribute index '" + index + "'");
    }

    public Object getAttributeValue(String name) throws DBCException {
        if (name.equals(ATTR_VALUE)) {
            return this.curValue;
        }
        throw new DBCException("Attribute '" + name + "' not supported");
    }

    public boolean nextRow() throws DBCException {
        try {
            ++this.rowNumber;
            this.curValue = this.getSession().getJedis().lindex(this.keyName, this.statement.getOffset() + (long)this.rowNumber);
            return this.curValue != null;
        }
        catch (Exception e) {
            throw new DBCException("Error reading list element", (Throwable)e);
        }
    }

    public boolean moveTo(int position) throws DBCException {
        this.rowNumber = position;
        return true;
    }

    @Override
    protected void fillMetaData(List<DBCAttributeMetaData> attributes) {
        attributes.add(this.valueAttribute);
    }
}

