/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.qmdb.model;

import com.dbeaver.ent.qmdb.model.QMDBModel;
import com.dbeaver.ent.qmdb.model.QMDBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetFilterManager;
import org.jkiss.utils.CommonUtils;

public class QMDBEventListener
implements QMMetaListener,
IResultSetFilterManager {
    private static final Log log = Log.getLog(QMDBEventListener.class);
    private final QMDBModel model;
    private final PreparedStatement dbStatQueryRead;
    private final PreparedStatement dbStatQueryWrite;
    private final PreparedStatement dbStatEvent;
    private final PreparedStatement dbStatStatement;
    private Map<String, Long> connectionMap = new HashMap<String, Long>();

    public QMDBEventListener(QMDBModel model) throws SQLException {
        this.model = model;
        this.dbStatQueryRead = model.getConnection().prepareStatement("SELECT QUERY_ID,QUERY_TEXT FROM " + model.getTableName("QM_QUERY") + " WHERE QUERY_HASH=?");
        this.dbStatQueryWrite = model.getConnection().prepareStatement("INSERT INTO " + model.getTableName("QM_QUERY") + "(QUERY_HASH,QUERY_TEXT) VALUES(?,?)");
        this.dbStatEvent = model.getConnection().prepareStatement("INSERT INTO " + model.getTableName("QM_EVENT") + " (CONNECTION_ID,SOURCE_ID,EVENT_ACTION,EVENT_TYPE,EVENT_TIME) VALUES(?,?,?,?,?)");
        this.dbStatStatement = model.getConnection().prepareStatement("INSERT INTO " + model.getTableName("QM_STATEMENT") + " (STATEMENT_ID,STATEMENT_PURPOSE,QUERY_ID,ROW_COUNT,ERROR_CODE,ERROR_MESSAGE,EXECUTE_TIME,FETCH_TIME) VALUES(?,?,?,?,?,?,?,?)");
    }

    public void dispose() {
        try {
            if (this.dbStatQueryWrite != null) {
                this.dbStatQueryWrite.close();
            }
            if (this.dbStatQueryRead != null) {
                this.dbStatQueryRead.close();
            }
            if (this.dbStatEvent != null) {
                this.dbStatEvent.close();
            }
            if (this.dbStatStatement != null) {
                this.dbStatStatement.close();
            }
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    public synchronized void metaInfoChanged(@NotNull List<QMMetaEvent> events) {
        if (this.model.getConnection() == null) {
            return;
        }
        for (QMMetaEvent event : events) {
            try {
                this.processEvent(event);
            }
            catch (SQLException e) {
                log.debug((Object)"QMDB error", (Throwable)e);
            }
        }
    }

    @NotNull
    private static String makeConnectionKey(QMMSessionInfo sessionInfo) {
        return String.valueOf(sessionInfo.getContainerId()) + ":" + sessionInfo.getContextName();
    }

    private int getEventTypeId(QMMObject object) {
        Class<?> eventClass = object.getClass();
        if (eventClass == QMMSessionInfo.class) {
            return 1;
        }
        if (eventClass == QMMTransactionInfo.class) {
            return 2;
        }
        if (eventClass == QMMTransactionSavepointInfo.class) {
            return 3;
        }
        if (eventClass == QMMStatementInfo.class) {
            return 4;
        }
        if (eventClass == QMMStatementExecuteInfo.class) {
            return 5;
        }
        return -1;
    }

    private synchronized void processEvent(QMMetaEvent event) throws SQLException {
        if (event.getAction() == QMMetaEvent.Action.UPDATE) {
            return;
        }
        QMMObject object = event.getObject();
        if (object instanceof QMMSessionInfo) {
            if (event.getAction() == QMMetaEvent.Action.BEGIN) {
                this.createConnectionInfo((QMMSessionInfo)object);
            } else if (event.getAction() == QMMetaEvent.Action.END) {
                this.closeConnectionInfo((QMMSessionInfo)object);
            }
        } else if (object instanceof QMMTransactionInfo) {
            this.createTransactionInfo(event, (QMMTransactionInfo)object, event.getAction() == QMMetaEvent.Action.BEGIN);
        } else if (object instanceof QMMStatementExecuteInfo) {
            this.createStatementInfo(event, (QMMStatementExecuteInfo)object);
        }
    }

    private void createConnectionInfo(QMMSessionInfo sessionInfo) throws SQLException {
        Long runId = this.model.getRunId();
        String dsName = (String)JDBCUtils.executeQuery((Connection)this.model.getConnection(), (String)("SELECT NAME  FROM " + this.model.getTableName("QM_DATASOURCE") + " WHERE DATASOURCE_ID=?"), (Object[])new Object[]{sessionInfo.getContainerId()});
        if (dsName == null) {
            JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("INSERT INTO " + this.model.getTableName("QM_DATASOURCE") + " (DATASOURCE_ID,NAME,URL,DRIVER,UPDATE_TIME) VALUES(?,?,?,?,?)"), (Object[])new Object[]{sessionInfo.getContainerId(), sessionInfo.getContainerName(), CommonUtils.notEmpty((String)sessionInfo.getConnectionConfiguration().getUrl()), sessionInfo.getDriverId(), new Date()});
        } else {
            JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("UPDATE " + this.model.getTableName("QM_DATASOURCE") + " SET NAME=?,URL=?,DRIVER=?,UPDATE_TIME=? WHERE DATASOURCE_ID=?"), (Object[])new Object[]{sessionInfo.getContainerName(), CommonUtils.notEmpty((String)sessionInfo.getConnectionConfiguration().getUrl()), sessionInfo.getDriverId(), new Date(), sessionInfo.getContainerId()});
        }
        long connectionId = QMDBUtils.executeInsertAutoIncrement(this.model.getConnection(), "INSERT INTO " + this.model.getTableName("QM_CONNECTION") + " (RUN_ID,DATASOURCE_ID,CONTEXT_NAME,CONNECTION_USER,CONNECT_TIME) VALUES(?,?,?,?,?)", runId, sessionInfo.getContainerId(), CommonUtils.notEmpty((String)sessionInfo.getContextName()), CommonUtils.notEmpty((String)sessionInfo.getConnectionConfiguration().getUserName()), new Date());
        this.connectionMap.put(QMDBEventListener.makeConnectionKey(sessionInfo), connectionId);
    }

    private void closeConnectionInfo(QMMSessionInfo sessionInfo) throws SQLException {
        Long connectionId = this.connectionMap.get(QMDBEventListener.makeConnectionKey(sessionInfo));
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + sessionInfo.getContainerId() + " for close"));
            return;
        }
        JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("UPDATE " + this.model.getTableName("QM_CONNECTION") + " SET DISCONNECT_TIME=? WHERE CONNECTION_ID=?"), (Object[])new Object[]{new Date(), connectionId});
        this.connectionMap.remove(QMDBEventListener.makeConnectionKey(sessionInfo));
    }

    private long createEventInfo(QMMetaEvent event, QMMSessionInfo sessionInfo) throws SQLException {
        Long connectionId = this.connectionMap.get(QMDBEventListener.makeConnectionKey(sessionInfo));
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + sessionInfo.getContainerId() + " for event " + event.getAction()));
            return -1L;
        }
        this.dbStatEvent.setLong(1, connectionId);
        this.dbStatEvent.setNull(2, 12);
        this.dbStatEvent.setInt(3, event.getAction().ordinal());
        this.dbStatEvent.setInt(4, this.getEventTypeId(event.getObject()));
        this.dbStatEvent.setTimestamp(5, new Timestamp(event.getObject().getOpenTime()));
        this.dbStatEvent.execute();
        return QMDBUtils.getGeneratedKey(this.dbStatEvent);
    }

    private void createTransactionInfo(QMMetaEvent event, QMMTransactionInfo transactionInfo, boolean start) throws SQLException {
        this.createEventInfo(event, transactionInfo.getSession());
    }

    private void createStatementInfo(QMMetaEvent event, QMMStatementExecuteInfo executeInfo) throws SQLException {
        long eventId = this.createEventInfo(event, executeInfo.getStatement().getSession());
        long queryId = this.getQueryId(executeInfo.getQueryString());
        if (event.getAction() == QMMetaEvent.Action.END) {
            this.dbStatStatement.setLong(1, eventId);
            this.dbStatStatement.setInt(2, executeInfo.getStatement().getPurpose().ordinal());
            this.dbStatStatement.setLong(3, queryId);
            this.dbStatStatement.setLong(4, executeInfo.getRowCount());
            this.dbStatStatement.setInt(5, executeInfo.getErrorCode());
            if (CommonUtils.isEmpty((String)executeInfo.getErrorMessage())) {
                this.dbStatStatement.setNull(6, 12);
            } else {
                this.dbStatStatement.setString(6, executeInfo.getErrorMessage());
            }
            this.dbStatStatement.setInt(7, (int)(executeInfo.getCloseTime() - executeInfo.getOpenTime()));
            long fetchEndTime = executeInfo.getFetchEndTime();
            this.dbStatStatement.setInt(8, (int)(fetchEndTime > 0L ? fetchEndTime - executeInfo.getFetchBeginTime() : 0L));
            this.dbStatStatement.execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized long getQueryId(String query) throws SQLException {
        long hashCode;
        block10: {
            hashCode = QMDBUtils.getHashCode(query);
            this.dbStatQueryRead.setLong(1, hashCode);
            Throwable throwable = null;
            Object var5_5 = null;
            try {
                ResultSet dbResult;
                block9: {
                    dbResult = this.dbStatQueryRead.executeQuery();
                    finally {
                        if (dbResult.next()) break block9;
                    }
                    if (dbResult != null) {
                        dbResult.close();
                    }
                    break block10;
                }
                String storedText = dbResult.getString(2);
                if (storedText.equals(query)) {
                    return dbResult.getLong(1);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        this.dbStatQueryWrite.setLong(1, hashCode);
        this.dbStatQueryWrite.setString(2, query);
        this.dbStatQueryWrite.execute();
        return QMDBUtils.getGeneratedKey(this.dbStatQueryWrite);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public synchronized Collection<String> getQueryFilterHistory(@NotNull String query) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void saveQueryFilterValue(@NotNull String query, @NotNull String filterValue) throws DBException {
        try {
            long queryId = this.getQueryId(query);
            long filterHash = QMDBUtils.getHashCode(filterValue);
            Throwable throwable = null;
            Object var8_8 = null;
            try (PreparedStatement dbStat = this.model.getConnection().prepareStatement("MERGE INTO " + this.model.getTableName("QM_QUERY_FILTER") + " (QUERY_ID,FILTER_HASH,FILTER_TEXT) " + "KEY (QUERY_ID,FILTER_HASH) VALUES(?,?,?)");){
                dbStat.setLong(1, queryId);
                dbStat.setLong(2, filterHash);
                dbStat.setString(3, filterValue);
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving filter history", (Throwable)e);
        }
    }

    public synchronized void deleteQueryFilterValue(@NotNull String query, String filterValue) throws DBException {
        try {
            long queryId = this.getQueryId(query);
            long filterHash = QMDBUtils.getHashCode(filterValue);
            Throwable throwable = null;
            Object var8_8 = null;
            try (PreparedStatement dbStat = this.model.getConnection().prepareStatement("DELETE FROM " + this.model.getTableName("QM_QUERY_FILTER") + " WHERE QUERY_ID=? AND FILTER_HASH=?");){
                dbStat.setLong(1, queryId);
                dbStat.setLong(2, filterHash);
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error deleting filter history", (Throwable)e);
        }
    }
}

