/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.views;

import com.dbeaver.ent.mongodb.Activator;
import com.dbeaver.ent.mongodb.MongoUtils;
import com.mongodb.MongoCredential;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class MongoConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    public static final String DATA_ITEM_PASSWORD = "password";
    public static final String PASSWORD_MASK = "***";
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/mongodb_logo.png");
    private Composite settingsGroup;
    private Table seedsTable;
    private Text databaseNameText;
    private Text replicaSetNameText;
    private Combo mechanismCombo;
    private Table authTable;
    private boolean activated;
    private Composite credGroup;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group seedsGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)"Address", (int)2, (int)768, (int)-1);
        Composite seedsComposite = UIUtils.createPlaceholder((Composite)seedsGroup, (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        seedsComposite.setLayoutData((Object)gd);
        this.createSeedsTable(seedsComposite);
        this.databaseNameText = UIUtils.createLabelText((Composite)seedsGroup, (String)"Database", (String)"");
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 270;
        this.databaseNameText.setLayoutData((Object)gd);
        this.replicaSetNameText = UIUtils.createLabelText((Composite)seedsGroup, (String)"Replica Set", (String)"");
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 270;
        this.replicaSetNameText.setLayoutData((Object)gd);
        Group authGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)"Credentials", (int)2, (int)768, (int)-1);
        this.mechanismCombo = UIUtils.createLabelCombo((Composite)authGroup, (String)"Mechanism", (int)12);
        this.mechanismCombo.add("NONE");
        this.mechanismCombo.add(MongoCredential.SCRAM_SHA_1_MECHANISM);
        this.mechanismCombo.add(MongoCredential.MONGODB_CR_MECHANISM);
        this.mechanismCombo.add(MongoCredential.PLAIN_MECHANISM);
        this.mechanismCombo.add(MongoCredential.GSSAPI_MECHANISM);
        this.mechanismCombo.add(MongoCredential.MONGODB_X509_MECHANISM);
        this.mechanismCombo.setLayoutData((Object)new GridData(32));
        this.mechanismCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoConnectionPage.this.reEnableSecurity();
            }
        });
        this.credGroup = UIUtils.createPlaceholder((Composite)authGroup, (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.credGroup.setLayoutData((Object)gd);
        this.createCredentialsTable(this.credGroup);
        return this.settingsGroup;
    }

    private void createSeedsTable(Composite seedGroup) {
        this.seedsTable = new Table(seedGroup, 68100);
        this.seedsTable.setHeaderVisible(true);
        this.seedsTable.setLinesVisible(true);
        GridData gd = new GridData(768);
        gd.minimumHeight = 50;
        gd.heightHint = this.seedsTable.getItemHeight() * 4;
        this.seedsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.seedsTable, (int)16384, (String)"Host");
        UIUtils.createTableColumn((Table)this.seedsTable, (int)16384, (String)"Port");
        this.seedsTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                MongoConnectionPage.this.seedsTable.removeListener(11, (Listener)this);
                UIUtils.packColumns((Table)MongoConnectionPage.this.seedsTable, (boolean)true);
            }
        });
        final CustomTableEditor tableEditor = new CustomTableEditor(this.seedsTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                Text text = new Text((Composite)table, 2048);
                text.setText(item.getText(index));
                text.selectAll();
                return text;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(index, ((Text)control).getText());
            }
        };
        Composite btnGroup = UIUtils.createPlaceholder((Composite)seedGroup, (int)1);
        UIUtils.createPushButton((Composite)btnGroup, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(MongoConnectionPage.this.seedsTable, 0);
                item.setText(0, "localhost");
                item.setText(1, MongoConnectionPage.this.site.getDriver().getDefaultPort());
                item.setText(2, "local");
                MongoConnectionPage.this.seedsTable.setSelection(item);
                tableEditor.showEditor(item);
                if (MongoConnectionPage.this.activated) {
                    MongoConnectionPage.this.saveAndUpdate();
                }
            }
        });
        UIUtils.createPushButton((Composite)btnGroup, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = MongoConnectionPage.this.seedsTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.dispose();
                    ++n2;
                }
            }
        });
    }

    private void createCredentialsTable(Composite credGroup) {
        this.authTable = new Table(credGroup, 68100);
        this.authTable.setHeaderVisible(true);
        this.authTable.setLinesVisible(true);
        GridData gd = new GridData(768);
        gd.minimumHeight = 50;
        gd.heightHint = this.authTable.getItemHeight() * 3;
        this.authTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.authTable, (int)16384, (String)"User");
        UIUtils.createTableColumn((Table)this.authTable, (int)16384, (String)"Database");
        UIUtils.createTableColumn((Table)this.authTable, (int)16384, (String)"Password");
        this.authTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                MongoConnectionPage.this.authTable.removeListener(11, (Listener)this);
                UIUtils.packColumns((Table)MongoConnectionPage.this.authTable, (boolean)true);
            }
        });
        final CustomTableEditor tableEditor = new CustomTableEditor(this.authTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                Text text = new Text((Composite)table, 0x800 | (index == 2 ? 0x400000 : 0));
                if (index == 2) {
                    String password = (String)item.getData(MongoConnectionPage.DATA_ITEM_PASSWORD);
                    text.setText(password);
                } else {
                    text.setText(item.getText(index));
                }
                text.selectAll();
                return text;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                String text = ((Text)control).getText();
                if (index == 2) {
                    item.setData(MongoConnectionPage.DATA_ITEM_PASSWORD, (Object)text);
                    text = MongoConnectionPage.PASSWORD_MASK;
                }
                item.setText(index, text);
            }
        };
        Composite authCtrl = UIUtils.createPlaceholder((Composite)credGroup, (int)1);
        UIUtils.createPushButton((Composite)authCtrl, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(MongoConnectionPage.this.authTable, 0);
                item.setText(0, "user");
                item.setText(1, "local");
                item.setText(2, "");
                item.setData(MongoConnectionPage.DATA_ITEM_PASSWORD, (Object)"");
                MongoConnectionPage.this.authTable.setSelection(item);
                tableEditor.showEditor(item);
            }
        });
        UIUtils.createPushButton((Composite)authCtrl, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = MongoConnectionPage.this.authTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.dispose();
                    ++n2;
                }
            }
        });
    }

    private void reEnableSecurity() {
        boolean enabled = this.mechanismCombo.getSelectionIndex() > 0;
        Control[] controlArray = this.credGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            UIUtils.enableWithChildren((Control)ctrl, (boolean)enabled);
            ++n2;
        }
    }

    public boolean isComplete() {
        return this.seedsTable.getItemCount() > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void loadSettings() {
        String auth;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.seedsTable != null && this.seedsTable.getItemCount() == 0) {
            String seed;
            String defPort;
            String defHost;
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                defHost = "localhost";
                defPort = this.site.getDriver().getDefaultPort();
            } else {
                defHost = connectionInfo.getHostName();
                defPort = connectionInfo.getHostPort();
            }
            TableItem item = new TableItem(this.seedsTable, 0);
            item.setText(0, defHost);
            item.setText(1, defPort);
            int i = 0;
            while ((seed = connectionInfo.getProviderProperty("seed" + i)) != null) {
                String[] seedTokens = MongoUtils.extractSeedInfo(seed);
                TableItem item2 = new TableItem(this.seedsTable, 0);
                item2.setText(0, seedTokens[0]);
                item2.setText(1, seedTokens[1]);
                ++i;
            }
        }
        if (CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            this.databaseNameText.setText("local");
        } else {
            this.databaseNameText.setText(connectionInfo.getDatabaseName());
        }
        String replicaSet = connectionInfo.getProviderProperty("replicaSet");
        if (replicaSet != null) {
            this.replicaSetNameText.setText(replicaSet);
        }
        if (this.mechanismCombo != null) {
            String mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
            if (mechanism == null) {
                mechanism = "NONE";
            }
            this.mechanismCombo.setText(mechanism);
        }
        this.authTable.removeAll();
        int i = 0;
        while ((auth = connectionInfo.getProviderProperty("@dbeaver-auth@" + i)) != null) {
            String[] authTokens = MongoUtils.extractAuthInfo(auth);
            TableItem item = new TableItem(this.authTable, 0);
            item.setText(0, authTokens[0]);
            item.setText(1, authTokens[1]);
            item.setText(2, PASSWORD_MASK);
            item.setData(DATA_ITEM_PASSWORD, (Object)authTokens[2]);
            ++i;
        }
        this.reEnableSecurity();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        Iterator prop = providerProperties.entrySet().iterator();
        while (prop.hasNext()) {
            String propName = (String)prop.next().getKey();
            if (!propName.startsWith("seed") && !propName.startsWith("@dbeaver-auth@")) continue;
            prop.remove();
        }
        int itemIndex = 0;
        TableItem[] tableItemArray = this.seedsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem seedItem = tableItemArray[n2];
            if (itemIndex == 0) {
                connectionInfo.setHostName(seedItem.getText(0));
                connectionInfo.setHostPort(seedItem.getText(1));
            } else {
                connectionInfo.setProviderProperty("seed" + (itemIndex - 1), MongoUtils.saveSeedInfo(seedItem.getText(0), seedItem.getText(1)));
            }
            ++itemIndex;
            ++n2;
        }
        connectionInfo.setDatabaseName(this.databaseNameText.getText());
        connectionInfo.setProviderProperty("replicaSet", this.replicaSetNameText.getText());
        int authIndex = 0;
        TableItem[] tableItemArray2 = this.authTable.getItems();
        int n3 = tableItemArray2.length;
        n = 0;
        while (n < n3) {
            TableItem item = tableItemArray2[n];
            String userName = item.getText(0);
            String userDB = item.getText(1);
            String userPassword = (String)item.getData(DATA_ITEM_PASSWORD);
            if (!CommonUtils.isEmpty((String)userName)) {
                connectionInfo.setProviderProperty("@dbeaver-auth@" + authIndex++, MongoUtils.saveAuthInfo(userName, userDB, userPassword));
            }
            ++n;
        }
        if (this.mechanismCombo != null) {
            connectionInfo.setProviderProperty("@dbeaver-mongo-cred-mechanism@", this.mechanismCombo.getText());
        }
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

