/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.views;

import com.dbeaver.ent.cassandra.Activator;
import com.dbeaver.ent.cassandra.views.CasSocketSettingsPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class CasConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/cassandra_logo.png");
    private Text hostText;
    private Text portText;
    private Text keyspaceText;
    private Text userNameText;
    private Text passwordText;
    private Button useSslButton;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.setControl((Control)this.createGeneralTab(composite));
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CasConnectionPage.this.activated) {
                    CasConnectionPage.this.saveAndUpdate();
                }
            }
        };
        Composite configGroup = UIUtils.createPlaceholder((Composite)parent, (int)1);
        configGroup.setLayoutData((Object)new GridData(1808));
        Group settingsGroup = UIUtils.createControlGroup((Composite)configGroup, (String)"Connection Setting", (int)4, (int)768, (int)0);
        Label hostLabel = new Label((Composite)settingsGroup, 0);
        hostLabel.setText("Host");
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text((Composite)settingsGroup, 2048);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        Label portLabel = new Label((Composite)settingsGroup, 0);
        portLabel.setText("Port");
        portLabel.setLayoutData((Object)new GridData(128));
        this.portText = new Text((Composite)settingsGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        Label dbLabel = new Label((Composite)settingsGroup, 0);
        dbLabel.setText("Keyspace");
        dbLabel.setLayoutData((Object)new GridData(128));
        this.keyspaceText = new Text((Composite)settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 270;
        gd.horizontalSpan = 3;
        this.keyspaceText.setLayoutData((Object)gd);
        this.keyspaceText.addModifyListener(textListener);
        Label userNameLabel = new Label((Composite)settingsGroup, 0);
        userNameLabel.setText("User");
        userNameLabel.setLayoutData((Object)new GridData(128));
        this.userNameText = new Text((Composite)settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.userNameText.setLayoutData((Object)gd);
        this.userNameText.addModifyListener(textListener);
        Control emptyLabel = this.createEmptyLabel((Composite)settingsGroup, 2);
        Label passwordLabel = new Label((Composite)settingsGroup, 0);
        passwordLabel.setText("Password");
        passwordLabel.setLayoutData((Object)new GridData(128));
        this.passwordText = new Text((Composite)settingsGroup, 0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        Group sslGroup = UIUtils.createControlGroup((Composite)configGroup, (String)"SSL", (int)2, (int)768, (int)0);
        this.useSslButton = UIUtils.createCheckbox((Composite)sslGroup, (String)"Use SSL", (String)"Enable SSL connection (server must be configured to support SSL)", (boolean)true, (int)1);
        Link sslLink = new Link((Composite)sslGroup, 0);
        sslLink.setText("<a>SSL settings</a>");
        sslLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CasConnectionPage.this.site.openSettingsPage("networkHandlersSettings");
            }
        });
        GridData gd2 = new GridData(32);
        sslLink.setLayoutData((Object)gd2);
        this.createDriverPanel(configGroup);
        return configGroup;
    }

    private Control createEmptyLabel(Composite parent, int verticalSpan) {
        Label emptyLabel = new Label(parent, 0);
        GridData gd = new GridData(128);
        gd.horizontalSpan = 2;
        gd.verticalSpan = verticalSpan;
        gd.widthHint = 0;
        emptyLabel.setLayoutData((Object)gd);
        return emptyLabel;
    }

    public boolean isComplete() {
        return !this.hostText.getText().isEmpty() && !this.keyspaceText.getText().isEmpty();
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.keyspaceText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                this.keyspaceText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            } else {
                this.keyspaceText.setText("system");
            }
        }
        if (this.userNameText != null) {
            this.userNameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        boolean useSSL = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-ssl@"));
        this.useSslButton.setSelection(useSSL);
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.keyspaceText != null) {
            connectionInfo.setDatabaseName(this.keyspaceText.getText().trim());
        }
        if (this.userNameText != null) {
            connectionInfo.setUserName(this.userNameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        connectionInfo.setProviderProperty("@dbeaver-ssl@", String.valueOf(this.useSslButton.getSelection()));
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[]{new CasSocketSettingsPage()};
    }
}

