/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.data;

import com.datastax.driver.core.DataType;
import com.dbeaver.ent.cassandra.CasUtils;
import com.dbeaver.ent.cassandra.model.CasDataSource;
import com.dbeaver.ent.cassandra.model.CasDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasSetValue
implements DBDCollection,
DBDValueCloneable {
    @NotNull
    private final CasDataSource dataSource;
    private List<Object> contents;
    @NotNull
    private DataType type;
    @NotNull
    private CasDataType componentType;
    private boolean modified;

    public CasSetValue(@NotNull CasDataSource dataSource, Collection<Object> contents, @NotNull DataType type) {
        this.dataSource = dataSource;
        if (contents != null) {
            this.contents = new ArrayList<Object>(contents.size());
            for (Object object : contents) {
                this.contents.add(CasUtils.wrapValue(dataSource, object));
            }
        }
        this.type = type;
        List typeArguments = type.getTypeArguments();
        this.componentType = typeArguments.size() == 1 ? dataSource.getLocalDataType(((DataType)typeArguments.get(0)).getName().toString()) : dataSource.getLocalDataType(type.getName().toString());
    }

    public CasSetValue(@NotNull CasDataSource dataSource, @NotNull CasSetValue copy) {
        this(dataSource, copy.contents, copy.type);
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.componentType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)this.componentType);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new CasSetValue(this.dataSource, this.contents, this.type);
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        DBDValueHandler cvh = this.getComponentValueHandler();
        StringBuilder str = new StringBuilder(this.contents.size() * 32);
        str.append("{");
        int i = 0;
        while (i < this.contents.size()) {
            Object item = this.contents.get(i);
            if (i > 0) {
                str.append(',');
            }
            String itemString = cvh.getValueDisplayString((DBSTypedObject)this.componentType, item, DBDDisplayFormat.NATIVE);
            SQLUtils.appendValue((StringBuilder)str, (DBSTypedObject)this.componentType, (Object)itemString);
            ++i;
        }
        str.append("}");
        return str.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public Object getItem(int index) {
        return this.contents.get(index);
    }

    public void setItem(int index, Object value) {
        this.contents.set(index, value);
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        if (this.contents == null) {
            this.contents = new ArrayList<Object>();
        } else {
            this.contents.clear();
        }
        Collections.addAll(this.contents, contents);
        this.modified = true;
    }

    public Set<Object> makeSet() {
        if (this.contents == null) {
            return null;
        }
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(this.contents.size());
        for (Object item : this.contents) {
            set.add(CasUtils.unwrapValue(this.dataSource, item));
        }
        return set;
    }
}

