/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.xpath.JXPathContext;
import oracle.xml.xpath.JXPathExpression;
import oracle.xml.xpath.XMLPathTable;
import oracle.xml.xpath.XPathCompileEventsHandler;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XSLExprBase;
import org.xml.sax.InputSource;

public class JXPath
implements XPath {
    NamespaceContext nsContext;
    XPathVariableResolver varResolver;
    XPathFunctionResolver funcResolver;
    XMLSchema schema;
    boolean version20 = false;
    boolean secure;
    boolean createNode;
    boolean enableException;
    XPathCompileEventsHandler xpcehandler;
    XMLPathTable pathtable;

    JXPath(XPathVariableResolver xPathVariableResolver, XPathFunctionResolver xPathFunctionResolver, boolean bl) {
        this.varResolver = xPathVariableResolver;
        this.funcResolver = xPathFunctionResolver;
        this.secure = bl;
    }

    @Override
    public void reset() {
        this.pathtable = null;
        this.xpcehandler = null;
    }

    public void setPathTable(XMLPathTable xMLPathTable) {
        this.pathtable = xMLPathTable;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            throw new NullPointerException();
        }
        this.varResolver = xPathVariableResolver;
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this.varResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            throw new NullPointerException();
        }
        this.funcResolver = xPathFunctionResolver;
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.funcResolver;
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        if (namespaceContext == null) {
            throw new NullPointerException();
        }
        this.nsContext = namespaceContext;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    public void setXMLSchema(XMLSchema xMLSchema) {
        if (xMLSchema == null) {
            throw new NullPointerException();
        }
        this.schema = xMLSchema;
    }

    void setVersion20(boolean bl) {
        this.version20 = bl;
    }

    public void setXPathCompileEventsHandler(XPathCompileEventsHandler xPathCompileEventsHandler) {
        this.xpcehandler = xPathCompileEventsHandler;
    }

    @Override
    public XPathExpression compile(String string) throws XPathExpressionException {
        Object object;
        if (string == null) {
            throw new NullPointerException();
        }
        XSLExprBase xSLExprBase = null;
        try {
            object = null;
            object = new JXPathContext(this.nsContext, this.secure ? null : this.funcResolver);
            ((JXPathContext)object).setXMLSchema(this.schema);
            if (this.xpcehandler != null) {
                ((JXPathContext)object).setXPathCompileEventsHandler(this.xpcehandler);
            }
            if (this.pathtable != null) {
                ((JXPathContext)object).setXMLPathTable(this.pathtable);
            }
            xSLExprBase = XSLExprBase.createExpression(string, (NSResolver)object, this.version20 ? 20 : 10);
        }
        catch (Exception exception) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(exception.getMessage());
            xPathExpressionException.initCause(exception);
            throw xPathExpressionException;
        }
        object = new JXPathExpression(xSLExprBase, this.varResolver, string);
        ((JXPathExpression)object).setXMLSchema(this.schema);
        ((JXPathExpression)object).setCreateNode(this.createNode);
        ((JXPathExpression)object).setEnableException(this.enableException);
        if (this.enableException && !this.createNode) {
            try {
                ((JXPathExpression)object).validateXPathExpression();
            }
            catch (XPathException xPathException) {
                XPathExpressionException xPathExpressionException = new XPathExpressionException(xPathException.getMessage());
                xPathExpressionException.initCause(xPathException);
                throw xPathExpressionException;
            }
        }
        if (this.createNode) {
            try {
                ((JXPathExpression)object).validateCreateXPathExpression(xSLExprBase);
            }
            catch (XPathException xPathException) {
                XPathExpressionException xPathExpressionException = new XPathExpressionException(xPathException.getMessage());
                xPathExpressionException.initCause(xPathException);
                throw xPathExpressionException;
            }
        }
        return object;
    }

    @Override
    public Object evaluate(String string, Object object, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object, qName);
    }

    @Override
    public String evaluate(String string, Object object) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object);
    }

    @Override
    public Object evaluate(String string, InputSource inputSource, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource, qName);
    }

    @Override
    public String evaluate(String string, InputSource inputSource) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource);
    }

    void setCreateNode(boolean bl) {
        this.createNode = bl;
    }

    boolean getCreateNode() {
        return this.createNode;
    }

    void setEnableException(boolean bl) {
        this.enableException = bl;
    }

    boolean getEnableException() {
        return this.enableException;
    }
}

