/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mockdata.model.MockValueGenerator;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.registry.datatype.DataTypeAbstractDescriptor;

public class MockGeneratorDescriptor
extends DataTypeAbstractDescriptor<MockValueGenerator> {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.mockGenerator";
    public static final String TAG_PRESET = "preset";
    private final String label;
    private final String description;
    private final String link;
    private final String url;
    private final DBPImage icon;
    private List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
    private List<Preset> presets = new ArrayList<Preset>();

    public MockGeneratorDescriptor(IConfigurationElement config) {
        super(config, MockValueGenerator.class);
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.link = config.getAttribute("link");
        this.url = config.getAttribute("url");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("propertyGroup");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prop = iConfigurationElementArray[n2];
            this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
            ++n2;
        }
        iConfigurationElementArray = config.getChildren(TAG_PRESET);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement preset = iConfigurationElementArray[n2];
            this.presets.add(new Preset(preset.getAttribute("id"), preset.getAttribute("label"), preset.getAttribute("mnemonics"), PropertyDescriptor.extractProperties((IConfigurationElement)preset)));
            ++n2;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String getLink() {
        return this.link;
    }

    public String getUrl() {
        return this.url;
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public DBPPropertyDescriptor getProperty(Object id) {
        for (DBPPropertyDescriptor descriptor : this.getProperties()) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public MockValueGenerator createGenerator() {
        return (MockValueGenerator)this.createInstance();
    }

    public List<Preset> getPresets() {
        return this.presets;
    }

    public static class Preset {
        private final String id;
        private final String label;
        private final String mnemonics;
        private final List<DBPPropertyDescriptor> properties;

        public Preset(String id, String label, String mnemonics, List<DBPPropertyDescriptor> properties) {
            this.id = id;
            this.label = label;
            this.mnemonics = mnemonics;
            this.properties = properties;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getMnemonics() {
            return this.mnemonics;
        }

        public List<DBPPropertyDescriptor> getProperties() {
            return this.properties;
        }
    }
}

