/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.mockdata.MockDataGenerateTool;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCommandHandler;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class MockDataHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(MockDataHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<DBSDataContainer> selectedObjects;
        if (event.getCommand().getId().endsWith("button")) {
            IResultSetController resultSet = ResultSetCommandHandler.getActiveResultSet((IWorkbenchPart)HandlerUtil.getActivePart((ExecutionEvent)event));
            if (resultSet == null) {
                DBeaverUI.getInstance().showError("Mock Data", "No active results viewer");
                return null;
            }
            DBSDataContainer dataContainer = resultSet.getDataContainer();
            if (dataContainer == null || dataContainer.getDataSource() == null) {
                DBeaverUI.getInstance().showError("Mock Data", "Not connected to a database");
                return null;
            }
            if (!(dataContainer instanceof DBSDataManipulator)) {
                DBeaverUI.getInstance().showError("Mock Data", "Mock Data can be generated for a table only");
                return null;
            }
            selectedObjects = new ArrayList<DBSDataContainer>();
            selectedObjects.add(dataContainer);
        } else {
            selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        }
        MockDataGenerateTool mockDataGenerator = new MockDataGenerateTool();
        try {
            mockDataGenerator.execute(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), null, (Collection<DBSObject>)selectedObjects);
        }
        catch (DBException e) {
            log.error((Object)"Error launching the Mock Data Generator", (Throwable)e);
        }
        return null;
    }
}

