/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.generator;

import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mockdata.MockDataUtils;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractMockValueGenerator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class NumericSequenceGenerator
extends AbstractMockValueGenerator {
    private long start = 0L;
    private long step = 0L;
    private boolean reverse = false;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        Boolean reverse;
        Long step;
        super.init(container, attribute, properties);
        Long start = (Long)properties.get("start");
        if (start != null) {
            this.start = start;
        }
        if ((step = (Long)properties.get("step")) != null) {
            this.step = step;
        }
        if ((reverse = (Boolean)properties.get("reverse")) != null) {
            this.reverse = reverse;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        long value = this.start;
        this.start = this.reverse ? (this.start -= this.step) : (this.start += this.step);
        Integer precision = this.attribute.getPrecision();
        if (precision == null || precision < MockDataUtils.INTEGER_PRECISION) {
            return (int)value;
        }
        if (precision < MockDataUtils.BYTE_PRECISION) {
            return (byte)value;
        }
        if (precision < MockDataUtils.SHORT_PRECISION) {
            return (short)value;
        }
        if (precision < MockDataUtils.LONG_PRECISION) {
            return new Long(value);
        }
        return value;
    }
}

