/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.generator;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mockdata.model.MockValueGenerator;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public abstract class AbstractMockValueGenerator
implements MockValueGenerator {
    public static final int UNIQUE_VALUES_SET_SIZE = 1000000;
    public static final int UNIQUE_VALUE_GEN_ATTEMPTS = 100;
    protected DBSEntity dbsEntity;
    protected DBSAttributeBase attribute;
    protected Random random = new Random();
    protected int nullsPersent = 10;
    private boolean isFirstRun = true;
    private boolean isUnique;
    private Set<Object> uniqueValues;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        this.dbsEntity = (DBSEntity)container;
        this.attribute = attribute;
        if (attribute.isRequired()) {
            this.nullsPersent = 0;
        } else if (properties.get("nulls") != null) {
            this.nullsPersent = (Integer)properties.get("nulls");
        }
        if (this.nullsPersent > 100) {
            this.nullsPersent = 100;
        } else if (this.nullsPersent < 0) {
            this.nullsPersent = 0;
        }
    }

    @Override
    public void nextRow() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object generateValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isFirstRun) {
            this.isFirstRun = false;
            this.isUnique = DBUtils.checkUnique((DBRProgressMonitor)monitor, (DBSEntity)this.dbsEntity, (DBSAttributeBase)this.attribute);
            if (this.isUnique && this.attribute instanceof DBSAttributeEnumerable) {
                this.uniqueValues = new HashSet<Object>();
                Collection<DBDLabelValuePair> valuePairs = this.readColumnValues(monitor, this.dbsEntity.getDataSource(), (DBSAttributeEnumerable)this.attribute, 1000000);
                for (DBDLabelValuePair pair : valuePairs) {
                    this.uniqueValues.add(pair.getValue());
                }
            }
        }
        if (this.isUnique) {
            int attempts = 0;
            Object value = null;
            while (value == null || this.uniqueValues.contains(value)) {
                if (attempts > 100) {
                    throw new DBException("\n      Can't generate appropriate unique value for the '" + this.attribute.getName() + "' <" + this.attribute.getFullTypeName() + "> attribute.\n" + "      Try to change the generator or its parameters.\n");
                }
                if (monitor.isCanceled()) {
                    return null;
                }
                value = this.generateOneValue(monitor);
                ++attempts;
            }
            this.uniqueValues.add(value);
            return value;
        }
        return this.generateOneValue(monitor);
    }

    protected abstract Object generateOneValue(DBRProgressMonitor var1) throws DBException, IOException;

    protected boolean isGenerateNULL() {
        return this.nullsPersent > 0 && (this.nullsPersent == 100 || this.random.nextInt(100) <= this.nullsPersent);
    }

    protected Collection<DBDLabelValuePair> readColumnValues(DBRProgressMonitor monitor, DBPDataSource dataSource, DBSAttributeEnumerable column, int number) throws DBException {
        DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Read value enumeration");
        return column.getValueEnumeration(session, null, number);
    }
}

