/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.mockdata.MockDataExecuteWizard;
import org.jkiss.dbeaver.ext.mockdata.model.MockGeneratorDescriptor;
import org.jkiss.dbeaver.ext.mockdata.model.MockGeneratorRegistry;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class MockDataSettings {
    public static final String FK_GENERATOR_ID = "fkGenerator";
    public static final String PROP_REMOVE_OLD_DATA = "removeOldData";
    public static final String PROP_ROWS_NUMBER = "rowsNumber";
    public static final String KEY_SELECTED_ATTRIBUTE = "selectedAttribute";
    public static final String KEY_SELECTED_GENERATOR = "selectedGenerator";
    public static final String KEY_PRESET_ID = "presetId";
    public static final String KEY_GENERATOR_SECTION = "GENERATOR_SECTION";
    private DBSEntity entity;
    private Collection<DBSAttributeBase> attributes;
    private boolean removeOldData;
    private long rowsNumber = 1000L;
    private String selectedAttribute;
    private Map<String, MockGeneratorDescriptor> generatorDescriptors = new HashMap<String, MockGeneratorDescriptor>();
    private Map<String, AttributeGeneratorProperties> attributeGenerators = new HashMap<String, AttributeGeneratorProperties>();

    public void init(MockDataExecuteWizard wizard) throws DBException {
        List databaseObjects = wizard.getDatabaseObjects();
        final DBSDataManipulator dataManipulator = (DBSDataManipulator)databaseObjects.iterator().next();
        this.entity = (DBSEntity)dataManipulator;
        this.attributes = new ArrayList<DBSAttributeBase>();
        try {
            DBeaverUI.run((IRunnableContext)wizard.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        MockDataSettings.this.attributes.addAll(DBUtils.getRealAttributes((Collection)MockDataSettings.this.entity.getAttributes(monitor)));
                        MockGeneratorRegistry generatorRegistry = MockGeneratorRegistry.getInstance();
                        for (DBSAttributeBase attribute : MockDataSettings.this.attributes) {
                            AttributeGeneratorProperties generatorProperties = new AttributeGeneratorProperties(attribute);
                            MockDataSettings.this.attributeGenerators.put(attribute.getName(), generatorProperties);
                            List attributeReferrers = DBUtils.getAttributeReferrers((DBRProgressMonitor)monitor, (DBSEntityAttribute)((DBSEntityAttribute)attribute));
                            if (!CommonUtils.isEmpty((Collection)attributeReferrers)) {
                                MockGeneratorDescriptor generator = generatorRegistry.getGenerator(MockDataSettings.FK_GENERATOR_ID);
                                MockDataSettings.this.putGenerator(generatorProperties, generator);
                                continue;
                            }
                            List<MockGeneratorDescriptor> generators = generatorRegistry.findAllGenerators(dataManipulator.getDataSource(), (DBSTypedObject)attribute);
                            for (MockGeneratorDescriptor generator : generators) {
                                MockDataSettings.this.putGenerator(generatorProperties, generator);
                            }
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError("Transfer init failed", "Can't start data transfer", e.getTargetException());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public DBSEntity getEntity() {
        return this.entity;
    }

    public Collection<DBSAttributeBase> getAttributes() {
        return this.attributes;
    }

    public String getSelectedAttribute() {
        return this.selectedAttribute;
    }

    public void setSelectedAttribute(String selectedAttribute) {
        this.selectedAttribute = selectedAttribute;
    }

    private void putGenerator(AttributeGeneratorProperties generatorProperties, MockGeneratorDescriptor generator) {
        this.generatorDescriptors.put(generator.getId(), generator);
        generatorProperties.putGeneratorPropertySource(generator.getId(), new PropertySourceCustom(generator.getProperties(), null));
    }

    public MockGeneratorDescriptor getGeneratorDescriptor(String generatorId) {
        return this.generatorDescriptors.get(generatorId);
    }

    public MockGeneratorDescriptor findGeneratorForName(DBSAttributeBase attribute, String generatorName) {
        AttributeGeneratorProperties attributeGeneratorProperties = this.attributeGenerators.get(attribute.getName());
        for (String generatorId : attributeGeneratorProperties.getGenerators()) {
            MockGeneratorDescriptor generatorDescriptor = this.generatorDescriptors.get(generatorId);
            if (!generatorName.equals(generatorDescriptor.getLabel())) continue;
            return generatorDescriptor;
        }
        return null;
    }

    public boolean isRemoveOldData() {
        return this.removeOldData;
    }

    public void setRemoveOldData(boolean removeOldData) {
        this.removeOldData = removeOldData;
    }

    public long getRowsNumber() {
        return this.rowsNumber;
    }

    public void setRowsNumber(long rowsNumber) {
        this.rowsNumber = rowsNumber;
    }

    public Map<String, AttributeGeneratorProperties> getAttributeGenerators() {
        return this.attributeGenerators;
    }

    public AttributeGeneratorProperties getAttributeGeneratorProperties(DBSAttributeBase attribute) {
        return this.attributeGenerators.get(attribute.getName());
    }

    public void loadFrom(IDialogSettings dialogSettings) {
        this.removeOldData = dialogSettings.getBoolean(PROP_REMOVE_OLD_DATA);
        try {
            this.rowsNumber = dialogSettings.getInt(PROP_ROWS_NUMBER);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.selectedAttribute = dialogSettings.get(KEY_SELECTED_ATTRIBUTE);
        VoidProgressMonitor voidProgressMonitor = new VoidProgressMonitor();
        IDialogSettings tableSection = UIUtils.getSettingsSection((IDialogSettings)dialogSettings, (String)this.entity.getName());
        for (Map.Entry<String, AttributeGeneratorProperties> entry : this.attributeGenerators.entrySet()) {
            String attributeName = entry.getKey();
            IDialogSettings attributeSection = UIUtils.getSettingsSection((IDialogSettings)tableSection, (String)attributeName);
            String selectedGeneratorId = attributeSection.get(KEY_SELECTED_GENERATOR);
            if (selectedGeneratorId == null) continue;
            AttributeGeneratorProperties attrGeneratorProperties = entry.getValue();
            attrGeneratorProperties.setSelectedGeneratorId(selectedGeneratorId);
            attrGeneratorProperties.setPresetId(attributeSection.get(KEY_PRESET_ID));
            PropertySourceCustom generatorPropertySource = attrGeneratorProperties.getGeneratorPropertySource(selectedGeneratorId);
            IDialogSettings generatorSection = UIUtils.getSettingsSection((IDialogSettings)attributeSection, (String)KEY_GENERATOR_SECTION);
            if (generatorPropertySource == null) continue;
            Map properties = generatorPropertySource.getPropertiesWithDefaults();
            for (Map.Entry propEntry : properties.entrySet()) {
                String key = (String)propEntry.getKey();
                Object savedValue = UIUtils.getSectionValueWithType((IDialogSettings)generatorSection, (String)key);
                if (key.equals("nulls") && savedValue instanceof Boolean) continue;
                generatorPropertySource.setPropertyValue((DBRProgressMonitor)voidProgressMonitor, propEntry.getKey(), savedValue);
            }
        }
    }

    void saveTo(IDialogSettings dialogSettings) {
        dialogSettings.put(PROP_REMOVE_OLD_DATA, this.removeOldData);
        dialogSettings.put(PROP_ROWS_NUMBER, this.rowsNumber);
        dialogSettings.put(KEY_SELECTED_ATTRIBUTE, this.selectedAttribute);
        IDialogSettings tableSection = UIUtils.getSettingsSection((IDialogSettings)dialogSettings, (String)this.entity.getName());
        for (Map.Entry<String, AttributeGeneratorProperties> attrEntry : this.attributeGenerators.entrySet()) {
            String attributeName = attrEntry.getKey();
            AttributeGeneratorProperties attrGeneratorProperties = attrEntry.getValue();
            IDialogSettings attributeSection = UIUtils.getSettingsSection((IDialogSettings)tableSection, (String)attributeName);
            String selectedGeneratorId = attrGeneratorProperties.getSelectedGeneratorId();
            attributeSection.put(KEY_SELECTED_GENERATOR, selectedGeneratorId);
            attributeSection.put(KEY_PRESET_ID, attrGeneratorProperties.getPresetId());
            IDialogSettings generatorSection = UIUtils.getSettingsSection((IDialogSettings)attributeSection, (String)KEY_GENERATOR_SECTION);
            PropertySourceCustom generatorPropertySource = attrGeneratorProperties.getGeneratorPropertySource(selectedGeneratorId);
            if (generatorPropertySource == null) continue;
            Map properties = generatorPropertySource.getPropertiesWithDefaults();
            for (Map.Entry propEntry : properties.entrySet()) {
                UIUtils.putSectionValueWithType((IDialogSettings)generatorSection, (String)((String)propEntry.getKey()), propEntry.getValue());
            }
        }
    }

    public class AttributeGeneratorProperties {
        private final DBSAttributeBase attribute;
        private String selectedGeneratorId = null;
        private String presetId = null;
        private Map<String, PropertySourceCustom> generators = new TreeMap<String, PropertySourceCustom>();

        public AttributeGeneratorProperties(DBSAttributeBase attribute) {
            this.attribute = attribute;
        }

        public DBSAttributeBase getAttribute() {
            return this.attribute;
        }

        public String getSelectedGeneratorId() {
            if (this.selectedGeneratorId == null && !CommonUtils.isEmpty(this.getGenerators())) {
                this.selectedGeneratorId = this.getGenerators().iterator().next();
            }
            return this.selectedGeneratorId;
        }

        public Set<String> getGenerators() {
            return this.generators.keySet();
        }

        public String setSelectedGeneratorId(String selectedGeneratorId) {
            if (!(selectedGeneratorId != null && MockDataSettings.this.generatorDescriptors.keySet().contains(selectedGeneratorId) || CommonUtils.isEmpty(this.getGenerators()))) {
                selectedGeneratorId = this.getGenerators().iterator().next();
            }
            if (this.selectedGeneratorId != selectedGeneratorId) {
                this.selectedGeneratorId = selectedGeneratorId;
                this.presetId = null;
            }
            return selectedGeneratorId;
        }

        public void putGeneratorPropertySource(String generatorId, PropertySourceCustom propertySource) {
            this.generators.put(generatorId, propertySource);
        }

        public PropertySourceCustom getGeneratorPropertySource(String generatorId) {
            if (generatorId == null) {
                generatorId = this.getSelectedGeneratorId();
            }
            return this.generators.get(generatorId);
        }

        public String getPresetId() {
            return this.presetId;
        }

        public void setPresetId(String presetId) {
            this.presetId = presetId;
        }

        public boolean isEmpty() {
            return this.generators.isEmpty();
        }
    }
}

