/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.net.ns.BreakNetException;

abstract class T4CMarshaller {
    private static final T4CMarshaller BASIC = new BasicMarshaller();
    private static final T4CMarshaller STREAM = new StreamMarshaller();
    static final T4CMarshaller CHAR = BASIC;
    static final T4CMarshaller LONG_RAW = STREAM;
    static final T4CMarshaller RAW = BASIC;
    static final T4CMarshaller VARCHAR = BASIC;
    static final T4CMarshaller LONG = STREAM;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    abstract boolean unmarshalOneRow(Accessor var1) throws SQLException, IOException;

    abstract int readStreamFromWire(byte[] var1, int var2, int var3, int[] var4, boolean[] var5, boolean[] var6, T4CMAREngine var7, T4CTTIoer var8) throws SQLException, IOException;

    private T4CMarshaller() {
    }

    private static final class BasicMarshaller
    extends T4CMarshaller {
        private BasicMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor accessor) throws SQLException, IOException {
            T4CAccessor t4CAccessor = (T4CAccessor)((Object)accessor);
            boolean bl = false;
            if (!accessor.isUseless()) {
                if (accessor.isUnexpected()) {
                    long l2 = accessor.rowData.getPosition();
                    t4CAccessor.unmarshalColumnMetadata();
                    this.unmarshalBytes(accessor);
                    accessor.rowData.setPosition(l2);
                    accessor.setNull(accessor.lastRowProcessed, true);
                } else if (accessor.isNullByDescribe()) {
                    accessor.setNull(accessor.lastRowProcessed, true);
                    t4CAccessor.unmarshalColumnMetadata();
                    if (accessor.statement.connection.versionNumber < 9200) {
                        t4CAccessor.processIndicator(0);
                    }
                } else {
                    t4CAccessor.unmarshalColumnMetadata();
                    bl = this.unmarshalBytes(accessor);
                }
            }
            accessor.previousRowProcessed = accessor.lastRowProcessed++;
            return bl;
        }

        private boolean unmarshalBytes(Accessor accessor) throws SQLException, IOException {
            T4CAccessor t4CAccessor = (T4CAccessor)((Object)accessor);
            T4CMAREngine t4CMAREngine = t4CAccessor.getMAREngine();
            accessor.setOffset(accessor.lastRowProcessed);
            int n2 = accessor.statement.maxFieldSize > 0 ? ((DynamicByteArray)accessor.rowData).unmarshalCLR(t4CMAREngine, accessor.statement.maxFieldSize) : ((DynamicByteArray)accessor.rowData).unmarshalCLR(t4CMAREngine);
            t4CAccessor.processIndicator(n2);
            accessor.setLength(accessor.lastRowProcessed, n2);
            accessor.setNull(accessor.lastRowProcessed, n2 == 0);
            return false;
        }

        @Override
        int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer t4CTTIoer) throws SQLException, IOException {
            return -1;
        }
    }

    private static final class StreamMarshaller
    extends T4CMarshaller {
        private StreamMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor accessor) throws SQLException, IOException {
            T4CAccessor t4CAccessor = (T4CAccessor)((Object)accessor);
            T4CMAREngine t4CMAREngine = t4CAccessor.getMAREngine();
            if (accessor.isUseless()) {
                ++accessor.lastRowProcessed;
                return false;
            }
            boolean bl = false;
            accessor.escapeSequenceArr[0] = t4CMAREngine.unmarshalUB1();
            if (t4CMAREngine.escapeSequenceNull(accessor.escapeSequenceArr[0])) {
                accessor.setNull(accessor.lastRowProcessed, true);
                t4CMAREngine.processIndicator(false, 0);
                int n2 = (int)t4CMAREngine.unmarshalUB4();
                accessor.escapeSequenceArr[0] = 0;
                accessor.previousRowProcessed = accessor.lastRowProcessed++;
            } else {
                accessor.setNull(accessor.lastRowProcessed, false);
                accessor.readHeaderArr[0] = true;
                accessor.readAsNonStreamArr[0] = false;
                if (accessor.statement.isFetchStreams || accessor.definedColumnType == -2 || accessor.definedColumnType == 12 || accessor.definedColumnType == 1) {
                    int n3 = 0;
                    int n4 = 0;
                    byte[] byArray = accessor.statement.connection.getByteBuffer(32768);
                    accessor.setOffset(accessor.lastRowProcessed);
                    while (n3 != -1) {
                        n3 = this.readStreamFromWire(byArray, 0, 32768, accessor.escapeSequenceArr, accessor.readHeaderArr, accessor.readAsNonStreamArr, t4CMAREngine, ((T4CConnection)accessor.statement.connection).oer);
                        if (n3 == -1) continue;
                        if (accessor.statement.connection.checksumMode.needToCalculateFetchChecksum()) {
                            long l2;
                            accessor.statement.checkSum = l2 = CRC64.updateChecksum(accessor.statement.checkSum, byArray, 0, n3);
                        }
                        accessor.rowData.put(byArray, 0, n3);
                        n4 += n3;
                    }
                    accessor.setLength(accessor.lastRowProcessed, n4);
                    accessor.previousRowProcessed = accessor.lastRowProcessed++;
                    accessor.isStream = false;
                    accessor.statement.connection.cacheBuffer(byArray);
                } else {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer t4CTTIoer) throws SQLException, IOException {
            int n4;
            block13: {
                n4 = -1;
                try {
                    if (!blArray2[0]) {
                        if (n3 > 32768 || n3 < 0) {
                            SQLException sQLException = DatabaseError.createSqlException(null, 433);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        if (blArray[0]) {
                            if (nArray[0] == 254) {
                                n4 = t4CMAREngine.useCLRBigChunks ? t4CMAREngine.unmarshalSB4() : (int)t4CMAREngine.unmarshalUB1();
                            } else {
                                if (nArray[0] == 0) {
                                    t4CTTIoer.connection.internalClose();
                                    SQLException sQLException = DatabaseError.createSqlException(null, 401);
                                    sQLException.fillInStackTrace();
                                    throw sQLException;
                                }
                                blArray2[0] = true;
                                n4 = nArray[0];
                            }
                            blArray[0] = false;
                            nArray[0] = 0;
                        } else {
                            n4 = t4CMAREngine.useCLRBigChunks ? t4CMAREngine.unmarshalSB4() : (int)t4CMAREngine.unmarshalUB1();
                        }
                    } else {
                        blArray2[0] = false;
                    }
                    if (n4 > 0) {
                        t4CMAREngine.unmarshalNBytes(byArray, n2, n4);
                    } else {
                        n4 = -1;
                    }
                }
                catch (BreakNetException breakNetException) {
                    n4 = t4CMAREngine.unmarshalSB1();
                    if (n4 != 4) break block13;
                    t4CTTIoer.init();
                    t4CTTIoer.processError();
                }
            }
            if (n4 == -1) {
                blArray[0] = true;
                t4CMAREngine.unmarshalUB2();
                t4CMAREngine.unmarshalUB2();
            }
            return n4;
        }
    }
}

