/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class GeneratedUpdatableResultSet
extends OracleResultSet {
    protected static final int MAX_CHAR_BUFFER_SIZE = 1024;
    protected static final int MAX_BYTE_BUFFER_SIZE = 1024;
    OracleResultSet resultSet;
    boolean isRowDeleted = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    GeneratedUpdatableResultSet(OracleStatement oracleStatement, OracleResultSet oracleResultSet) throws SQLException {
        super(oracleStatement.connection);
        this.resultSet = oracleResultSet;
    }

    abstract void ensureOpen() throws SQLException;

    abstract void setIsNull(NullStatus var1);

    abstract void setIsNull(boolean var1);

    abstract boolean isOnInsertRow();

    abstract boolean isUpdatingRow() throws SQLException;

    abstract boolean isRowBufferUpdatedAt(int var1) throws SQLException;

    abstract Updater getUpdater(int var1) throws SQLException;

    abstract void setUpdater(int var1, Updater var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Array array;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getArray");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getArray");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                array = JavaToJavaConverter.convert(updater.getValue(), Array.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                array = this.resultSet.getArray(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBigDecimal");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bigDecimal = JavaToJavaConverter.convert(updater.getValue(), BigDecimal.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                bigDecimal = this.resultSet.getBigDecimal(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBigDecimal");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bigDecimal = JavaToJavaConverter.convert(updater.getValue(), BigDecimal.class, this.connection, updater.getExtra(), n3);
                this.setIsNull(updater.getValue() == null);
            } else {
                bigDecimal = this.resultSet.getBigDecimal(n2, n3);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Blob blob;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBlob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBlob");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                blob = JavaToJavaConverter.convert(updater.getValue(), Blob.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                blob = this.resultSet.getBlob(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return blob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Boolean bl;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBoolean");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBoolean");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bl = JavaToJavaConverter.convert(updater.getValue(), Boolean.class, this.connection, updater.getExtra(), null);
                if (bl == null) {
                    bl = false;
                }
                this.setIsNull(updater.getValue() == null);
            } else {
                bl = this.resultSet.getBoolean(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Byte by;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getByte");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getByte");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                by = JavaToJavaConverter.convert(updater.getValue(), Byte.class, this.connection, updater.getExtra(), null);
                if (by == null) {
                    by = 0;
                }
                this.setIsNull(updater.getValue() == null);
            } else {
                by = this.resultSet.getByte(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte[] byArray;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBytes");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBytes");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                byArray = JavaToJavaConverter.convert(updater.getValue(), byte[].class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                byArray = this.resultSet.getBytes(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Clob clob;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getClob");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                clob = JavaToJavaConverter.convert(updater.getValue(), Clob.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                clob = this.resultSet.getClob(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return clob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDate");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                date = JavaToJavaConverter.convert(updater.getValue(), Date.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                date = this.resultSet.getDate(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDate");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                date = JavaToJavaConverter.convert(updater.getValue(), Date.class, this.connection, updater.getExtra(), calendar);
                this.setIsNull(updater.getValue() == null);
            } else {
                date = this.resultSet.getDate(n2, calendar);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Double d2;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDouble");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDouble");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                d2 = JavaToJavaConverter.convert(updater.getValue(), Double.class, this.connection, updater.getExtra(), null);
                if (d2 == null) {
                    d2 = 0.0;
                }
                this.setIsNull(updater.getValue() == null);
            } else {
                d2 = this.resultSet.getDouble(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Float f2;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getFloat");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getFloat");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                f2 = JavaToJavaConverter.convert(updater.getValue(), Float.class, this.connection, updater.getExtra(), null);
                if (f2 == null) {
                    f2 = Float.valueOf(0.0f);
                }
                this.setIsNull(updater.getValue() == null);
            } else {
                f2 = Float.valueOf(this.resultSet.getFloat(n2));
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return f2.floatValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Integer n3;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getInt");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getInt");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                n3 = JavaToJavaConverter.convert(updater.getValue(), Integer.class, this.connection, updater.getExtra(), null);
                if (n3 == null) {
                    n3 = 0;
                }
                this.setIsNull(updater.getValue() == null);
            } else {
                n3 = this.resultSet.getInt(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Long l2;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getLong");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getLong");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                l2 = JavaToJavaConverter.convert(updater.getValue(), Long.class, this.connection, updater.getExtra(), null);
                if (l2 == null) {
                    l2 = 0L;
                }
                this.setIsNull(updater.getValue() == null);
            } else {
                l2 = this.resultSet.getLong(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            NClob nClob;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNClob");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                nClob = JavaToJavaConverter.convert(updater.getValue(), NClob.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                nClob = this.resultSet.getNClob(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return nClob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNString");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                string = JavaToJavaConverter.convert(updater.getValue(), String.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                string = this.resultSet.getNString(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                object = JavaToJavaConverter.convert(updater.getValue(), Object.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                object = this.resultSet.getObject(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                object = JavaToJavaConverter.convert(updater.getValue(), Object.class, this.connection, updater.getExtra(), map);
                this.setIsNull(updater.getValue() == null);
            } else {
                object = this.resultSet.getObject(n2, map);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Ref ref;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getRef");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getRef");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ref = JavaToJavaConverter.convert(updater.getValue(), Ref.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                ref = this.resultSet.getRef(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            RowId rowId;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getRowId");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getRowId");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rowId = JavaToJavaConverter.convert(updater.getValue(), RowId.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                rowId = this.resultSet.getRowId(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return rowId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Short s2;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getShort");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                s2 = JavaToJavaConverter.convert(updater.getValue(), Short.class, this.connection, updater.getExtra(), null);
                if (s2 == null) {
                    s2 = 0;
                }
                this.setIsNull(updater.getValue() == null);
            } else {
                s2 = this.resultSet.getShort(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLXML sQLXML;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getSQLXML");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getSQLXML");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                sQLXML = JavaToJavaConverter.convert(updater.getValue(), SQLXML.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                sQLXML = this.resultSet.getSQLXML(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return sQLXML;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getString");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                string = JavaToJavaConverter.convert(updater.getValue(), String.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                string = this.resultSet.getString(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTime");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                time = JavaToJavaConverter.convert(updater.getValue(), Time.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                time = this.resultSet.getTime(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTime");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                time = JavaToJavaConverter.convert(updater.getValue(), Time.class, this.connection, updater.getExtra(), calendar);
                this.setIsNull(updater.getValue() == null);
            } else {
                time = this.resultSet.getTime(n2, calendar);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTimestamp");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                timestamp = JavaToJavaConverter.convert(updater.getValue(), Timestamp.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                timestamp = this.resultSet.getTimestamp(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTimestamp");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                timestamp = JavaToJavaConverter.convert(updater.getValue(), Timestamp.class, this.connection, updater.getExtra(), calendar);
                this.setIsNull(updater.getValue() == null);
            } else {
                timestamp = this.resultSet.getTimestamp(n2, calendar);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getURL");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                uRL = JavaToJavaConverter.convert(updater.getValue(), URL.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                uRL = this.resultSet.getURL(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getARRAY");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                aRRAY = JavaToJavaConverter.convert(updater.getValue(), ARRAY.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                aRRAY = this.resultSet.getARRAY(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBFILE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bFILE = JavaToJavaConverter.convert(updater.getValue(), BFILE.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                bFILE = this.resultSet.getBFILE(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBfile");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBfile");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bFILE = JavaToJavaConverter.convert(updater.getValue(), BFILE.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                bFILE = this.resultSet.getBfile(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bLOB = JavaToJavaConverter.convert(updater.getValue(), BLOB.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                bLOB = this.resultSet.getBLOB(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CHAR cHAR;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCHAR");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                cHAR = JavaToJavaConverter.convert(updater.getValue(), CHAR.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                cHAR = this.resultSet.getCHAR(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                cLOB = JavaToJavaConverter.convert(updater.getValue(), CLOB.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                cLOB = this.resultSet.getCLOB(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCursor");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCursor");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                resultSet = JavaToJavaConverter.convert(updater.getValue(), ResultSet.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                resultSet = this.resultSet.getCursor(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            DATE dATE;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDATE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                dATE = JavaToJavaConverter.convert(updater.getValue(), DATE.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                dATE = this.resultSet.getDATE(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALDS iNTERVALDS;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getINTERVALDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getINTERVALDS");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                iNTERVALDS = JavaToJavaConverter.convert(updater.getValue(), INTERVALDS.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                iNTERVALDS = this.resultSet.getINTERVALDS(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return iNTERVALDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            INTERVALYM iNTERVALYM;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getINTERVALYM");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getINTERVALYM");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                iNTERVALYM = JavaToJavaConverter.convert(updater.getValue(), INTERVALYM.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                iNTERVALYM = this.resultSet.getINTERVALYM(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return iNTERVALYM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            NUMBER nUMBER;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNUMBER");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                nUMBER = JavaToJavaConverter.convert(updater.getValue(), NUMBER.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                nUMBER = this.resultSet.getNUMBER(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OPAQUE oPAQUE;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getOPAQUE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getOPAQUE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                oPAQUE = JavaToJavaConverter.convert(updater.getValue(), OPAQUE.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                oPAQUE = this.resultSet.getOPAQUE(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getOracleObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getOracleObject");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                datum = JavaToJavaConverter.convert(updater.getValue(), Datum.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                datum = this.resultSet.getOracleObject(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getORAData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getORAData");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                oRAData = JavaToJavaConverter.convert(updater.getValue(), ORAData.class, this.connection, updater.getExtra(), oRADataFactory);
                this.setIsNull(updater.getValue() == null);
            } else {
                oRAData = this.resultSet.getORAData(n2, oRADataFactory);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                object = JavaToJavaConverter.convert(updater.getValue(), Object.class, this.connection, updater.getExtra(), oracleDataFactory);
                this.setIsNull(updater.getValue() == null);
            } else {
                object = this.resultSet.getObject(n2, oracleDataFactory);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            RAW rAW;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getRAW");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rAW = JavaToJavaConverter.convert(updater.getValue(), RAW.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                rAW = this.resultSet.getRAW(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getREF");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rEF = JavaToJavaConverter.convert(updater.getValue(), REF.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                rEF = this.resultSet.getREF(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ROWID rOWID;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getROWID");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rOWID = JavaToJavaConverter.convert(updater.getValue(), ROWID.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                rOWID = this.resultSet.getROWID(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            STRUCT sTRUCT;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getSTRUCT");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                sTRUCT = JavaToJavaConverter.convert(updater.getValue(), STRUCT.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                sTRUCT = this.resultSet.getSTRUCT(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPLTZ tIMESTAMPLTZ;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTIMESTAMPLTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMPLTZ = JavaToJavaConverter.convert(updater.getValue(), TIMESTAMPLTZ.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                tIMESTAMPLTZ = this.resultSet.getTIMESTAMPLTZ(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return tIMESTAMPLTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMPTZ tIMESTAMPTZ;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTIMESTAMPTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMPTZ = JavaToJavaConverter.convert(updater.getValue(), TIMESTAMPTZ.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                tIMESTAMPTZ = this.resultSet.getTIMESTAMPTZ(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return tIMESTAMPTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            TIMESTAMP tIMESTAMP;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTIMESTAMP");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMP = JavaToJavaConverter.convert(updater.getValue(), TIMESTAMP.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                tIMESTAMP = this.resultSet.getTIMESTAMP(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return tIMESTAMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCustomDatum");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCustomDatum");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                customDatum = JavaToJavaConverter.convert(updater.getValue(), CustomDatum.class, this.connection, updater.getExtra(), customDatumFactory);
                this.setIsNull(updater.getValue() == null);
            } else {
                customDatum = this.resultSet.getCustomDatum(n2, customDatumFactory);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getAsciiStream");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = JavaToJavaConverter.convert(updater.getValue(), InputStream.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                inputStream = this.resultSet.getAsciiStream(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBinaryStream");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = JavaToJavaConverter.convert(updater.getValue(), InputStream.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                inputStream = this.resultSet.getBinaryStream(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCharacterStream");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                reader = JavaToJavaConverter.convert(updater.getValue(), Reader.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                reader = this.resultSet.getCharacterStream(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNCharacterStream");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                reader = JavaToJavaConverter.convert(updater.getValue(), Reader.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                reader = this.resultSet.getNCharacterStream(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getUnicodeStream");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = JavaToJavaConverter.convert(updater.getValue(), InputStream.class, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                inputStream = this.resultSet.getUnicodeStream(n2);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateArray");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateArray");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Array>(array){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setArray(n2, (Array)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBigDecimal");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<BigDecimal>(bigDecimal){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBigDecimal(n2, (BigDecimal)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBlob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBlob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Blob>(blob){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBlob(n2, (Blob)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBoolean");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBoolean");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Boolean>(Boolean.valueOf(bl)){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBoolean(n2, (Boolean)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateByte");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateByte");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Byte>(Byte.valueOf(by)){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setByte(n2, (Byte)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBytes");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBytes");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<byte[]>(byArray){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBytes(n2, (byte[])this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Clob>(clob){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setClob(n2, (Clob)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Date>(date){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setDate(n2, (Date)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int n2, Date date, final Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDate");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Date>(date){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setDate(n2, (Date)this.value, calendar);
                }

                @Override
                public Object getExtra() {
                    return calendar;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDouble");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDouble");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Double>(Double.valueOf(d2)){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setDouble(n2, (Double)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateFloat");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateFloat");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Float>(Float.valueOf(f2)){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setFloat(n2, ((Float)this.value).floatValue());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateInt");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateInt");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Integer>(Integer.valueOf(n3)){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setInt(n2, (Integer)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateLong");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateLong");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Long>(Long.valueOf(l2)){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setLong(n2, (Long)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<NClob>(nClob){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setNClob(n2, (NClob)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<String>(string){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setNString(n2, (String)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Object>(object){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setObject(n2, this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, final int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Object>(object){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setObject(n2, this.value, n3);
                }

                @Override
                public Object getExtra() {
                    return n3;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateRef");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateRef");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Ref>(ref){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setRef(n2, (Ref)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateRowId");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateRowId");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<RowId>(rowId){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setRowId(n2, (RowId)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Short>(Short.valueOf(s2)){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setShort(n2, (Short)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateSQLXML");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateSQLXML");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<SQLXML>(sQLXML){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setSQLXML(n2, (SQLXML)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateString");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<String>(string){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setString(n2, (String)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Time>(time){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setTime(n2, (Time)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int n2, Time time, final Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTime");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Time>(time){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setTime(n2, (Time)this.value, calendar);
                }

                @Override
                public Object getExtra() {
                    return calendar;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Timestamp>(timestamp){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setTimestamp(n2, (Timestamp)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int n2, Timestamp timestamp, final Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTimestamp");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Timestamp>(timestamp){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setTimestamp(n2, (Timestamp)this.value, calendar);
                }

                @Override
                public Object getExtra() {
                    return calendar;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateURL(int n2, URL uRL) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<URL>(uRL){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setURL(n2, (URL)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateARRAY(int n2, ARRAY aRRAY) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<ARRAY>(aRRAY){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setARRAY(n2, (ARRAY)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBFILE(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<BFILE>(bFILE){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBFILE(n2, (BFILE)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBfile(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBfile");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBfile");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<BFILE>(bFILE){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBfile(n2, (BFILE)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBLOB(int n2, BLOB bLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<BLOB>(bLOB){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBLOB(n2, (BLOB)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCHAR(int n2, CHAR cHAR) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<CHAR>(cHAR){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setCHAR(n2, (CHAR)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCLOB(int n2, CLOB cLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<CLOB>(cLOB){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setCLOB(n2, (CLOB)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDATE(int n2, DATE dATE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<DATE>(dATE){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setDATE(n2, (DATE)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateINTERVALDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateINTERVALDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<INTERVALDS>(iNTERVALDS){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setINTERVALDS(n2, (INTERVALDS)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateINTERVALYM");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateINTERVALYM");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<INTERVALYM>(iNTERVALYM){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setINTERVALYM(n2, (INTERVALYM)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<NUMBER>(nUMBER){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setNUMBER(n2, (NUMBER)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOracleObject(int n2, Datum datum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateOracleObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateOracleObject");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Datum>(datum){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setOracleObject(n2, (Datum)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateORAData(int n2, ORAData oRAData) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateORAData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateORAData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<ORAData>(oRAData){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setORAData(n2, (ORAData)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRAW(int n2, RAW rAW) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<RAW>(rAW){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setRAW(n2, (RAW)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateREF(int n2, REF rEF) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<REF>(rEF){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setREF(n2, (REF)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateROWID(int n2, ROWID rOWID) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<ROWID>(rOWID){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setROWID(n2, (ROWID)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<STRUCT>(sTRUCT){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setSTRUCT(n2, (STRUCT)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<TIMESTAMPLTZ>(tIMESTAMPLTZ){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setTIMESTAMPLTZ(n2, (TIMESTAMPLTZ)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<TIMESTAMPTZ>(tIMESTAMPTZ){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setTIMESTAMPTZ(n2, (TIMESTAMPTZ)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<TIMESTAMP>(tIMESTAMP){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setTIMESTAMP(n2, (TIMESTAMP)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCustomDatum");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCustomDatum");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<CustomDatum>(customDatum){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setCustomDatum(n2, (CustomDatum)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBlob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBlob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBlob(n2, (InputStream)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream, final long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBlob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBlob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBlob(n2, (InputStream)this.value, l2);
                }

                @Override
                public Object getExtra() {
                    return l2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setClob(n2, (Reader)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader, final long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setClob(n2, (Reader)this.value, l2);
                }

                @Override
                public Object getExtra() {
                    return l2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setNClob(n2, (Reader)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(int n2, Reader reader, final long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNClob");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setNClob(n2, (Reader)this.value, l2);
                }

                @Override
                public Object getExtra() {
                    return l2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setAsciiStream(n2, (InputStream)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, final int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setAsciiStream(n2, (InputStream)this.value, n3);
                }

                @Override
                public Object getExtra() {
                    return n3;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, final long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateAsciiStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setAsciiStream(n2, (InputStream)this.value, l2);
                }

                @Override
                public Object getExtra() {
                    return l2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBinaryStream(n2, (InputStream)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, final int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBinaryStream(n2, (InputStream)this.value, n3);
                }

                @Override
                public Object getExtra() {
                    return n3;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, final long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBinaryStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setBinaryStream(n2, (InputStream)this.value, l2);
                }

                @Override
                public Object getExtra() {
                    return l2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setCharacterStream(n2, (Reader)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader, final int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setCharacterStream(n2, (Reader)this.value, n3);
                }

                @Override
                public Object getExtra() {
                    return n3;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader, final long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setCharacterStream(n2, (Reader)this.value, l2);
                }

                @Override
                public Object getExtra() {
                    return l2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setNCharacterStream(n2, (Reader)this.value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(int n2, Reader reader, final long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNCharacterStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<Reader>(reader){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setNCharacterStream(n2, (Reader)this.value, l2);
                }

                @Override
                public Object getExtra() {
                    return l2;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUnicodeStream(int n2, InputStream inputStream, final int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setUpdater(n2, new Updater<InputStream>(inputStream){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setUnicodeStream(n2, (InputStream)this.value, n3);
                }

                @Override
                public Object getExtra() {
                    return n3;
                }
            });
        }
    }

    static enum NullStatus {
        VALUE_UNKNOWN,
        VALUE_IN_RSET,
        VALUE_NULL,
        VALUE_NOT_NULL;

    }

    protected static abstract class Updater<T> {
        protected T value;

        Updater(T t2) {
            this.value = t2;
        }

        abstract void set(OraclePreparedStatement var1, int var2) throws SQLException;

        Object getExtra() {
            return null;
        }

        final T getValue() throws SQLException {
            return this.value;
        }

        final boolean isNull() {
            return this.value == null;
        }
    }
}

