/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.utilities;

import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.IWarningListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class EvalLicense {
    private int LICENSE_FILESIZE = 28;
    private int m_version = 0;
    private long m_startDate = 0L;
    private long m_endDate = 0L;
    private long m_licenseLength = 7776000L;
    private byte[] m_licenseBinaryBuffer = new byte[this.LICENSE_FILESIZE];
    private String m_licenseFilePath = System.getenv("WINDIR");
    private IWarningListener m_warningListener;
    private static final int MILLISECONDS_IN_SECOND = 1000;

    public EvalLicense(IWarningListener iWarningListener) {
        if (this.m_licenseFilePath != null) {
            this.m_licenseFilePath = this.m_licenseFilePath + File.separator;
            this.m_licenseFilePath = this.m_licenseFilePath + "system32";
        } else {
            this.m_licenseFilePath = System.getenv("HOME");
            if (this.m_licenseFilePath == null) {
                this.m_licenseFilePath = "";
            }
        }
        this.m_licenseFilePath = this.m_licenseFilePath + File.separator;
        this.m_licenseFilePath = this.m_licenseFilePath + "Simba.lic";
        this.m_warningListener = iWarningListener;
    }

    public void ValidateLicense() throws SQLException {
        this.InitializeLicenseData();
        this.DecodeLicenseData();
        Calendar calendar = Calendar.getInstance();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.m_startDate * 1000L);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(this.m_endDate * 1000L);
        if (gregorianCalendar.get(1) > calendar.get(1) + 1 || gregorianCalendar.get(1) < calendar.get(1) - 1 || gregorianCalendar2.get(1) > calendar.get(1) + 1 || gregorianCalendar2.get(1) < calendar.get(1) - 1) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.LICENSE_FILE_CORRUPTED, this.m_warningListener, this.m_licenseFilePath);
        }
        if (this.m_endDate - this.m_startDate > this.m_licenseLength) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.LICENSE_FILE_CORRUPTED, this.m_warningListener, this.m_licenseFilePath);
        }
        if (System.currentTimeMillis() < this.m_startDate * 1000L || System.currentTimeMillis() > this.m_endDate * 1000L) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.LICENSE_EXPIRED, this.m_warningListener, this.m_licenseFilePath, this.m_licenseFilePath);
        }
    }

    private long BytesToInt(int n, int n2, int n3, int n4) {
        long l = n;
        l = (l << 8) + (long)n2 & 0xFFFFFFFFL;
        l = (l << 8) + (long)n3 & 0xFFFFFFFFL;
        l = (l << 8) + (long)n4 & 0xFFFFFFFFL;
        return l;
    }

    private void DecodeLicenseData() throws SQLException {
        int n = this.m_licenseBinaryBuffer[0] & 0xFF;
        int n2 = this.m_licenseBinaryBuffer[1] & 0xFF;
        int n3 = this.m_licenseBinaryBuffer[2] & 0xFF;
        int n4 = this.m_licenseBinaryBuffer[3] & 0xFF;
        this.m_version = n2 * 256;
        this.m_version += n;
        this.m_version -= (n3 + 2) * 256;
        this.m_version += n4;
        switch (this.m_version) {
            case 2: {
                long l = 1000789342L;
                long l2 = 1682093944L;
                long l3 = 275097285L;
                long l4 = 2868580444L;
                n = this.m_licenseBinaryBuffer[4] & 0xFF;
                int n5 = this.m_licenseBinaryBuffer[7] & 0xFF;
                n3 = this.m_licenseBinaryBuffer[8] & 0xFF;
                int n6 = this.m_licenseBinaryBuffer[9] & 0xFF;
                int n7 = this.m_licenseBinaryBuffer[10] & 0xFF;
                int n8 = this.m_licenseBinaryBuffer[12] & 0xFF;
                int n9 = this.m_licenseBinaryBuffer[13] & 0xFF;
                n2 = this.m_licenseBinaryBuffer[15] & 0xFF;
                n4 = this.m_licenseBinaryBuffer[18] & 0xFF;
                int n10 = this.m_licenseBinaryBuffer[19] & 0xFF;
                int n11 = this.m_licenseBinaryBuffer[20] & 0xFF;
                int n12 = this.m_licenseBinaryBuffer[22] & 0xFF;
                int n13 = this.m_licenseBinaryBuffer[23] & 0xFF;
                int n14 = this.m_licenseBinaryBuffer[25] & 0xFF;
                int n15 = this.m_licenseBinaryBuffer[26] & 0xFF;
                int n16 = this.m_licenseBinaryBuffer[27] & 0xFF;
                long l5 = this.BytesToInt(n, n2, n3, n4) & 0xFFFFFFFFL;
                long l6 = this.BytesToInt(n10, n5, n13, n11) & 0xFFFFFFFFL;
                this.m_startDate = this.BytesToInt(n7, n8, n16, n12) & 0xFFFFFFFFL;
                this.m_endDate = this.BytesToInt(n14, n9, n15, n6) & 0xFFFFFFFFL;
                this.m_startDate ^= l3 & 0xFFFFFFFFL;
                this.m_endDate ^= l4 & 0xFFFFFFFFL;
                this.m_startDate -= (l5 ^= l & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                this.m_endDate -= (l6 ^= l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                break;
            }
            default: {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.LICENSE_FILE_CORRUPTED, this.m_warningListener, this.m_licenseFilePath);
            }
        }
    }

    private void InitializeLicenseData() throws SQLException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.m_licenseFilePath);
            if (fileInputStream.read(this.m_licenseBinaryBuffer) != this.m_licenseBinaryBuffer.length) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.LICENSE_FILE_CORRUPTED, this.m_warningListener, this.m_licenseFilePath);
            }
        }
        catch (IOException iOException) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.LICENSE_READ_ERROR, this.m_warningListener, this.m_licenseFilePath);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

