/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultsetinput;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.Pair;
import java.io.InputStream;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStream {
    protected static final int MAX_FETCH_SIZE = 4000;
    protected int m_numRead = 0;
    protected int m_streamLength = 0;
    protected InputStream m_stream = null;
    protected int m_type;
    protected IWarningListener m_warningListener = null;

    protected AbstractDataStream(InputStream inputStream, int n, int n2, IWarningListener iWarningListener) {
        this.m_stream = inputStream;
        this.m_streamLength = n;
        this.m_type = n2;
        this.m_warningListener = iWarningListener;
    }

    public void close() {
        try {
            this.m_stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_stream = null;
    }

    public abstract Pair<DataWrapper, Long> getNextValue() throws SQLException;

    public boolean hasMoreData() throws SQLException {
        if (this.isClosed()) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, new Object[0]);
        }
        return this.m_numRead < this.m_streamLength;
    }

    protected int getNumToFetch() {
        int n = this.m_streamLength - this.m_numRead;
        return Math.min(4000, n);
    }

    protected boolean isClosed() {
        return null == this.m_stream;
    }
}

