/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parameters;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.parameters.AbstractParameterStream;
import java.io.IOException;
import java.io.Reader;

public class CharacterParameterStream
extends AbstractParameterStream {
    private Reader m_reader = null;

    public CharacterParameterStream(Reader reader, int n, ParameterMetadata parameterMetadata, int n2) {
        super(null, n, parameterMetadata, n2);
        this.m_reader = reader;
    }

    public void close() {
        super.close();
        if (!this.isClosed()) {
            try {
                this.m_reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_reader = null;
        }
    }

    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        int n = this.getNumToFetch();
        char[] cArray = new char[n];
        int n2 = this.m_reader.read(cArray);
        if (-1 == n2 || n != n2) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
        }
        this.m_numRead += n2;
        DataWrapper dataWrapper = new DataWrapper();
        try {
            if (12 == this.m_type) {
                dataWrapper.setVarChar(new String(cArray));
            } else {
                dataWrapper.setLongVarChar(new String(cArray));
            }
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CORRUPT_UTF.name());
        }
        return new ParameterInputValue(this.m_parameterMetadata, dataWrapper);
    }

    protected boolean isClosed() {
        return null == this.m_reader;
    }
}

