/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parameters;

import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractParameterStream {
    protected static final int MAX_FETCH_SIZE = 4000;
    protected ParameterMetadata m_parameterMetadata = null;
    protected int m_numRead = 0;
    protected int m_streamLength = 0;
    protected InputStream m_stream = null;
    protected int m_type;

    protected AbstractParameterStream(InputStream inputStream, int n, ParameterMetadata parameterMetadata, int n2) {
        this.m_stream = inputStream;
        this.m_streamLength = n;
        this.m_parameterMetadata = parameterMetadata;
        this.m_type = n2;
    }

    public void close() {
        if (null != this.m_stream) {
            try {
                this.m_stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_stream = null;
        }
        this.m_parameterMetadata = null;
    }

    public ParameterMetadata getMetadata() {
        return this.m_parameterMetadata;
    }

    public abstract ParameterInputValue getNextValue() throws IOException;

    public boolean hasMoreData() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        return this.m_numRead < this.m_streamLength;
    }

    protected int getNumToFetch() {
        int n = this.m_streamLength - this.m_numRead;
        return Math.min(4000, n);
    }

    protected boolean isClosed() {
        return null == this.m_stream;
    }
}

