/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.core.VStatement;
import com.vertica.dataengine.VCopyStreamExecutionContexts;
import com.vertica.dataengine.VDataEngine;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.VerticaConnection;
import com.vertica.jdbc.VerticaConnectionImpl;
import com.vertica.localization.VMessageKey;
import com.vertica.parser.Token;
import com.vertica.parser.Tokenizer;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticaCopyStream {
    private final String m_copySql;
    private final VConnection m_conn;
    private VQueryExecutor m_executor;
    private final List<InputStream> m_inputs;
    private final ArrayList<Long> m_rejects;
    private long m_rowCount;

    public VerticaCopyStream(VerticaConnection verticaConnection, String string) throws SQLException {
        this(verticaConnection, string, new ArrayList<InputStream>());
    }

    public VerticaCopyStream(VerticaConnection verticaConnection, String string, InputStream inputStream) throws SQLException {
        this(verticaConnection, string, new ArrayList<InputStream>());
        this.m_inputs.add(inputStream);
    }

    public VerticaCopyStream(VerticaConnection verticaConnection, String string, List<InputStream> list) throws SQLException {
        this.m_conn = ((VerticaConnectionImpl)verticaConnection).getInternalConnection();
        this.m_copySql = this.checkAndRewriteCopy(string);
        this.m_executor = null;
        this.m_inputs = new ArrayList<InputStream>();
        this.m_rejects = new ArrayList();
        for (InputStream inputStream : list) {
            this.m_inputs.add(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SQLException {
        VConnection vConnection = this.m_conn;
        synchronized (vConnection) {
            try {
                if (this.m_executor != null) {
                    throw new SQLException(this.m_conn.getMessageSource().loadMessage(this.m_conn.getLocale(), 101, VMessageKey.ERROR_COPY_IN_PROGRESS.toString()));
                }
                if (!this.m_conn.isAutoCommitEnabled() && !this.m_conn.withinTransaction()) {
                    this.m_conn.getTransactionStateListener().notifyBeginTransaction();
                }
                this.m_rowCount = 0L;
                this.m_rejects.clear();
                VStatement vStatement = this.m_conn.createStatement();
                VDataEngine vDataEngine = vStatement.createDataEngine();
                vDataEngine.setDirectExecute();
                this.m_executor = vDataEngine.prepare(this.m_copySql);
                this.execute();
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.toSQLException(errorException, this.m_conn.getWarningListener());
            }
        }
    }

    public void execute() throws SQLException {
        try {
            if (this.m_executor == null) {
                this.start();
            } else {
                this.m_rejects.clear();
                if (this.m_inputs.size() > 0) {
                    if (this.m_conn.isAutoCommitEnabled()) {
                        LogUtilities.logWarning("Executing COPY operation with autocommit enabled. Any new streams added to this VerticaCopyStream will be copied in a separate transaction.", (ILogger)this.m_conn.getConnectionLog());
                    }
                    VCopyStreamExecutionContexts vCopyStreamExecutionContexts = new VCopyStreamExecutionContexts();
                    for (InputStream object2 : this.m_inputs) {
                        vCopyStreamExecutionContexts.addContext(object2);
                    }
                    this.m_executor.execute(vCopyStreamExecutionContexts, this.m_conn.getWarningListener());
                    Object object3 = vCopyStreamExecutionContexts.getRejects();
                    this.m_rejects.ensureCapacity(((Object)object3).length);
                    Object object = object3;
                    int n = ((Object)object).length;
                    for (int i = 0; i < n; ++i) {
                        Long l = (long)object[i];
                        this.m_rejects.add(l);
                    }
                }
            }
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.toSQLException(errorException, this.m_conn.getWarningListener());
        }
        finally {
            this.m_inputs.clear();
        }
    }

    public void addStream(InputStream inputStream) throws SQLException {
        this.m_inputs.add(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish() throws SQLException {
        this.ensureCopyStarted();
        try {
            if (!this.m_inputs.isEmpty()) {
                this.execute();
            }
            VConnection vConnection = this.m_conn;
            synchronized (vConnection) {
                this.m_conn.endCurrentCopy();
            }
        }
        catch (ErrorException errorException) {
            ErrorException errorException2;
            try {
                this.m_conn.handleError(false, errorException);
            }
            catch (ErrorException errorException3) {
                LogUtilities.logError(errorException3, (ILogger)this.m_conn.getConnectionLog());
                errorException2 = errorException3;
            }
            throw ExceptionConverter.toSQLException(errorException2, this.m_conn.getWarningListener());
        }
        finally {
            this.m_rowCount = this.m_executor.getCopyRowCount();
            this.m_executor = null;
        }
        return this.m_rowCount;
    }

    public List<Long> getRejects() {
        return this.m_rejects;
    }

    public long getRowCount() {
        return this.m_rowCount;
    }

    private String checkAndRewriteCopy(String string) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 21);
        Tokenizer tokenizer = new Tokenizer(string, this.m_conn.useStandardConformingStrings());
        Token token = null;
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            while (tokenizer.hasNext()) {
                token = tokenizer.next();
                if (bl3 && !token.equals(Token.LOCAL)) {
                    stringBuilder.append(Token.LOCAL.toStringWithDelimiter());
                    bl = true;
                }
                if (!bl6 && !bl7 && token.equals(Token.NO) && Token.COMMIT.equals(tokenizer.peek())) {
                    stringBuilder.append(Token.RETURNREJECTED.toStringWithDelimiter());
                    bl6 = true;
                }
                if (!token.equals(Token.SEMICOLON)) {
                    stringBuilder.append(token.toStringWithDelimiter());
                }
                bl3 = token.equals(Token.FROM);
                bl2 |= bl3;
                bl4 |= token.equals(Token.COPY);
                bl5 |= token.equals(Token.STDIN);
                bl |= token.equals(Token.LOCAL);
                bl6 |= token.equals(Token.RETURNREJECTED);
                bl7 |= token.equals(Token.REJECTED) || token.equals(Token.EXCEPTIONS);
            }
            if (!bl6 && !bl7) {
                stringBuilder.append(" ");
                stringBuilder.append(Token.RETURNREJECTED.toString());
                bl6 = true;
            }
            if (!(bl4 && bl2 && bl && bl5 && (bl6 && !bl7 || !bl6 && bl7))) {
                throw new ErrorException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, 101, VMessageKey.ERROR_INVALID_COPY_STMT.toString(), new String[]{string});
            }
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.toSQLException(errorException, this.m_conn.getWarningListener());
        }
        return stringBuilder.toString();
    }

    private void ensureCopyStarted() throws SQLException {
        if (this.m_executor == null) {
            throw new SQLException(this.m_conn.getMessageSource().loadMessage(this.m_conn.getLocale(), 101, VMessageKey.ERROR_COPY_NOT_STARTED.toString()));
        }
    }
}

