/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.jdbc.SConnection;
import com.vertica.jdbc.SConnectionHandle;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SPooledConnection
implements PooledConnection {
    private List<ConnectionEventListener> m_listeners = new ArrayList<ConnectionEventListener>();
    private SConnectionHandle m_connectionHandle;
    private ILogger m_logger;

    protected SPooledConnection(SConnection sConnection) throws SQLException {
        LogUtilities.logFunctionEntrance(sConnection.getConnection().getConnectionLog(), sConnection);
        this.m_connectionHandle = new SConnectionHandle(sConnection, this);
        this.m_logger = sConnection.getConnection().getConnectionLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        if (null != connectionEventListener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.add(connectionEventListener);
            }
        }
    }

    public void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.forceClose();
    }

    public Connection getConnection() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.open();
        return this.m_connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        if (null != connectionEventListener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.remove(connectionEventListener);
            }
        }
    }

    void onHandleClose() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (ConnectionEventListener connectionEventListener : this.m_listeners) {
            connectionEventListener.connectionClosed(new ConnectionEvent(this));
        }
    }

    void onHandleError(SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (ConnectionEventListener connectionEventListener : this.m_listeners) {
            connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
        }
    }
}

