/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ExecutionResults;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.utilities.CalendarSetter;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.SConnection;
import com.vertica.jdbc.SPreparedStatement;
import com.vertica.jdbc.SStatement;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.TypeNames;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCallableStatement
extends SPreparedStatement
implements CallableStatement {
    private boolean m_wasLastParameterNull = false;
    private List<DataWrapper> m_parameterOutputValues = new ArrayList<DataWrapper>();
    private List<Boolean> m_parameterRegistered = new ArrayList<Boolean>();
    private Map<Integer, Integer> m_parameterScale = new HashMap<Integer, Integer>();

    protected SCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        LogUtilities.logFunctionEntrance(this.m_logger, string, iStatement, sConnection);
        this.resetRegisteredParameters();
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        super.clearParameters();
        if (null != this.m_parameterRegistered) {
            this.resetRegisteredParameters();
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, this.m_warningListener, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.execute();
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_parameterRegistered.contains(Boolean.TRUE)) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
            }
            return super.executeBatch();
        }
        catch (SQLException sQLException) {
            throw ExceptionConverter.toSQLException(sQLException, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, this.m_warningListener, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.executeQuery();
    }

    @Override
    public Array getArray(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getArray(this.getParameterIndex(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                BigDecimal bigDecimal = TypeConverter.toBigDecimal(dataWrapper, this.m_warningListener);
                Integer n2 = this.m_parameterScale.get(n);
                if (null != n2) {
                    bigDecimal = bigDecimal.setScale((int)n2, RoundingMode.HALF_UP);
                }
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return bigDecimal;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBigDecimal(this.getParameterIndex(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBlob(this.getParameterIndex(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                boolean bl = TypeConverter.toBoolean(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return bl;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(16));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBoolean(this.getParameterIndex(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                byte by = TypeConverter.toByte(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return by;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(-6));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getByte(this.getParameterIndex(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                byte[] byArray = TypeConverter.toBytes(dataWrapper);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return byArray;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(-2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBytes(this.getParameterIndex(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getClob(this.getParameterIndex(string));
    }

    @Override
    public Date getDate(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                Date date = TypeConverter.toDate(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return date;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(91));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
        this.checkIfOpen();
        Date date = this.getDate(n);
        try {
            return CalendarSetter.getDate(date, calendar);
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getDate(this.getParameterIndex(string));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getDate(this.getParameterIndex(string), calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                double d = TypeConverter.toDouble(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return d;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(8));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getDouble(this.getParameterIndex(string));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                float f = TypeConverter.toFloat(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return f;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(7));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getFloat(this.getParameterIndex(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                int n2 = TypeConverter.toInt(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return n2;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(4));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getInt(this.getParameterIndex(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                long l = TypeConverter.toLong(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return l;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(-5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getLong(this.getParameterIndex(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
                Object object = TypeConverter.toObject(dataWrapper, parameterMetadata.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return object;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, map);
        this.checkIfOpen();
        SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getObject(this.getParameterIndex(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, map);
        return this.getObject(this.getParameterIndex(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getRef(this.getParameterIndex(string));
    }

    @Override
    public short getShort(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                short s = TypeConverter.toShort(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return s;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getShort(this.getParameterIndex(string));
    }

    @Override
    public String getString(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
                String string = TypeConverter.toString(dataWrapper, parameterMetadata.getTypeMetadata());
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return string;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(12));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getString(this.getParameterIndex(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                Time time = TypeConverter.toTime(dataWrapper, ((ParameterMetadata)this.m_parameterMetadata.get(n - 1)).getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return time;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(92));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
        this.checkIfOpen();
        Time time = this.getTime(n);
        try {
            return CalendarSetter.getTime(time, calendar);
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getTime(this.getParameterIndex(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getTime(this.getParameterIndex(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                Timestamp timestamp = TypeConverter.toTimestamp(dataWrapper, ((ParameterMetadata)this.m_parameterMetadata.get(n - 1)).getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return timestamp;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, calendar);
        this.checkIfOpen();
        Timestamp timestamp = this.getTimestamp(n);
        try {
            return CalendarSetter.getTimestamp(timestamp, calendar);
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getTimestamp(this.getParameterIndex(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getTimestamp(this.getParameterIndex(string), calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getURL(this.getParameterIndex(string));
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        this.registerOutParameter(n, n2, 0);
        if (TypeUtilities.isExactNumericType(n2)) {
            this.m_parameterScale.remove(n);
        }
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2, n3);
            this.checkIfOpen();
            switch (n2) {
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
                }
            }
            if (0 > n3) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_SCALE, this.m_warningListener, String.valueOf(n3), "0");
            }
            if (ParameterType.INPUT == this.m_parameterTypes.get(n - 1)) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_REGISTER_TYPE, this.m_warningListener, String.valueOf(n));
            }
            ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
            short s = parameterMetadata.getTypeMetadata().getType();
            if (!TypeConverter.canConvert(s, n2)) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(n), TypeNames.getTypeName(n2));
            }
            if (TypeUtilities.isExactNumericType(n2)) {
                this.m_parameterScale.put(n, n3);
            }
            int n4 = this.getOutputParameterOnlyIndex(n);
            this.m_parameterRegistered.set(n4 - 1, Boolean.TRUE);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2, string);
        this.registerOutParameter(n, n2, 0);
        if (TypeUtilities.isExactNumericType(n2)) {
            this.m_parameterScale.remove(n);
        }
    }

    @Override
    public synchronized void registerOutParameter(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.registerOutParameter(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, n2);
        this.checkIfOpen();
        this.registerOutParameter(this.getParameterIndex(string), n, n2);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, string2);
        this.checkIfOpen();
        this.registerOutParameter(this.getParameterIndex(string), n, string2);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, n);
        this.setAsciiStream(this.getParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, bigDecimal);
        this.setBigDecimal(this.getParameterIndex(string), bigDecimal);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, n);
        this.setBinaryStream(this.getParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setBoolean(String string, boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, bl);
        this.setBoolean(this.getParameterIndex(string), bl);
    }

    @Override
    public synchronized void setByte(String string, byte by) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, by);
        this.setByte(this.getParameterIndex(string), by);
    }

    @Override
    public synchronized void setBytes(String string, byte[] byArray) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, byArray);
        this.setBytes(this.getParameterIndex(string), byArray);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, n);
        this.setCharacterStream(this.getParameterIndex(string), reader, n);
    }

    @Override
    public synchronized void setDate(String string, Date date) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, date);
        this.setDate(this.getParameterIndex(string), date);
    }

    @Override
    public synchronized void setDate(String string, Date date, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, date, calendar);
        this.setDate(this.getParameterIndex(string), date, calendar);
    }

    @Override
    public synchronized void setDouble(String string, double d) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, d);
        this.setDouble(this.getParameterIndex(string), d);
    }

    @Override
    public synchronized void setFloat(String string, float f) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, Float.valueOf(f));
        this.setFloat(this.getParameterIndex(string), f);
    }

    @Override
    public synchronized void setInt(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.setInt(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void setLong(String string, long l) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, l);
        this.setLong(this.getParameterIndex(string), l);
    }

    @Override
    public synchronized void setNull(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.setNull(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void setNull(String string, int n, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, string2);
        this.setNull(this.getParameterIndex(string), n, string2);
    }

    @Override
    public synchronized void setObject(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object);
        this.setObject(this.getParameterIndex(string), object);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, n);
        this.setObject(this.getParameterIndex(string), object, n);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, n, n2);
        this.setObject(this.getParameterIndex(string), object, n, n2);
    }

    @Override
    public synchronized void setShort(String string, short s) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, s);
        this.setShort(this.getParameterIndex(string), s);
    }

    @Override
    public synchronized void setString(String string, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, string2);
        this.setString(this.getParameterIndex(string), string2);
    }

    @Override
    public synchronized void setTime(String string, Time time) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, time);
        this.setTime(this.getParameterIndex(string), time);
    }

    @Override
    public synchronized void setTime(String string, Time time, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, time, calendar);
        this.setTime(this.getParameterIndex(string), time, calendar);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, timestamp);
        this.setTimestamp(this.getParameterIndex(string), timestamp);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, timestamp, calendar);
        this.setTimestamp(this.getParameterIndex(string), timestamp, calendar);
    }

    @Override
    public synchronized void setURL(String string, URL uRL) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, uRL);
        this.setURL(this.getParameterIndex(string), uRL);
    }

    @Override
    public boolean wasNull() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        return this.m_wasLastParameterNull;
    }

    @Override
    protected boolean allInputParameterValuesPopulated() {
        int n = this.m_parameterInputStreams.size() + this.m_parameterInputValues.size();
        int n2 = 0;
        for (ParameterMetadata parameterMetadata : this.m_parameterMetadata) {
            if (ParameterType.OUTPUT != parameterMetadata.getParameterType()) continue;
            ++n2;
        }
        return n + n2 == this.m_parameterMetadata.size();
    }

    @Override
    protected void checkParameters(List<ParameterMetadata> list) throws SQLException {
    }

    @Override
    protected ExecutionResults executeWithParams(ArrayList<ParameterMetadata> arrayList, ArrayList<ArrayList<ParameterInputValue>> arrayList2, SStatement.ThrowCondition throwCondition) throws SQLException {
        try {
            this.checkCondition(this.m_preparedSql, throwCondition);
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList, arrayList2);
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            Iterator<ArrayList<DataWrapper>> iterator = executionContexts.outputIterator();
            if (iterator.hasNext()) {
                this.m_parameterOutputValues = iterator.next();
            }
            return this.m_queryExecutor.getResults();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener);
        }
    }

    private boolean allOutputParametersRegistered() {
        return !this.m_parameterRegistered.contains(Boolean.FALSE);
    }

    private int getOutputParameterOnlyIndex(int n) throws SQLException {
        this.checkValidParameterIndex(n);
        if (ParameterType.INPUT == this.m_parameterTypes.get(n - 1)) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_RETRIEVE_TYPE, this.m_warningListener, String.valueOf(n));
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            ++n2;
        }
        if (0 == n2) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_OUTPUT_INDEX, this.m_warningListener, String.valueOf(n));
        }
        return n2;
    }

    private DataWrapper getOutputParameterValue(int n) throws SQLException {
        int n2 = this.getOutputParameterOnlyIndex(n);
        return this.m_parameterOutputValues.get(n2 - 1);
    }

    private int getParameterIndex(String string) throws SQLException {
        for (int i = 0; i < this.m_parameterMetadata.size(); ++i) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(i);
            if (!parameterMetadata.getName().equals(string)) continue;
            return i + 1;
        }
        throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_NAME, this.m_warningListener, string);
    }

    private void resetRegisteredParameters() {
        this.m_parameterRegistered.clear();
        for (int i = 0; i < this.m_numParameters; ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            this.m_parameterRegistered.add(Boolean.FALSE);
        }
        this.m_parameterScale.clear();
    }
}

