/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import java.io.IOException;

public class DataRowResponseMessage
extends ResponseMessage {
    int m_columnCount;
    int m_rowLength;
    private byte[][] m_columns;

    public DataRowResponseMessage(VStream vStream) {
        super(vStream);
    }

    protected void buildMessage(int n) throws IOException {
        this.m_columnCount = this.m_vStream.ReceiveIntegerR(2);
        if (this.m_columnCount > 0) {
            this.m_columns = new byte[this.m_columnCount][];
            for (int i = 0; i < this.m_columnCount; ++i) {
                int n2 = this.m_vStream.ReceiveIntegerR(4);
                byte[] byArray = null;
                if (n2 >= 0) {
                    byArray = new byte[n2];
                    this.m_vStream.Receive(byArray, 0, n2);
                    this.m_rowLength += n2;
                } else {
                    ++this.m_rowLength;
                }
                this.m_columns[i] = byArray;
            }
        }
    }

    public byte[] getCellData(int n) {
        return this.m_columns[n];
    }

    public byte[][] getRow() {
        return this.m_columns;
    }

    public int getRowLength() {
        return this.m_rowLength;
    }

    public MessageType getType() {
        return MessageType.DataRow;
    }
}

