/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VDriver;
import com.vertica.dataengine.VParameterMetadata;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.MessageType;
import com.vertica.io.RequestMessage;
import com.vertica.io.VStream;
import com.vertica.localization.VMessageKey;
import com.vertica.util.ProtocolUtils;
import com.vertica.util.TypeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindRequestMessage
extends RequestMessage {
    private ArrayList<ParameterInputValue> m_inputs;
    private Map<Integer, List<DataWrapper>> m_pushedData;
    private String m_statementName;
    private String m_portalName;

    public BindRequestMessage(ArrayList<ParameterInputValue> arrayList, Map<Integer, List<DataWrapper>> map, String string, String string2) {
        this.m_inputs = arrayList;
        this.m_pushedData = map;
        this.m_statementName = string;
        this.m_portalName = string2;
    }

    @Override
    public Object[] getDebugInfo() {
        Object[] objectArray = new Object[this.m_inputs.size() + 1];
        objectArray[0] = this.getType();
        for (int i = 1; i < objectArray.length; ++i) {
            ParameterInputValue parameterInputValue = this.m_inputs.get(i - 1);
            if (parameterInputValue.isPushed()) {
                objectArray[i] = "<pushed>";
                continue;
            }
            if (parameterInputValue.isDefaultValue()) {
                objectArray[i] = "<default>";
                continue;
            }
            if (parameterInputValue.isNull()) {
                objectArray[i] = "NULL";
                continue;
            }
            try {
                objectArray[i] = parameterInputValue.getData().getObject();
                continue;
            }
            catch (UtilsException utilsException) {
                // empty catch block
            }
        }
        return objectArray;
    }

    @Override
    protected void send(VStream vStream) throws IOException {
        Object object;
        int n;
        byte[] byArray = ProtocolUtils.encodeUTF8(this.m_portalName);
        byte[] byArray2 = ProtocolUtils.encodeUTF8(this.m_statementName);
        int n2 = this.m_inputs.size();
        long l = 4 + byArray2.length + 1 + byArray.length + 1 + 2 + 2 * n2 + 2;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            object = this.m_inputs.get(n);
            List<DataWrapper> list = ((ParameterInputValue)object).isPushed() ? this.m_pushedData.get(n) : null;
            short s = ((ParameterInputValue)object).getMetadata().getTypeMetadata().getType();
            ParameterMetadata parameterMetadata = ((ParameterInputValue)object).getMetadata();
            nArray[n] = parameterMetadata instanceof VParameterMetadata ? ((VParameterMetadata)parameterMetadata).getServerOID() : TypeUtils.getOIDFromSQLType(s);
            byte[] byArray3 = TypeUtils.serialize((ParameterInputValue)object, s, nArray[n], vStream.getConnection().getAddTzToTimestampParameters(), list, false);
            arrayList.add(byArray3);
            l += (long)(8 + (byArray3 == null ? 0 : byArray3.length));
        }
        if ((l += 2L) > 0x3FFFFFFFL) {
            throw new IOException(VDriver.s_msgSrc.loadMessage(Locale.getDefault(), 101, VMessageKey.ERROR_BIND_TOO_LONG.toString(), l + ""));
        }
        vStream.SendChar(66);
        vStream.SendInteger4((int)l);
        vStream.Send(byArray);
        vStream.SendChar(0);
        vStream.Send(byArray2);
        vStream.SendChar(0);
        vStream.SendInteger2(n2);
        for (n = 0; n < n2; ++n) {
            vStream.SendInteger2(0);
        }
        vStream.SendInteger2(n2);
        for (n = 0; n < n2; ++n) {
            vStream.SendInteger4(nArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            object = (byte[])arrayList.get(n);
            if (object == null) {
                vStream.SendInteger4(-1);
                continue;
            }
            vStream.SendInteger4(((Object)object).length);
            vStream.Send((byte[])object);
        }
        vStream.SendInteger2(0);
    }

    @Override
    public MessageType getType() {
        return MessageType.Bind;
    }
}

