/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.exceptions.OptionalFeatureNotImplementedException;
import com.vertica.dsi.security.IIntegratedSecurityManager;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import javax.naming.OperationNotSupportedException;

public abstract class DSIEnvironment
implements IEnvironment {
    private AttributeDataMap m_settings = new AttributeDataMap();
    private IDriver m_parentDriver = null;
    private IWarningListener m_warningListener = null;

    public DSIEnvironment(IDriver iDriver) throws ErrorException {
        this.m_parentDriver = iDriver;
        LogUtilities.logFunctionEntrance(this.getLog(), iDriver);
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
    }

    public IConnection createConnection(IIntegratedSecurityManager iIntegratedSecurityManager) throws ErrorException, OperationNotSupportedException {
        throw new OperationNotSupportedException();
    }

    public IMessageSource getMessageSource() {
        return this.m_parentDriver.getMessageSource();
    }

    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n);
        if (null == this.m_settings) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.m_settings.isProperty(n)) {
            return this.m_settings.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    public void setProperty(int n, Variant variant) throws OptionalFeatureNotImplementedException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), n, variant);
        if (null == this.m_settings) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (1 == n && variant.getType() == 6) {
            try {
                if (variant.getLong() == 0L) {
                    throw new OptionalFeatureNotImplementedException(2, DSIMessageKey.OPTIONAL_FEAT_NOT_IMPL.name(), String.valueOf(n));
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
            }
        }
        this.m_settings.setProperty(n, variant);
    }

    public ILogger getLog() {
        return this.m_parentDriver.getDriverLog();
    }

    public IDriver getParentDriver() {
        return this.m_parentDriver;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(1, 3, 1L);
        this.m_settings.setProperty(2, 2, Character.valueOf('\u0000'));
        this.m_settings.setProperty(3, 6, 3);
    }
}

