/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.core.VConnection;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dataengine.SimpleQueryExecutor;
import com.vertica.dataengine.VResultSet;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.CursorType;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataColumnFactory;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.util.TypeUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMetadataSource
implements IMetadataSource {
    private VConnection m_connection;
    private SimpleQueryExecutor m_queryExecutor;
    private MetadataSourceID m_type;
    private DSILogger m_log;
    private IResultSet m_results;
    private Map<MetadataSourceColumnTag, String> m_restrictions;
    private ArrayList<? extends IColumn> m_rowDescription;
    private ArrayList m_sdkRowDescription;
    private String m_escapeChar;
    private EnumMap<MetadataSourceColumnTag, Integer> m_colNameIndexMap;
    private boolean m_filterAsIdentifier;

    public VMetadataSource(VConnection vConnection, MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        this(vConnection, metadataSourceID, map, string, string2, bl, null);
    }

    public VMetadataSource(VConnection vConnection, MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl, VResultSet vResultSet) throws ErrorException {
        this.m_connection = vConnection;
        this.m_log = vConnection.getConnectionLog();
        this.m_queryExecutor = new SimpleQueryExecutor(vConnection);
        this.m_restrictions = map;
        this.m_type = metadataSourceID;
        this.m_filterAsIdentifier = bl;
        if (string == null || string.equals("\\")) {
            string = "\\\\";
        }
        this.m_escapeChar = string;
        this.m_results = vResultSet == null ? this.runMetadataQuery() : new VMetadataResultSet(vResultSet.getSelectColumns(), vResultSet.getRows());
        this.m_rowDescription = this.m_results.getSelectColumns();
        this.m_colNameIndexMap = new EnumMap(MetadataSourceColumnTag.class);
        for (int i = 0; i < this.m_rowDescription.size(); ++i) {
            IColumn iColumn = this.m_rowDescription.get(i);
            String string3 = iColumn.getName();
            this.m_colNameIndexMap.put(MetadataSourceColumnTag.valueOf(string3.toUpperCase()), i);
        }
        this.m_sdkRowDescription = MetadataColumnFactory.createMetadataColumns(this.m_connection.createStatement(), metadataSourceID);
        if (this.m_type.equals((Object)MetadataSourceID.SPECIAL_COLUMNS)) {
            this.m_sdkRowDescription.add(this.m_rowDescription.get(this.m_colNameIndexMap.get((Object)MetadataSourceColumnTag.SCHEMA_NAME)));
            this.m_sdkRowDescription.add(this.m_rowDescription.get(this.m_colNameIndexMap.get((Object)MetadataSourceColumnTag.TABLE_NAME)));
            this.m_sdkRowDescription.add(this.m_rowDescription.get(this.m_colNameIndexMap.get((Object)MetadataSourceColumnTag.CATALOG_NAME)));
        }
    }

    private VResultSet runMetadataQuery() throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(512);
        String string = this.makeWhereClause();
        String string2 = this.m_connection.getCatalogName();
        stringBuilder.append("select * from (");
        switch (this.m_type) {
            case CATALOG_ONLY: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name");
                break;
            }
            case CATALOG_SCHEMA_ONLY: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, name as schema_name from v_internal.vs_schemata where name <> 'v_internal' order by catalog_name, schema_name");
                break;
            }
            case COLUMNS: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, schema_name, table_name, column_name, case when sql_datetime_sub = 10 then 1111 else data_type end as data_type, data_type_name, column_size, buffer_length, decimal_digits, num_prec_radix, nullable, remarks, column_default as column_def, sql_type_id as sql_data_type, sql_datetime_sub, char_octet_length, ordinal_position, is_nullable from v_catalog.odbc_columns ");
                stringBuilder.append("order by catalog_name, schema_name, table_name, ordinal_position asc");
                break;
            }
            case COLUMN_PRIVILEGES: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, vs_grants.table_schema as schema_name, vs_grants.table_name, vs_columns.attname as column_name, vs_grants.grantor, vs_grants.grantee, vs_grants.privileges_description as privilege, case when (vs_grants.privileges <= 65536) then 'NO' else 'YES' end as isgrantable");
                stringBuilder.append(" from v_internal.vs_grants, v_internal.vs_tables, v_internal.vs_columns where vs_grants.object_id = vs_tables.oid and vs_tables.oid = vs_columns.oid ");
                stringBuilder.append(" order by catalog_name, schema_name, table_name, column_name, privilege");
                break;
            }
            case FOREIGN_KEYS: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as primary_key_catalog_name, primary_keys.table_schema as primary_key_schema_name, primary_keys.table_name as primary_key_table_name, primary_keys.column_name as primary_key_column_name, ");
                stringBuilder.append(string2);
                stringBuilder.append(" as foreign_key_catalog_name, foreign_keys.table_schema as foreign_key_schema_name, foreign_keys.table_name as foreign_key_table_name, foreign_keys.column_name as foreign_key_column_name, ");
                stringBuilder.append("primary_keys.ordinal_position as key_seq, 3 as foreign_key_update_rule, 3 as foreign_key_delete_rule, foreign_keys.constraint_name as foreign_key_name, primary_keys.constraint_name as primary_key_name, -1 as deferrability ");
                stringBuilder.append("from v_catalog.primary_keys join v_catalog.foreign_keys on primary_keys.table_name = foreign_keys.reference_table_name and primary_keys.table_schema = foreign_keys.reference_table_schema and primary_keys.column_name = foreign_keys.reference_column_name ");
                if (string.contains("PRIMARY_KEY")) {
                    stringBuilder.append("order by primary_key_catalog_name, primary_key_schema_name, primary_key_table_name, key_seq");
                    break;
                }
                stringBuilder.append("order by foreign_key_catalog_name, foreign_key_schema_name, foreign_key_table_name, key_seq");
                break;
            }
            case PRIMARY_KEYS: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as primary_key_catalog_name, table_schema as primary_key_schema_name, table_name as primary_key_table_name, column_name as primary_key_column_name, ordinal_position as key_seq, constraint_name as primary_key_name from v_catalog.primary_keys ");
                stringBuilder.append("order by primary_key_catalog_name, primary_key_schema_name, primary_key_table_name, key_seq");
                break;
            }
            case PROCEDURES: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, schema_name, function_name as procedure_name, ");
                stringBuilder.append("0 as num_input_params, 0 as num_output_params, 0 as num_result_sets, function_definition as remarks, 2 as procedure_type ");
                stringBuilder.append("from v_catalog.user_functions union all ");
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, schema_name as procedure_schema, function_name as procedure_name, ");
                stringBuilder.append("0 as num_input_params, 0 as num_output_params, 0 as num_result_sets, function_definition as remarks, 2 as procedure_type ");
                stringBuilder.append("from v_catalog.user_transforms ");
                stringBuilder.append("order by catalog_name, schema_name, procedure_name");
                break;
            }
            case PROCEDURE_COLUMNS: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, proc_schema as schema_name, proc_name as procedure_name, ");
                stringBuilder.append("column_name, column_type as procedure_column_type, case when sql_datetime_sub = 10 then 1111 else data_type end as data_type, type_name as data_type_name, column_size, buffer_length, decimal_digits, num_prec_radix, nullable, remarks ");
                stringBuilder.append("from v_internal.odbc_procedure_columns ");
                stringBuilder.append("order by catalog_name, schema_name, procedure_name, procedure_column_type");
                break;
            }
            case SPECIAL_COLUMNS: {
                stringBuilder.append("select ");
                stringBuilder.append(2);
                stringBuilder.append(" as scope, primary_keys.column_name, case when sql_datetime_sub = 10 then 1111 else data_type end as data_type, data_type_name, column_size, buffer_length, decimal_digits, ");
                stringBuilder.append(1);
                stringBuilder.append(" as pseudo, ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, primary_keys.table_schema as schema_name, primary_keys.table_name as table_name");
                stringBuilder.append(" from v_catalog.primary_keys join v_catalog.odbc_columns on primary_keys.table_schema = odbc_columns.schema_name and primary_keys.table_name = odbc_columns.table_name and primary_keys.column_name = odbc_columns.column_name");
                break;
            }
            case SCHEMA_ONLY: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, name as schema_name from v_internal.vs_schemata where schema_name <> 'v_internal' order by schema_name");
                break;
            }
            case TABLES: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, schema_name, table_name, table_type, remarks from v_catalog.all_tables ");
                stringBuilder.append("order by table_type, catalog_name, schema_name, table_name");
                break;
            }
            case TABLE_PRIVILEGES: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, vs_grants.table_schema as schema_name, vs_grants.table_name, vs_grants.grantor, vs_grants.grantee, vs_grants.privileges_description as privilege, CASE WHEN (vs_grants.privileges <= 65536) THEN 'NO' ELSE 'YES' END as isgrantable from v_internal.vs_grants join v_internal.vs_tables on object_id = oid ");
                stringBuilder.append("order by catalog_name, schema_name, table_name, privilege, grantee");
                break;
            }
            case TABLETYPE_ONLY: {
                stringBuilder.append("select 'GLOBAL TEMPORARY' as table_type union all select 'LOCAL TEMPORARY' as table_type union all select 'SYSTEM TABLE' as table_type union all select 'TABLE' as table_type union all select 'VIEW' as table_type order by table_type");
                break;
            }
            case TYPE_INFO: {
                stringBuilder.append("select type_name as data_type_name, case odbc_type when 9 then odbc_subtype when 10 then 1111 else odbc_type end as data_type, column_size, case when odbc_type in (-5, 2, 8) then null else E'\\'' end as literal_prefix, case when odbc_type in (-5, 2, 8) then null else E'\\'' end as literal_suffix, creation_parameters as create_param, 1 as nullable, 1 as case_sensitive, 3 as searchable, 0 as unsigned_attribute, case odbc_type when 2 then 1 else 0 end as fixed_prec_scale, 0 as auto_unique, type_name as local_type_name, min_scale as minimum_scale, max_scale as maximum_scale, odbc_type as sql_data_type, odbc_subtype as sql_datetime_sub, 10 as num_prec_radix from v_catalog.types order by odbc_type, odbc_subtype");
                break;
            }
            default: {
                LogUtilities.logError("Unknown metadata type: " + (Object)((Object)this.m_type), (ILogger)this.m_log);
            }
        }
        stringBuilder.append(") as vmd ");
        stringBuilder.append(string);
        VResultSet vResultSet = this.m_queryExecutor.execute(stringBuilder.toString());
        this.m_results = vResultSet;
        return vResultSet;
    }

    public IResultSet getResultSet() {
        return this.m_results;
    }

    private String makeWhereClause() {
        StringBuilder stringBuilder = new StringBuilder(256);
        boolean bl = false;
        String string = "escape E'" + this.m_escapeChar + "'";
        for (Map.Entry<MetadataSourceColumnTag, String> entry : this.m_restrictions.entrySet()) {
            MetadataSourceColumnTag metadataSourceColumnTag = entry.getKey();
            if (!bl) {
                stringBuilder.append("where ");
            } else {
                stringBuilder.append("and ");
            }
            String string2 = this.getComparisonOperator(metadataSourceColumnTag);
            stringBuilder.append(metadataSourceColumnTag.toString());
            stringBuilder.append(" ");
            stringBuilder.append(string2);
            stringBuilder.append(" ");
            this.writeFilterValue(entry, stringBuilder);
            if (string2.endsWith("like")) {
                stringBuilder.append(" ");
                stringBuilder.append(string);
            }
            stringBuilder.append(" ");
            bl = true;
        }
        return stringBuilder.toString();
    }

    private void writeFilterValue(Map.Entry<MetadataSourceColumnTag, String> entry, StringBuilder stringBuilder) {
        String string = entry.getValue();
        switch (entry.getKey()) {
            case TABLE_TYPE: {
                String[] stringArray = string.split(",");
                stringBuilder.append("(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append("'");
                    stringBuilder.append(stringArray[i].toUpperCase());
                    stringBuilder.append("'");
                    if (i >= stringArray.length - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
                break;
            }
            default: {
                stringBuilder.append("'");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("'");
            }
        }
    }

    private String getComparisonOperator(MetadataSourceColumnTag metadataSourceColumnTag) {
        switch (metadataSourceColumnTag) {
            case SCOPE: {
                return "=";
            }
            case CATALOG_NAME: 
            case COLUMN_NAME: 
            case CREATE_PARAM: 
            case DATA_TYPE_NAME: 
            case FOREIGN_KEY_CATALOG_NAME: 
            case FOREIGN_KEY_COLUMN_NAME: 
            case FOREIGN_KEY_NAME: 
            case FOREIGN_KEY_SCHEMA_NAME: 
            case GRANTEE: 
            case GRANTOR: 
            case INDEX_NAME: 
            case ISGRANTABLE: 
            case LITERAL_PREFIX: 
            case LITERAL_SUFFIX: 
            case LOCAL_TYPE_NAME: 
            case PRIMARY_KEY_CATALOG_NAME: 
            case PRIMARY_KEY_COLUMN_NAME: 
            case PRIMARY_KEY_NAME: 
            case PRIMARY_KEY_SCHEMA_NAME: 
            case PRIMARY_KEY_TABLE_NAME: 
            case PROCEDURE_NAME: 
            case REMARKS: 
            case SCHEMA_NAME: 
            case TABLE_NAME: {
                return this.m_filterAsIdentifier ? "=" : "ilike";
            }
            case TABLE_TYPE: {
                return "in";
            }
        }
        return "=";
    }

    @Override
    public void close() {
        this.m_results.close();
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_results.closeCursor();
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        Integer n = this.m_colNameIndexMap.get((Object)metadataSourceColumnTag);
        assert (n != null);
        if (n == null) {
            return false;
        }
        boolean bl = this.m_results.getData(n, l, l2, dataWrapper);
        this.checkAndConvertLargeTypes(metadataSourceColumnTag, dataWrapper);
        return bl;
    }

    private void checkAndConvertLargeTypes(MetadataSourceColumnTag metadataSourceColumnTag, DataWrapper dataWrapper) {
        block9: {
            if (!dataWrapper.isNull()) {
                int n = 0;
                for (Object e : this.m_sdkRowDescription) {
                    IColumn iColumn = (IColumn)e;
                    if (!metadataSourceColumnTag.toString().equalsIgnoreCase(iColumn.getName())) continue;
                    n = iColumn.getTypeMetadata().getType();
                }
                try {
                    switch (n) {
                        case -6: {
                            dataWrapper.setTinyInt(Short.valueOf(dataWrapper.getVarChar()));
                            break;
                        }
                        case 5: {
                            dataWrapper.setSmallInt(Integer.valueOf(dataWrapper.getVarChar()));
                            break;
                        }
                        case 7: {
                            dataWrapper.setReal(Float.valueOf(dataWrapper.getVarChar()));
                        }
                    }
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        return this.m_results.hasMoreRows();
    }

    @Override
    public boolean moveToNextRow() {
        try {
            return this.m_results.moveToNextRow();
        }
        catch (ErrorException errorException) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VMetadataResultSet
    implements IResultSet {
        private final ArrayList<? extends IColumn> m_rowDescription;
        private final ArrayList<byte[][]> m_rows;
        private int m_rowIdx;
        private Object m_rowIdxLock;
        private final int m_numRows;

        public VMetadataResultSet(ArrayList<ColumnDescription> arrayList, ArrayList<byte[][]> arrayList2) {
            this.m_rowDescription = arrayList;
            this.m_rows = arrayList2;
            this.m_numRows = arrayList2.size();
            this.m_rowIdx = -1;
            this.m_rowIdxLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws GeneralException {
            ColumnDescription columnDescription = (ColumnDescription)this.m_rowDescription.get(n);
            byte[][] byArray = null;
            Object object = this.m_rowIdxLock;
            synchronized (object) {
                byArray = this.m_rows.get(this.m_rowIdx);
            }
            return TypeUtils.deserialize(columnDescription.getSQLType(), columnDescription.getTypeOID(), columnDescription.getTypeMod(), l, l2, dataWrapper, byArray[n]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreRows() {
            Object object = this.m_rowIdxLock;
            synchronized (object) {
                return this.m_rowIdx != this.m_numRows - 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveToNextRow() {
            Object object = this.m_rowIdxLock;
            synchronized (object) {
                if (this.m_rowIdx < this.m_numRows - 1) {
                    ++this.m_rowIdx;
                    return this.m_rowIdx != this.m_numRows;
                }
                return false;
            }
        }

        @Override
        public ArrayList<? extends IColumn> getSelectColumns() {
            return this.m_rowDescription;
        }

        @Override
        public long getRowCount() {
            return this.m_rows.size();
        }

        @Override
        public boolean hasRowCount() {
            return true;
        }

        @Override
        public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) {
            return false;
        }

        @Override
        public boolean rowDeleted() {
            return false;
        }

        @Override
        public boolean rowInserted() {
            return false;
        }

        @Override
        public boolean rowUpdated() {
            return false;
        }

        @Override
        public int getFetchSize() {
            return 0;
        }

        @Override
        public void appendRow() {
        }

        @Override
        public void close() {
        }

        @Override
        public void closeCursor() {
        }

        @Override
        public void deleteRow() {
        }

        @Override
        public void onFinishRowUpdate() {
        }

        @Override
        public void onStartRowUpdate() {
        }

        @Override
        public void setCursorType(CursorType cursorType) {
        }

        @Override
        public void setFetchSize(int n) {
        }

        @Override
        public void registerWarningListener(IWarningListener iWarningListener) {
        }
    }
}

